# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...non_insurance_payers.resources.v_1.types.non_insurance_payer import NonInsurancePayer
from .patient_clinical_trial_info import PatientClinicalTrialInfo


class PatientNonInsurancePayerInfo(UniversalBaseModel):
    """
    Examples
    --------
    import uuid

    from candid.resources.commons import State, StreetAddressShortZip
    from candid.resources.individual import PatientNonInsurancePayerInfo
    from candid.resources.non_insurance_payers.resources.v_1 import (
        NonInsurancePayer,
    )

    PatientNonInsurancePayerInfo(
        non_insurance_payer=NonInsurancePayer(
            non_insurance_payer_id=uuid.UUID(
                "eb7623ab-d5bc-4b25-b257-2b8fcec578de",
            ),
            name="Sunrise Foundation",
            category="Foundation",
            description="Sunrise Foundation is a non-profit organization that provides financial assistance to patients in need.",
            enabled=True,
            address=StreetAddressShortZip(
                address_1="123 Main St",
                city="San Francisco",
                state=State.CA,
                zip_code="94105",
            ),
            clinical_trials=[],
        ),
        member_id="123456789",
        clinical_trial_info=[],
    )
    """

    non_insurance_payer: NonInsurancePayer
    member_id: typing.Optional[str] = None
    clinical_trial_info: typing.List[PatientClinicalTrialInfo] = pydantic.Field()
    """
    A patient cannot be associated with a given trial more than once
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
