# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.insurance_adjudication import InsuranceAdjudication
from .types.insurance_adjudication_create import InsuranceAdjudicationCreate
from .types.insurance_adjudication_id import InsuranceAdjudicationId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def get(
        self,
        insurance_adjudication_id: InsuranceAdjudicationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InsuranceAdjudication:
        """
        Retrieves a previously created insurance adjudication by its `insurance_adjudication_id`.

        Parameters
        ----------
        insurance_adjudication_id : InsuranceAdjudicationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceAdjudication

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.insurance_adjudications.v_1.get(
            insurance_adjudication_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(insurance_adjudication_id, request_options=request_options)
        return _response.data

    def create(
        self, *, request: InsuranceAdjudicationCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> InsuranceAdjudication:
        """
        Creates a new insurance adjudication record and returns the newly created InsuranceAdjudication object.

        Parameters
        ----------
        request : InsuranceAdjudicationCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceAdjudication

        Examples
        --------
        import datetime
        import uuid

        from candid import CandidApiClient
        from candid.resources.commons import ClaimAdjustmentGroupCodes
        from candid.resources.era_commons import ClaimStatusCodeCreate
        from candid.resources.insurance_adjudications.resources.v_1 import (
            ClaimAdjudicationCreate,
            InsuranceAdjudicationCreate,
            ServiceLineAdjudicationCreate,
        )
        from candid.resources.payers.resources.v_3 import PayerIdentifier_PayerInfo
        from candid.resources.remits.resources.v_1 import Payee, PayeeIdentifier_Npi
        from candid.resources.x_12.resources.v_1 import (
            Carc,
            ClaimAdjustmentReasonCode,
            Rarc,
            RemittanceAdviceRemarkCode,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.insurance_adjudications.v_1.create(
            request=InsuranceAdjudicationCreate(
                payer_identifier=PayerIdentifier_PayerInfo(
                    payer_id="payer_id",
                    payer_name="payer_name",
                ),
                payee=Payee(
                    payee_name="payee_name",
                    payee_identifier=PayeeIdentifier_Npi(value="payee_identifier"),
                ),
                check_date=datetime.date.fromisoformat(
                    "2023-01-15",
                ),
                claims={
                    uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ): [
                        ClaimAdjudicationCreate(
                            claim_status_code=ClaimStatusCodeCreate.PROCESSED_AS_PRIMARY,
                            service_lines={
                                uuid.UUID(
                                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                ): [
                                    ServiceLineAdjudicationCreate(
                                        carcs=[
                                            ClaimAdjustmentReasonCode(
                                                group_code=ClaimAdjustmentGroupCodes.CO,
                                                reason_code=Carc.CARC_1,
                                                amount_cents=1,
                                            ),
                                            ClaimAdjustmentReasonCode(
                                                group_code=ClaimAdjustmentGroupCodes.CO,
                                                reason_code=Carc.CARC_1,
                                                amount_cents=1,
                                            ),
                                        ],
                                        rarcs=[
                                            RemittanceAdviceRemarkCode(
                                                reason_code=Rarc.M_1,
                                            ),
                                            RemittanceAdviceRemarkCode(
                                                reason_code=Rarc.M_1,
                                            ),
                                        ],
                                    ),
                                    ServiceLineAdjudicationCreate(
                                        carcs=[
                                            ClaimAdjustmentReasonCode(
                                                group_code=ClaimAdjustmentGroupCodes.CO,
                                                reason_code=Carc.CARC_1,
                                                amount_cents=1,
                                            ),
                                            ClaimAdjustmentReasonCode(
                                                group_code=ClaimAdjustmentGroupCodes.CO,
                                                reason_code=Carc.CARC_1,
                                                amount_cents=1,
                                            ),
                                        ],
                                        rarcs=[
                                            RemittanceAdviceRemarkCode(
                                                reason_code=Rarc.M_1,
                                            ),
                                            RemittanceAdviceRemarkCode(
                                                reason_code=Rarc.M_1,
                                            ),
                                        ],
                                    ),
                                ]
                            },
                            carcs=[
                                ClaimAdjustmentReasonCode(
                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                    reason_code=Carc.CARC_1,
                                    amount_cents=1,
                                ),
                                ClaimAdjustmentReasonCode(
                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                    reason_code=Carc.CARC_1,
                                    amount_cents=1,
                                ),
                            ],
                        ),
                        ClaimAdjudicationCreate(
                            claim_status_code=ClaimStatusCodeCreate.PROCESSED_AS_PRIMARY,
                            service_lines={
                                uuid.UUID(
                                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                ): [
                                    ServiceLineAdjudicationCreate(
                                        carcs=[
                                            ClaimAdjustmentReasonCode(
                                                group_code=ClaimAdjustmentGroupCodes.CO,
                                                reason_code=Carc.CARC_1,
                                                amount_cents=1,
                                            ),
                                            ClaimAdjustmentReasonCode(
                                                group_code=ClaimAdjustmentGroupCodes.CO,
                                                reason_code=Carc.CARC_1,
                                                amount_cents=1,
                                            ),
                                        ],
                                        rarcs=[
                                            RemittanceAdviceRemarkCode(
                                                reason_code=Rarc.M_1,
                                            ),
                                            RemittanceAdviceRemarkCode(
                                                reason_code=Rarc.M_1,
                                            ),
                                        ],
                                    ),
                                    ServiceLineAdjudicationCreate(
                                        carcs=[
                                            ClaimAdjustmentReasonCode(
                                                group_code=ClaimAdjustmentGroupCodes.CO,
                                                reason_code=Carc.CARC_1,
                                                amount_cents=1,
                                            ),
                                            ClaimAdjustmentReasonCode(
                                                group_code=ClaimAdjustmentGroupCodes.CO,
                                                reason_code=Carc.CARC_1,
                                                amount_cents=1,
                                            ),
                                        ],
                                        rarcs=[
                                            RemittanceAdviceRemarkCode(
                                                reason_code=Rarc.M_1,
                                            ),
                                            RemittanceAdviceRemarkCode(
                                                reason_code=Rarc.M_1,
                                            ),
                                        ],
                                    ),
                                ]
                            },
                            carcs=[
                                ClaimAdjustmentReasonCode(
                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                    reason_code=Carc.CARC_1,
                                    amount_cents=1,
                                ),
                                ClaimAdjustmentReasonCode(
                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                    reason_code=Carc.CARC_1,
                                    amount_cents=1,
                                ),
                            ],
                        ),
                    ]
                },
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def delete(
        self,
        insurance_adjudication_id: InsuranceAdjudicationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Deletes the insurance adjudication record matching the provided insurance_adjudication_id.

        Parameters
        ----------
        insurance_adjudication_id : InsuranceAdjudicationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.insurance_adjudications.v_1.delete(
            insurance_adjudication_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete(insurance_adjudication_id, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def get(
        self,
        insurance_adjudication_id: InsuranceAdjudicationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InsuranceAdjudication:
        """
        Retrieves a previously created insurance adjudication by its `insurance_adjudication_id`.

        Parameters
        ----------
        insurance_adjudication_id : InsuranceAdjudicationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceAdjudication

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.insurance_adjudications.v_1.get(
                insurance_adjudication_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(insurance_adjudication_id, request_options=request_options)
        return _response.data

    async def create(
        self, *, request: InsuranceAdjudicationCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> InsuranceAdjudication:
        """
        Creates a new insurance adjudication record and returns the newly created InsuranceAdjudication object.

        Parameters
        ----------
        request : InsuranceAdjudicationCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceAdjudication

        Examples
        --------
        import asyncio
        import datetime
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.commons import ClaimAdjustmentGroupCodes
        from candid.resources.era_commons import ClaimStatusCodeCreate
        from candid.resources.insurance_adjudications.resources.v_1 import (
            ClaimAdjudicationCreate,
            InsuranceAdjudicationCreate,
            ServiceLineAdjudicationCreate,
        )
        from candid.resources.payers.resources.v_3 import PayerIdentifier_PayerInfo
        from candid.resources.remits.resources.v_1 import Payee, PayeeIdentifier_Npi
        from candid.resources.x_12.resources.v_1 import (
            Carc,
            ClaimAdjustmentReasonCode,
            Rarc,
            RemittanceAdviceRemarkCode,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.insurance_adjudications.v_1.create(
                request=InsuranceAdjudicationCreate(
                    payer_identifier=PayerIdentifier_PayerInfo(
                        payer_id="payer_id",
                        payer_name="payer_name",
                    ),
                    payee=Payee(
                        payee_name="payee_name",
                        payee_identifier=PayeeIdentifier_Npi(value="payee_identifier"),
                    ),
                    check_date=datetime.date.fromisoformat(
                        "2023-01-15",
                    ),
                    claims={
                        uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ): [
                            ClaimAdjudicationCreate(
                                claim_status_code=ClaimStatusCodeCreate.PROCESSED_AS_PRIMARY,
                                service_lines={
                                    uuid.UUID(
                                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                    ): [
                                        ServiceLineAdjudicationCreate(
                                            carcs=[
                                                ClaimAdjustmentReasonCode(
                                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                                    reason_code=Carc.CARC_1,
                                                    amount_cents=1,
                                                ),
                                                ClaimAdjustmentReasonCode(
                                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                                    reason_code=Carc.CARC_1,
                                                    amount_cents=1,
                                                ),
                                            ],
                                            rarcs=[
                                                RemittanceAdviceRemarkCode(
                                                    reason_code=Rarc.M_1,
                                                ),
                                                RemittanceAdviceRemarkCode(
                                                    reason_code=Rarc.M_1,
                                                ),
                                            ],
                                        ),
                                        ServiceLineAdjudicationCreate(
                                            carcs=[
                                                ClaimAdjustmentReasonCode(
                                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                                    reason_code=Carc.CARC_1,
                                                    amount_cents=1,
                                                ),
                                                ClaimAdjustmentReasonCode(
                                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                                    reason_code=Carc.CARC_1,
                                                    amount_cents=1,
                                                ),
                                            ],
                                            rarcs=[
                                                RemittanceAdviceRemarkCode(
                                                    reason_code=Rarc.M_1,
                                                ),
                                                RemittanceAdviceRemarkCode(
                                                    reason_code=Rarc.M_1,
                                                ),
                                            ],
                                        ),
                                    ]
                                },
                                carcs=[
                                    ClaimAdjustmentReasonCode(
                                        group_code=ClaimAdjustmentGroupCodes.CO,
                                        reason_code=Carc.CARC_1,
                                        amount_cents=1,
                                    ),
                                    ClaimAdjustmentReasonCode(
                                        group_code=ClaimAdjustmentGroupCodes.CO,
                                        reason_code=Carc.CARC_1,
                                        amount_cents=1,
                                    ),
                                ],
                            ),
                            ClaimAdjudicationCreate(
                                claim_status_code=ClaimStatusCodeCreate.PROCESSED_AS_PRIMARY,
                                service_lines={
                                    uuid.UUID(
                                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                    ): [
                                        ServiceLineAdjudicationCreate(
                                            carcs=[
                                                ClaimAdjustmentReasonCode(
                                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                                    reason_code=Carc.CARC_1,
                                                    amount_cents=1,
                                                ),
                                                ClaimAdjustmentReasonCode(
                                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                                    reason_code=Carc.CARC_1,
                                                    amount_cents=1,
                                                ),
                                            ],
                                            rarcs=[
                                                RemittanceAdviceRemarkCode(
                                                    reason_code=Rarc.M_1,
                                                ),
                                                RemittanceAdviceRemarkCode(
                                                    reason_code=Rarc.M_1,
                                                ),
                                            ],
                                        ),
                                        ServiceLineAdjudicationCreate(
                                            carcs=[
                                                ClaimAdjustmentReasonCode(
                                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                                    reason_code=Carc.CARC_1,
                                                    amount_cents=1,
                                                ),
                                                ClaimAdjustmentReasonCode(
                                                    group_code=ClaimAdjustmentGroupCodes.CO,
                                                    reason_code=Carc.CARC_1,
                                                    amount_cents=1,
                                                ),
                                            ],
                                            rarcs=[
                                                RemittanceAdviceRemarkCode(
                                                    reason_code=Rarc.M_1,
                                                ),
                                                RemittanceAdviceRemarkCode(
                                                    reason_code=Rarc.M_1,
                                                ),
                                            ],
                                        ),
                                    ]
                                },
                                carcs=[
                                    ClaimAdjustmentReasonCode(
                                        group_code=ClaimAdjustmentGroupCodes.CO,
                                        reason_code=Carc.CARC_1,
                                        amount_cents=1,
                                    ),
                                    ClaimAdjustmentReasonCode(
                                        group_code=ClaimAdjustmentGroupCodes.CO,
                                        reason_code=Carc.CARC_1,
                                        amount_cents=1,
                                    ),
                                ],
                            ),
                        ]
                    },
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def delete(
        self,
        insurance_adjudication_id: InsuranceAdjudicationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Deletes the insurance adjudication record matching the provided insurance_adjudication_id.

        Parameters
        ----------
        insurance_adjudication_id : InsuranceAdjudicationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.insurance_adjudications.v_1.delete(
                insurance_adjudication_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(insurance_adjudication_id, request_options=request_options)
        return _response.data
