# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....era.errors.era_not_fully_processed_error import EraNotFullyProcessedError
from ....era.types.era_not_fully_processed_error_message import EraNotFullyProcessedErrorMessage
from .types.insurance_adjudication import InsuranceAdjudication
from .types.insurance_adjudication_create import InsuranceAdjudicationCreate
from .types.insurance_adjudication_id import InsuranceAdjudicationId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        insurance_adjudication_id: InsuranceAdjudicationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[InsuranceAdjudication]:
        """
        Retrieves a previously created insurance adjudication by its `insurance_adjudication_id`.

        Parameters
        ----------
        insurance_adjudication_id : InsuranceAdjudicationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InsuranceAdjudication]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/insurance-adjudications/v1/{jsonable_encoder(insurance_adjudication_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                InsuranceAdjudication,
                parse_obj_as(
                    type_=InsuranceAdjudication,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self, *, request: InsuranceAdjudicationCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[InsuranceAdjudication]:
        """
        Creates a new insurance adjudication record and returns the newly created InsuranceAdjudication object.

        Parameters
        ----------
        request : InsuranceAdjudicationCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InsuranceAdjudication]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/insurance-adjudications/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                InsuranceAdjudication,
                parse_obj_as(
                    type_=InsuranceAdjudication,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EraNotFullyProcessedError":
                raise EraNotFullyProcessedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EraNotFullyProcessedErrorMessage,
                        parse_obj_as(
                            type_=EraNotFullyProcessedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self,
        insurance_adjudication_id: InsuranceAdjudicationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Deletes the insurance adjudication record matching the provided insurance_adjudication_id.

        Parameters
        ----------
        insurance_adjudication_id : InsuranceAdjudicationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/insurance-adjudications/v1/{jsonable_encoder(insurance_adjudication_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return HttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        insurance_adjudication_id: InsuranceAdjudicationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[InsuranceAdjudication]:
        """
        Retrieves a previously created insurance adjudication by its `insurance_adjudication_id`.

        Parameters
        ----------
        insurance_adjudication_id : InsuranceAdjudicationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InsuranceAdjudication]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/insurance-adjudications/v1/{jsonable_encoder(insurance_adjudication_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                InsuranceAdjudication,
                parse_obj_as(
                    type_=InsuranceAdjudication,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self, *, request: InsuranceAdjudicationCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[InsuranceAdjudication]:
        """
        Creates a new insurance adjudication record and returns the newly created InsuranceAdjudication object.

        Parameters
        ----------
        request : InsuranceAdjudicationCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InsuranceAdjudication]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/insurance-adjudications/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                InsuranceAdjudication,
                parse_obj_as(
                    type_=InsuranceAdjudication,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EraNotFullyProcessedError":
                raise EraNotFullyProcessedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EraNotFullyProcessedErrorMessage,
                        parse_obj_as(
                            type_=EraNotFullyProcessedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self,
        insurance_adjudication_id: InsuranceAdjudicationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Deletes the insurance adjudication record matching the provided insurance_adjudication_id.

        Parameters
        ----------
        insurance_adjudication_id : InsuranceAdjudicationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/insurance-adjudications/v1/{jsonable_encoder(insurance_adjudication_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return AsyncHttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
