# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.claim_id import ClaimId
from .....payers.resources.v_3.types.payer_identifier import PayerIdentifier
from .....remit_drafts.resources.v_1.types.remit_draft_id import RemitDraftId
from .....remits.resources.v_1.types.payee import Payee
from .claim_adjudication_create import ClaimAdjudicationCreate


class InsuranceAdjudicationCreate(UniversalBaseModel):
    payer_identifier: PayerIdentifier
    payee: Payee
    post_date: typing.Optional[dt.date] = None
    check_number: typing.Optional[str] = None
    check_date: dt.date
    check_amount_cents: typing.Optional[int] = None
    note: typing.Optional[str] = None
    claims: typing.Dict[ClaimId, typing.List[ClaimAdjudicationCreate]]
    remit_draft_id: typing.Optional[RemitDraftId] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
