# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
from .insurance_card_base import InsuranceCardBase
from .insurance_card_id import InsuranceCardId


class InsuranceCard(InsuranceCardBase):
    """
    Examples
    --------
    import uuid

    from candid.resources.commons import InsuranceTypeCode, SourceOfPaymentCode
    from candid.resources.insurance_cards.resources.v_2 import InsuranceCard

    InsuranceCard(
        insurance_card_id=uuid.UUID(
            "ca5b7711-4419-4161-9b7c-3494ac40c8d4",
        ),
        member_id="E85313B4-0FFC-4119-8042-8161A4ECFF0A",
        payer_name="John Doe",
        payer_id="836DDAA6-863F-4020-ACCA-205A689F0002",
        rx_bin="610014",
        rx_pcn="MEDDPRIME",
        image_url_front="https://s3.amazonaws.com/front.jpg",
        image_url_back="https://s3.amazonaws.com/back.jpg",
        group_number="ABC12345",
        plan_name="Silver PPO Plan",
        plan_type=SourceOfPaymentCode.SELF_PAY,
        insurance_type=InsuranceTypeCode.C_12,
    )
    """

    insurance_card_id: InsuranceCardId
    member_id: str
    payer_name: str
    payer_id: str
    rx_bin: typing.Optional[str] = None
    rx_pcn: typing.Optional[str] = None
    image_url_front: typing.Optional[str] = None
    image_url_back: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
