# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.insurance_type_code import InsuranceTypeCode
from .....commons.types.payer_plan_group_id import PayerPlanGroupId
from .....commons.types.source_of_payment_code import SourceOfPaymentCode


class InsuranceCardBase(UniversalBaseModel):
    group_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Box 11 on the CMS-1500 claim form.
    """

    plan_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Box 11c on the CMS-1500 claim form.
    """

    plan_type: typing.Optional[SourceOfPaymentCode] = None
    insurance_type: typing.Optional[InsuranceTypeCode] = None
    payer_plan_group_id: typing.Optional[PayerPlanGroupId] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
