# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.claim_id import ClaimId
from ....commons.types.page_token import PageToken
from ....commons.types.provider_id import ProviderId
from ....commons.types.service_line_id import ServiceLineId
from ....commons.types.sort_direction import SortDirection
from ....financials.types.note_update import NoteUpdate
from ....financials.types.refund_reason_update import RefundReasonUpdate
from ....payers.resources.v_3.types.payer_uuid import PayerUuid
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.insurance_refund import InsuranceRefund
from .types.insurance_refund_create import InsuranceRefundCreate
from .types.insurance_refund_id import InsuranceRefundId
from .types.insurance_refund_sort_field import InsuranceRefundSortField
from .types.insurance_refunds_page import InsuranceRefundsPage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        claim_id: typing.Optional[ClaimId] = None,
        service_line_id: typing.Optional[ServiceLineId] = None,
        billing_provider_id: typing.Optional[ProviderId] = None,
        sort: typing.Optional[InsuranceRefundSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InsuranceRefundsPage:
        """
        Returns all insurance refunds satisfying the search criteria AND whose organization_id matches
        the current organization_id of the authenticated user.

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        payer_uuid : typing.Optional[PayerUuid]

        claim_id : typing.Optional[ClaimId]

        service_line_id : typing.Optional[ServiceLineId]

        billing_provider_id : typing.Optional[ProviderId]

        sort : typing.Optional[InsuranceRefundSortField]
            Defaults to refund_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceRefundsPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.insurance_refunds.v_1.get_multi()
        """
        _response = self._raw_client.get_multi(
            limit=limit,
            payer_uuid=payer_uuid,
            claim_id=claim_id,
            service_line_id=service_line_id,
            billing_provider_id=billing_provider_id,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, insurance_refund_id: InsuranceRefundId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InsuranceRefund:
        """
        Retrieves a previously created insurance refund by its `insurance_refund_id`.
        If the refund does not exist, a `403` will be thrown.

        Parameters
        ----------
        insurance_refund_id : InsuranceRefundId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceRefund

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.insurance_refunds.v_1.get(
            insurance_refund_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(insurance_refund_id, request_options=request_options)
        return _response.data

    def create(
        self, *, request: InsuranceRefundCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> InsuranceRefund:
        """
        Creates a new insurance refund record and returns the newly created `InsuranceRefund` object.
        The allocations can describe whether the refund is being applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        request : InsuranceRefundCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceRefund

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.financials import (
            AllocationCreate,
            AllocationTargetCreate_ServiceLineById,
        )
        from candid.resources.insurance_refunds.resources.v_1 import (
            InsuranceRefundCreate,
        )
        from candid.resources.payers.resources.v_3 import PayerIdentifier_PayerInfo

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.insurance_refunds.v_1.create(
            request=InsuranceRefundCreate(
                payer_identifier=PayerIdentifier_PayerInfo(
                    payer_id="payer_id",
                    payer_name="payer_name",
                ),
                amount_cents=1,
                allocations=[
                    AllocationCreate(
                        amount_cents=1,
                        target=AllocationTargetCreate_ServiceLineById(
                            value=uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            )
                        ),
                    ),
                    AllocationCreate(
                        amount_cents=1,
                        target=AllocationTargetCreate_ServiceLineById(
                            value=uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            )
                        ),
                    ),
                ],
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self,
        insurance_refund_id: InsuranceRefundId,
        *,
        refund_timestamp: typing.Optional[dt.datetime] = OMIT,
        refund_note: typing.Optional[NoteUpdate] = OMIT,
        refund_reason: typing.Optional[RefundReasonUpdate] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InsuranceRefund:
        """
        Updates the patient refund record matching the provided insurance_refund_id. If updating the refund amount,
        then the allocations must be appropriately updated as well.

        Parameters
        ----------
        insurance_refund_id : InsuranceRefundId

        refund_timestamp : typing.Optional[dt.datetime]

        refund_note : typing.Optional[NoteUpdate]

        refund_reason : typing.Optional[RefundReasonUpdate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceRefund

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.insurance_refunds.v_1.update(
            insurance_refund_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.update(
            insurance_refund_id,
            refund_timestamp=refund_timestamp,
            refund_note=refund_note,
            refund_reason=refund_reason,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self, insurance_refund_id: InsuranceRefundId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes the insurance refund record matching the provided `insurance_refund_id`.
        If the matching record's organization_id does not match the authenticated user's
        current organization_id, then a response code of `403` will be returned.

        Parameters
        ----------
        insurance_refund_id : InsuranceRefundId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.insurance_refunds.v_1.delete(
            insurance_refund_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete(insurance_refund_id, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        claim_id: typing.Optional[ClaimId] = None,
        service_line_id: typing.Optional[ServiceLineId] = None,
        billing_provider_id: typing.Optional[ProviderId] = None,
        sort: typing.Optional[InsuranceRefundSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InsuranceRefundsPage:
        """
        Returns all insurance refunds satisfying the search criteria AND whose organization_id matches
        the current organization_id of the authenticated user.

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        payer_uuid : typing.Optional[PayerUuid]

        claim_id : typing.Optional[ClaimId]

        service_line_id : typing.Optional[ServiceLineId]

        billing_provider_id : typing.Optional[ProviderId]

        sort : typing.Optional[InsuranceRefundSortField]
            Defaults to refund_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceRefundsPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.insurance_refunds.v_1.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            limit=limit,
            payer_uuid=payer_uuid,
            claim_id=claim_id,
            service_line_id=service_line_id,
            billing_provider_id=billing_provider_id,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, insurance_refund_id: InsuranceRefundId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InsuranceRefund:
        """
        Retrieves a previously created insurance refund by its `insurance_refund_id`.
        If the refund does not exist, a `403` will be thrown.

        Parameters
        ----------
        insurance_refund_id : InsuranceRefundId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceRefund

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.insurance_refunds.v_1.get(
                insurance_refund_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(insurance_refund_id, request_options=request_options)
        return _response.data

    async def create(
        self, *, request: InsuranceRefundCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> InsuranceRefund:
        """
        Creates a new insurance refund record and returns the newly created `InsuranceRefund` object.
        The allocations can describe whether the refund is being applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        request : InsuranceRefundCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceRefund

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.financials import (
            AllocationCreate,
            AllocationTargetCreate_ServiceLineById,
        )
        from candid.resources.insurance_refunds.resources.v_1 import (
            InsuranceRefundCreate,
        )
        from candid.resources.payers.resources.v_3 import PayerIdentifier_PayerInfo

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.insurance_refunds.v_1.create(
                request=InsuranceRefundCreate(
                    payer_identifier=PayerIdentifier_PayerInfo(
                        payer_id="payer_id",
                        payer_name="payer_name",
                    ),
                    amount_cents=1,
                    allocations=[
                        AllocationCreate(
                            amount_cents=1,
                            target=AllocationTargetCreate_ServiceLineById(
                                value=uuid.UUID(
                                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                )
                            ),
                        ),
                        AllocationCreate(
                            amount_cents=1,
                            target=AllocationTargetCreate_ServiceLineById(
                                value=uuid.UUID(
                                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                )
                            ),
                        ),
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self,
        insurance_refund_id: InsuranceRefundId,
        *,
        refund_timestamp: typing.Optional[dt.datetime] = OMIT,
        refund_note: typing.Optional[NoteUpdate] = OMIT,
        refund_reason: typing.Optional[RefundReasonUpdate] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InsuranceRefund:
        """
        Updates the patient refund record matching the provided insurance_refund_id. If updating the refund amount,
        then the allocations must be appropriately updated as well.

        Parameters
        ----------
        insurance_refund_id : InsuranceRefundId

        refund_timestamp : typing.Optional[dt.datetime]

        refund_note : typing.Optional[NoteUpdate]

        refund_reason : typing.Optional[RefundReasonUpdate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InsuranceRefund

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.insurance_refunds.v_1.update(
                insurance_refund_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            insurance_refund_id,
            refund_timestamp=refund_timestamp,
            refund_note=refund_note,
            refund_reason=refund_reason,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, insurance_refund_id: InsuranceRefundId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes the insurance refund record matching the provided `insurance_refund_id`.
        If the matching record's organization_id does not match the authenticated user's
        current organization_id, then a response code of `403` will be returned.

        Parameters
        ----------
        insurance_refund_id : InsuranceRefundId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.insurance_refunds.v_1.delete(
                insurance_refund_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(insurance_refund_id, request_options=request_options)
        return _response.data
