# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...commons.types.date import Date
from ...commons.types.invoice_id import InvoiceId
from ...commons.types.organization_id import OrganizationId
from ...commons.types.patient_external_id import PatientExternalId
from .invoice_item import InvoiceItem
from .invoice_status import InvoiceStatus


class Invoice(UniversalBaseModel):
    id: InvoiceId
    created_at: dt.datetime
    updated_at: dt.datetime
    organzation_id: OrganizationId
    source_id: str
    source_customer_id: str
    patient_external_id: PatientExternalId
    note: typing.Optional[str] = None
    due_date: Date
    status: InvoiceStatus
    url: typing.Optional[str] = None
    customer_invoice_url: typing.Optional[str] = None
    items: typing.List[InvoiceItem]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
