# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.entity_not_found_error import EntityNotFoundError
from ....commons.errors.http_request_validation_error import HttpRequestValidationError
from ....commons.types.entity_not_found_error_message import EntityNotFoundErrorMessage
from ....commons.types.request_validation_error import RequestValidationError
from ....encounters.resources.v_4.errors.encounter_external_id_uniqueness_error import (
    EncounterExternalIdUniquenessError,
)
from ....encounters.resources.v_4.errors.encounter_patient_control_number_uniqueness_error import (
    EncounterPatientControlNumberUniquenessError,
)
from ....encounters.resources.v_4.errors.invalid_tag_names_error import InvalidTagNamesError
from ....encounters.resources.v_4.errors.schema_instance_validation_http_failure import (
    SchemaInstanceValidationHttpFailure,
)
from ....encounters.resources.v_4.types.encounter import Encounter
from ....encounters.resources.v_4.types.encounter_external_id_uniqueness_error_type import (
    EncounterExternalIdUniquenessErrorType,
)
from ....encounters.resources.v_4.types.encounter_patient_control_number_uniqueness_error_type import (
    EncounterPatientControlNumberUniquenessErrorType,
)
from ....encounters.resources.v_4.types.invalid_tag_names_error_type import InvalidTagNamesErrorType
from ....encounters.resources.v_4.types.schema_instance_validation_failure import SchemaInstanceValidationFailure
from .types.medication_dispense_create import MedicationDispenseCreate

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self, *, request: MedicationDispenseCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Encounter]:
        """
        Parameters
        ----------
        request : MedicationDispenseCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Encounter]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/medication-dispense/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                Encounter,
                parse_obj_as(
                    type_=Encounter,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationError":
                raise HttpRequestValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        RequestValidationError,
                        parse_obj_as(
                            type_=RequestValidationError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EncounterExternalIdUniquenessError":
                raise EncounterExternalIdUniquenessError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EncounterExternalIdUniquenessErrorType,
                        parse_obj_as(
                            type_=EncounterExternalIdUniquenessErrorType,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EncounterPatientControlNumberUniquenessError":
                raise EncounterPatientControlNumberUniquenessError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EncounterPatientControlNumberUniquenessErrorType,
                        parse_obj_as(
                            type_=EncounterPatientControlNumberUniquenessErrorType,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "SchemaInstanceValidationHttpFailure":
                raise SchemaInstanceValidationHttpFailure(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        SchemaInstanceValidationFailure,
                        parse_obj_as(
                            type_=SchemaInstanceValidationFailure,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "InvalidTagNamesError":
                raise InvalidTagNamesError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        InvalidTagNamesErrorType,
                        parse_obj_as(
                            type_=InvalidTagNamesErrorType,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self, *, request: MedicationDispenseCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Encounter]:
        """
        Parameters
        ----------
        request : MedicationDispenseCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Encounter]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/medication-dispense/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                Encounter,
                parse_obj_as(
                    type_=Encounter,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationError":
                raise HttpRequestValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        RequestValidationError,
                        parse_obj_as(
                            type_=RequestValidationError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EncounterExternalIdUniquenessError":
                raise EncounterExternalIdUniquenessError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EncounterExternalIdUniquenessErrorType,
                        parse_obj_as(
                            type_=EncounterExternalIdUniquenessErrorType,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EncounterPatientControlNumberUniquenessError":
                raise EncounterPatientControlNumberUniquenessError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EncounterPatientControlNumberUniquenessErrorType,
                        parse_obj_as(
                            type_=EncounterPatientControlNumberUniquenessErrorType,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "SchemaInstanceValidationHttpFailure":
                raise SchemaInstanceValidationHttpFailure(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        SchemaInstanceValidationFailure,
                        parse_obj_as(
                            type_=SchemaInstanceValidationFailure,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "InvalidTagNamesError":
                raise InvalidTagNamesError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        InvalidTagNamesErrorType,
                        parse_obj_as(
                            type_=InvalidTagNamesErrorType,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
