# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.decimal import Decimal
from .....commons.types.procedure_modifier import ProcedureModifier
from .....commons.types.service_line_units import ServiceLineUnits
from .....service_lines.resources.v_2.types.drug_identification import DrugIdentification


class MedicationDispenseCreate(UniversalBaseModel):
    medication_dispense_external_id: str
    patient_external_id: str
    procedure_code: str
    quantity: Decimal
    units: ServiceLineUnits
    date_of_service: dt.date
    drug_identification: typing.Optional[DrugIdentification] = None
    description: typing.Optional[str] = None
    modifiers: typing.Optional[typing.List[ProcedureModifier]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
