# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.invoice_id import InvoiceId
from ....commons.types.page_token import PageToken
from ....commons.types.sort_direction import SortDirection
from ....financials.types.invoice_update import InvoiceUpdate
from ....financials.types.note_update import NoteUpdate
from ....financials.types.refund_reason_update import RefundReasonUpdate
from ....non_insurance_payers.resources.v_1.types.non_insurance_payer_id import NonInsurancePayerId
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.non_insurance_payer_refund import NonInsurancePayerRefund
from .types.non_insurance_payer_refund_create import NonInsurancePayerRefundCreate
from .types.non_insurance_payer_refund_id import NonInsurancePayerRefundId
from .types.non_insurance_payer_refund_sort_field import NonInsurancePayerRefundSortField
from .types.non_insurance_payer_refunds_page import NonInsurancePayerRefundsPage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        non_insurance_payer_id: typing.Optional[NonInsurancePayerId] = None,
        check_number: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        invoice_id: typing.Optional[InvoiceId] = None,
        sort: typing.Optional[NonInsurancePayerRefundSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NonInsurancePayerRefundsPage:
        """
        Returns all non-insurance payer refunds satisfying the search criteria

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        non_insurance_payer_id : typing.Optional[NonInsurancePayerId]

        check_number : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        invoice_id : typing.Optional[InvoiceId]

        sort : typing.Optional[NonInsurancePayerRefundSortField]
            Defaults to refund_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonInsurancePayerRefundsPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.non_insurance_payer_refunds.v_1.get_multi()
        """
        _response = self._raw_client.get_multi(
            limit=limit,
            non_insurance_payer_id=non_insurance_payer_id,
            check_number=check_number,
            invoice_id=invoice_id,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            request_options=request_options,
        )
        return _response.data

    def get(
        self,
        non_insurance_payer_refund_id: NonInsurancePayerRefundId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NonInsurancePayerRefund:
        """
        Retrieves a previously created non-insurance payer refund by its `non_insurance_payer_refund_id`.

        Parameters
        ----------
        non_insurance_payer_refund_id : NonInsurancePayerRefundId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonInsurancePayerRefund

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.non_insurance_payer_refunds.v_1.get(
            non_insurance_payer_refund_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(non_insurance_payer_refund_id, request_options=request_options)
        return _response.data

    def create(
        self, *, request: NonInsurancePayerRefundCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> NonInsurancePayerRefund:
        """
        Creates a new non-insurance payer refund record and returns the newly created `NonInsurancePayerRefund` object.
        The allocations can describe whether the refund is being applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        request : NonInsurancePayerRefundCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonInsurancePayerRefund

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.financials import (
            AllocationCreate,
            AllocationTargetCreate_ServiceLineById,
        )
        from candid.resources.non_insurance_payer_refunds.resources.v_1 import (
            NonInsurancePayerRefundCreate,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.non_insurance_payer_refunds.v_1.create(
            request=NonInsurancePayerRefundCreate(
                non_insurance_payer_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                amount_cents=1,
                allocations=[
                    AllocationCreate(
                        amount_cents=1,
                        target=AllocationTargetCreate_ServiceLineById(
                            value=uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            )
                        ),
                    ),
                    AllocationCreate(
                        amount_cents=1,
                        target=AllocationTargetCreate_ServiceLineById(
                            value=uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            )
                        ),
                    ),
                ],
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self,
        non_insurance_payer_refund_id: NonInsurancePayerRefundId,
        *,
        refund_timestamp: typing.Optional[dt.datetime] = OMIT,
        refund_note: typing.Optional[NoteUpdate] = OMIT,
        refund_reason: typing.Optional[RefundReasonUpdate] = OMIT,
        invoice_id: typing.Optional[InvoiceUpdate] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NonInsurancePayerRefund:
        """
        Updates the non-insurance payer refund record matching the provided non_insurance_payer_refund_id. If updating the refund amount,
        then the allocations must be appropriately updated as well.

        Parameters
        ----------
        non_insurance_payer_refund_id : NonInsurancePayerRefundId

        refund_timestamp : typing.Optional[dt.datetime]

        refund_note : typing.Optional[NoteUpdate]

        refund_reason : typing.Optional[RefundReasonUpdate]

        invoice_id : typing.Optional[InvoiceUpdate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonInsurancePayerRefund

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.non_insurance_payer_refunds.v_1.update(
            non_insurance_payer_refund_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.update(
            non_insurance_payer_refund_id,
            refund_timestamp=refund_timestamp,
            refund_note=refund_note,
            refund_reason=refund_reason,
            invoice_id=invoice_id,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self,
        non_insurance_payer_refund_id: NonInsurancePayerRefundId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Deletes the non-insurance payer refund record matching the provided `non_insurance_payer_refund_id`.

        Parameters
        ----------
        non_insurance_payer_refund_id : NonInsurancePayerRefundId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.non_insurance_payer_refunds.v_1.delete(
            non_insurance_payer_refund_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete(non_insurance_payer_refund_id, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        non_insurance_payer_id: typing.Optional[NonInsurancePayerId] = None,
        check_number: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        invoice_id: typing.Optional[InvoiceId] = None,
        sort: typing.Optional[NonInsurancePayerRefundSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NonInsurancePayerRefundsPage:
        """
        Returns all non-insurance payer refunds satisfying the search criteria

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        non_insurance_payer_id : typing.Optional[NonInsurancePayerId]

        check_number : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        invoice_id : typing.Optional[InvoiceId]

        sort : typing.Optional[NonInsurancePayerRefundSortField]
            Defaults to refund_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonInsurancePayerRefundsPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.non_insurance_payer_refunds.v_1.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            limit=limit,
            non_insurance_payer_id=non_insurance_payer_id,
            check_number=check_number,
            invoice_id=invoice_id,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self,
        non_insurance_payer_refund_id: NonInsurancePayerRefundId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NonInsurancePayerRefund:
        """
        Retrieves a previously created non-insurance payer refund by its `non_insurance_payer_refund_id`.

        Parameters
        ----------
        non_insurance_payer_refund_id : NonInsurancePayerRefundId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonInsurancePayerRefund

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.non_insurance_payer_refunds.v_1.get(
                non_insurance_payer_refund_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(non_insurance_payer_refund_id, request_options=request_options)
        return _response.data

    async def create(
        self, *, request: NonInsurancePayerRefundCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> NonInsurancePayerRefund:
        """
        Creates a new non-insurance payer refund record and returns the newly created `NonInsurancePayerRefund` object.
        The allocations can describe whether the refund is being applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        request : NonInsurancePayerRefundCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonInsurancePayerRefund

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.financials import (
            AllocationCreate,
            AllocationTargetCreate_ServiceLineById,
        )
        from candid.resources.non_insurance_payer_refunds.resources.v_1 import (
            NonInsurancePayerRefundCreate,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.non_insurance_payer_refunds.v_1.create(
                request=NonInsurancePayerRefundCreate(
                    non_insurance_payer_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    amount_cents=1,
                    allocations=[
                        AllocationCreate(
                            amount_cents=1,
                            target=AllocationTargetCreate_ServiceLineById(
                                value=uuid.UUID(
                                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                )
                            ),
                        ),
                        AllocationCreate(
                            amount_cents=1,
                            target=AllocationTargetCreate_ServiceLineById(
                                value=uuid.UUID(
                                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                                )
                            ),
                        ),
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self,
        non_insurance_payer_refund_id: NonInsurancePayerRefundId,
        *,
        refund_timestamp: typing.Optional[dt.datetime] = OMIT,
        refund_note: typing.Optional[NoteUpdate] = OMIT,
        refund_reason: typing.Optional[RefundReasonUpdate] = OMIT,
        invoice_id: typing.Optional[InvoiceUpdate] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NonInsurancePayerRefund:
        """
        Updates the non-insurance payer refund record matching the provided non_insurance_payer_refund_id. If updating the refund amount,
        then the allocations must be appropriately updated as well.

        Parameters
        ----------
        non_insurance_payer_refund_id : NonInsurancePayerRefundId

        refund_timestamp : typing.Optional[dt.datetime]

        refund_note : typing.Optional[NoteUpdate]

        refund_reason : typing.Optional[RefundReasonUpdate]

        invoice_id : typing.Optional[InvoiceUpdate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NonInsurancePayerRefund

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.non_insurance_payer_refunds.v_1.update(
                non_insurance_payer_refund_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            non_insurance_payer_refund_id,
            refund_timestamp=refund_timestamp,
            refund_note=refund_note,
            refund_reason=refund_reason,
            invoice_id=invoice_id,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self,
        non_insurance_payer_refund_id: NonInsurancePayerRefundId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Deletes the non-insurance payer refund record matching the provided `non_insurance_payer_refund_id`.

        Parameters
        ----------
        non_insurance_payer_refund_id : NonInsurancePayerRefundId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.non_insurance_payer_refunds.v_1.delete(
                non_insurance_payer_refund_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(non_insurance_payer_refund_id, request_options=request_options)
        return _response.data
