# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.entity_conflict_error import EntityConflictError
from ....commons.errors.entity_not_found_error import EntityNotFoundError
from ....commons.errors.unprocessable_entity_error import UnprocessableEntityError
from ....commons.types.entity_conflict_error_message import EntityConflictErrorMessage
from ....commons.types.entity_not_found_error_message import EntityNotFoundErrorMessage
from ....commons.types.page_token import PageToken
from ....commons.types.sort_direction import SortDirection
from ....commons.types.unprocessable_entity_error_message import UnprocessableEntityErrorMessage
from .types.create_non_insurance_payer_request import CreateNonInsurancePayerRequest
from .types.non_insurance_payer import NonInsurancePayer
from .types.non_insurance_payer_id import NonInsurancePayerId
from .types.non_insurance_payer_page import NonInsurancePayerPage
from .types.non_insurance_payer_sort_field import NonInsurancePayerSortField
from .types.non_insurance_payer_update_request import NonInsurancePayerUpdateRequest
from .types.toggle_non_insurance_payer_enablement_request import ToggleNonInsurancePayerEnablementRequest

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self, *, request: CreateNonInsurancePayerRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[NonInsurancePayer]:
        """
        Parameters
        ----------
        request : CreateNonInsurancePayerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[NonInsurancePayer]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/non-insurance-payers/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayer,
                parse_obj_as(
                    type_=NonInsurancePayer,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def toggle_enablement(
        self,
        non_insurance_payer_id: NonInsurancePayerId,
        *,
        request: ToggleNonInsurancePayerEnablementRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[NonInsurancePayer]:
        """
        Parameters
        ----------
        non_insurance_payer_id : NonInsurancePayerId

        request : ToggleNonInsurancePayerEnablementRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[NonInsurancePayer]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/non-insurance-payers/v1/{jsonable_encoder(non_insurance_payer_id)}/toggle_enablement",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayer,
                parse_obj_as(
                    type_=NonInsurancePayer,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_multi(
        self,
        *,
        name: typing.Optional[str] = None,
        category: typing.Optional[str] = None,
        enabled: typing.Optional[bool] = None,
        sort: typing.Optional[NonInsurancePayerSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        limit: typing.Optional[int] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[NonInsurancePayerPage]:
        """
        Parameters
        ----------
        name : typing.Optional[str]

        category : typing.Optional[str]

        enabled : typing.Optional[bool]

        sort : typing.Optional[NonInsurancePayerSortField]

        sort_direction : typing.Optional[SortDirection]

        limit : typing.Optional[int]
            Defaults to 100

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[NonInsurancePayerPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/non-insurance-payers/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "name": name,
                "category": category,
                "enabled": enabled,
                "sort": sort,
                "sort_direction": sort_direction,
                "limit": limit,
                "page_token": page_token,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayerPage,
                parse_obj_as(
                    type_=NonInsurancePayerPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, non_insurance_payer_id: NonInsurancePayerId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[NonInsurancePayer]:
        """
        Parameters
        ----------
        non_insurance_payer_id : NonInsurancePayerId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[NonInsurancePayer]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/non-insurance-payers/v1/{jsonable_encoder(non_insurance_payer_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayer,
                parse_obj_as(
                    type_=NonInsurancePayer,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        non_insurance_payer_id: NonInsurancePayerId,
        *,
        request: NonInsurancePayerUpdateRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[NonInsurancePayer]:
        """
        Parameters
        ----------
        non_insurance_payer_id : NonInsurancePayerId

        request : NonInsurancePayerUpdateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[NonInsurancePayer]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/non-insurance-payers/v1/{jsonable_encoder(non_insurance_payer_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayer,
                parse_obj_as(
                    type_=NonInsurancePayer,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, non_insurance_payer_id: NonInsurancePayerId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        non_insurance_payer_id : NonInsurancePayerId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/non-insurance-payers/v1/{jsonable_encoder(non_insurance_payer_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return HttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self, *, request: CreateNonInsurancePayerRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[NonInsurancePayer]:
        """
        Parameters
        ----------
        request : CreateNonInsurancePayerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[NonInsurancePayer]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/non-insurance-payers/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayer,
                parse_obj_as(
                    type_=NonInsurancePayer,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def toggle_enablement(
        self,
        non_insurance_payer_id: NonInsurancePayerId,
        *,
        request: ToggleNonInsurancePayerEnablementRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[NonInsurancePayer]:
        """
        Parameters
        ----------
        non_insurance_payer_id : NonInsurancePayerId

        request : ToggleNonInsurancePayerEnablementRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[NonInsurancePayer]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/non-insurance-payers/v1/{jsonable_encoder(non_insurance_payer_id)}/toggle_enablement",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayer,
                parse_obj_as(
                    type_=NonInsurancePayer,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_multi(
        self,
        *,
        name: typing.Optional[str] = None,
        category: typing.Optional[str] = None,
        enabled: typing.Optional[bool] = None,
        sort: typing.Optional[NonInsurancePayerSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        limit: typing.Optional[int] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[NonInsurancePayerPage]:
        """
        Parameters
        ----------
        name : typing.Optional[str]

        category : typing.Optional[str]

        enabled : typing.Optional[bool]

        sort : typing.Optional[NonInsurancePayerSortField]

        sort_direction : typing.Optional[SortDirection]

        limit : typing.Optional[int]
            Defaults to 100

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[NonInsurancePayerPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/non-insurance-payers/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "name": name,
                "category": category,
                "enabled": enabled,
                "sort": sort,
                "sort_direction": sort_direction,
                "limit": limit,
                "page_token": page_token,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayerPage,
                parse_obj_as(
                    type_=NonInsurancePayerPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, non_insurance_payer_id: NonInsurancePayerId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[NonInsurancePayer]:
        """
        Parameters
        ----------
        non_insurance_payer_id : NonInsurancePayerId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[NonInsurancePayer]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/non-insurance-payers/v1/{jsonable_encoder(non_insurance_payer_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayer,
                parse_obj_as(
                    type_=NonInsurancePayer,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        non_insurance_payer_id: NonInsurancePayerId,
        *,
        request: NonInsurancePayerUpdateRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[NonInsurancePayer]:
        """
        Parameters
        ----------
        non_insurance_payer_id : NonInsurancePayerId

        request : NonInsurancePayerUpdateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[NonInsurancePayer]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/non-insurance-payers/v1/{jsonable_encoder(non_insurance_payer_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                NonInsurancePayer,
                parse_obj_as(
                    type_=NonInsurancePayer,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityConflictError":
                raise EntityConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityConflictErrorMessage,
                        parse_obj_as(
                            type_=EntityConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, non_insurance_payer_id: NonInsurancePayerId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        non_insurance_payer_id : NonInsurancePayerId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/non-insurance-payers/v1/{jsonable_encoder(non_insurance_payer_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="DELETE",
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return AsyncHttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
