# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....clinical_trials.resources.v_1.types.mutable_clinical_trial import MutableClinicalTrial
from .....commons.types.street_address_short_zip import StreetAddressShortZip


class CreateNonInsurancePayerRequest(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    Max 50 characters allowed
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Max 255 characters allowed
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    Max 255 characters allowed
    """

    address: typing.Optional[StreetAddressShortZip] = None
    clinical_trials: typing.Optional[typing.List[MutableClinicalTrial]] = pydantic.Field(default=None)
    """
    The same name cannot be used across several clinical trials
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
