# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
from .....commons.types.date import Date
from .employment_status import EmploymentStatus
from .organization_provider_base import OrganizationProviderBase
from .organization_provider_id import OrganizationProviderId


class OrganizationProvider(OrganizationProviderBase):
    organization_provider_id: OrganizationProviderId = pydantic.Field()
    """
    Auto-generated ID set on creation
    """

    employment_status: EmploymentStatus = pydantic.Field()
    """
    The employment status for the provider.
    """

    employment_start_date: typing.Optional[Date] = pydantic.Field(default=None)
    """
    The employment start date for the provider.
    """

    employment_termination_date: typing.Optional[Date] = pydantic.Field(default=None)
    """
    The employment termination date for the provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
