# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.page_token import PageToken
from ..v_2.types.organization_provider_id import OrganizationProviderId
from ..v_2.types.organization_provider_sort_options import OrganizationProviderSortOptions
from .raw_client import AsyncRawV3Client, RawV3Client
from .types.organization_provider_create_v_2 import OrganizationProviderCreateV2
from .types.organization_provider_page_v_2 import OrganizationProviderPageV2
from .types.organization_provider_update_v_2 import OrganizationProviderUpdateV2
from .types.organization_provider_v_2 import OrganizationProviderV2

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V3Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV3Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV3Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV3Client
        """
        return self._raw_client

    def get(
        self,
        organization_provider_id: OrganizationProviderId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationProviderV2:
        """
        Parameters
        ----------
        organization_provider_id : OrganizationProviderId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProviderV2

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.organization_providers.v_3.get(
            organization_provider_id=uuid.UUID(
                "965a563a-0285-4910-9569-e3739c0f6eab",
            ),
        )
        """
        _response = self._raw_client.get(organization_provider_id, request_options=request_options)
        return _response.data

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        search_term: typing.Optional[str] = None,
        npi: typing.Optional[str] = None,
        is_rendering: typing.Optional[bool] = None,
        is_billing: typing.Optional[bool] = None,
        page_token: typing.Optional[PageToken] = None,
        sort: typing.Optional[OrganizationProviderSortOptions] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationProviderPageV2:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Limit the number of results returned. Defaults to 100.

        search_term : typing.Optional[str]
            Filter to a name or a part of a name.

        npi : typing.Optional[str]
            Filter to a specific NPI.

        is_rendering : typing.Optional[bool]
            Filter to only rendering providers.

        is_billing : typing.Optional[bool]
            Filter to only billing providers.

        page_token : typing.Optional[PageToken]
            The page token to continue paging through a previous request.

        sort : typing.Optional[OrganizationProviderSortOptions]
            Defaults to PROVIDER_NAME_ASC.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProviderPageV2

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.organization_providers.resources.v_2 import (
            OrganizationProviderSortOptions,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.organization_providers.v_3.get_multi(
            limit=100,
            search_term="john",
            npi="1234567890",
            is_rendering=True,
            is_billing=True,
            page_token="eyJ0b2tlbiI6IjEiLCJwYWdlX3Rva2VuIjoiMiJ9",
            sort=OrganizationProviderSortOptions.PROVIDER_NAME_ASC,
        )
        """
        _response = self._raw_client.get_multi(
            limit=limit,
            search_term=search_term,
            npi=npi,
            is_rendering=is_rendering,
            is_billing=is_billing,
            page_token=page_token,
            sort=sort,
            request_options=request_options,
        )
        return _response.data

    def create(
        self, *, request: OrganizationProviderCreateV2, request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationProviderV2:
        """
        Parameters
        ----------
        request : OrganizationProviderCreateV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProviderV2

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.commons import State
        from candid.resources.identifiers import (
            IdentifierCode,
            IdentifierCreate,
            IdentifierValue_MedicareProviderIdentifier,
        )
        from candid.resources.organization_providers.resources.v_2 import (
            LicenseType,
            ProviderType,
        )
        from candid.resources.organization_providers.resources.v_3 import (
            OrganizationProviderCreateV2,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.organization_providers.v_3.create(
            request=OrganizationProviderCreateV2(
                npi="npi",
                is_rendering=True,
                is_billing=True,
                provider_type=ProviderType.INDIVIDUAL,
                license_type=LicenseType.MD,
                qualifications=[
                    IdentifierCreate(
                        identifier_code=IdentifierCode.MCR,
                        identifier_value=IdentifierValue_MedicareProviderIdentifier(
                            state=State.AA,
                            provider_number="provider_number",
                        ),
                    ),
                    IdentifierCreate(
                        identifier_code=IdentifierCode.MCR,
                        identifier_value=IdentifierValue_MedicareProviderIdentifier(
                            state=State.AA,
                            provider_number="provider_number",
                        ),
                    ),
                ],
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self,
        organization_provider_id: OrganizationProviderId,
        *,
        request: OrganizationProviderUpdateV2,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationProviderV2:
        """
        Parameters
        ----------
        organization_provider_id : OrganizationProviderId

        request : OrganizationProviderUpdateV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProviderV2

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.organization_providers.resources.v_3 import (
            OrganizationProviderUpdateV2,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.organization_providers.v_3.update(
            organization_provider_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=OrganizationProviderUpdateV2(),
        )
        """
        _response = self._raw_client.update(organization_provider_id, request=request, request_options=request_options)
        return _response.data


class AsyncV3Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV3Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV3Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV3Client
        """
        return self._raw_client

    async def get(
        self,
        organization_provider_id: OrganizationProviderId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationProviderV2:
        """
        Parameters
        ----------
        organization_provider_id : OrganizationProviderId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProviderV2

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.organization_providers.v_3.get(
                organization_provider_id=uuid.UUID(
                    "965a563a-0285-4910-9569-e3739c0f6eab",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(organization_provider_id, request_options=request_options)
        return _response.data

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        search_term: typing.Optional[str] = None,
        npi: typing.Optional[str] = None,
        is_rendering: typing.Optional[bool] = None,
        is_billing: typing.Optional[bool] = None,
        page_token: typing.Optional[PageToken] = None,
        sort: typing.Optional[OrganizationProviderSortOptions] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationProviderPageV2:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Limit the number of results returned. Defaults to 100.

        search_term : typing.Optional[str]
            Filter to a name or a part of a name.

        npi : typing.Optional[str]
            Filter to a specific NPI.

        is_rendering : typing.Optional[bool]
            Filter to only rendering providers.

        is_billing : typing.Optional[bool]
            Filter to only billing providers.

        page_token : typing.Optional[PageToken]
            The page token to continue paging through a previous request.

        sort : typing.Optional[OrganizationProviderSortOptions]
            Defaults to PROVIDER_NAME_ASC.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProviderPageV2

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.organization_providers.resources.v_2 import (
            OrganizationProviderSortOptions,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.organization_providers.v_3.get_multi(
                limit=100,
                search_term="john",
                npi="1234567890",
                is_rendering=True,
                is_billing=True,
                page_token="eyJ0b2tlbiI6IjEiLCJwYWdlX3Rva2VuIjoiMiJ9",
                sort=OrganizationProviderSortOptions.PROVIDER_NAME_ASC,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            limit=limit,
            search_term=search_term,
            npi=npi,
            is_rendering=is_rendering,
            is_billing=is_billing,
            page_token=page_token,
            sort=sort,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self, *, request: OrganizationProviderCreateV2, request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationProviderV2:
        """
        Parameters
        ----------
        request : OrganizationProviderCreateV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProviderV2

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.commons import State
        from candid.resources.identifiers import (
            IdentifierCode,
            IdentifierCreate,
            IdentifierValue_MedicareProviderIdentifier,
        )
        from candid.resources.organization_providers.resources.v_2 import (
            LicenseType,
            ProviderType,
        )
        from candid.resources.organization_providers.resources.v_3 import (
            OrganizationProviderCreateV2,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.organization_providers.v_3.create(
                request=OrganizationProviderCreateV2(
                    npi="npi",
                    is_rendering=True,
                    is_billing=True,
                    provider_type=ProviderType.INDIVIDUAL,
                    license_type=LicenseType.MD,
                    qualifications=[
                        IdentifierCreate(
                            identifier_code=IdentifierCode.MCR,
                            identifier_value=IdentifierValue_MedicareProviderIdentifier(
                                state=State.AA,
                                provider_number="provider_number",
                            ),
                        ),
                        IdentifierCreate(
                            identifier_code=IdentifierCode.MCR,
                            identifier_value=IdentifierValue_MedicareProviderIdentifier(
                                state=State.AA,
                                provider_number="provider_number",
                            ),
                        ),
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self,
        organization_provider_id: OrganizationProviderId,
        *,
        request: OrganizationProviderUpdateV2,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationProviderV2:
        """
        Parameters
        ----------
        organization_provider_id : OrganizationProviderId

        request : OrganizationProviderUpdateV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationProviderV2

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.organization_providers.resources.v_3 import (
            OrganizationProviderUpdateV2,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.organization_providers.v_3.update(
                organization_provider_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=OrganizationProviderUpdateV2(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            organization_provider_id, request=request, request_options=request_options
        )
        return _response.data
