# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.entity_not_found_error import EntityNotFoundError
from ....commons.errors.http_request_validation_error import HttpRequestValidationError
from ....commons.errors.updates_disabled_due_to_external_system_integration_error import (
    UpdatesDisabledDueToExternalSystemIntegrationError,
)
from ....commons.types.entity_not_found_error_message import EntityNotFoundErrorMessage
from ....commons.types.page_token import PageToken
from ....commons.types.request_validation_error import RequestValidationError
from ....commons.types.updates_disabled_due_to_external_system_integration_error_message import (
    UpdatesDisabledDueToExternalSystemIntegrationErrorMessage,
)
from ..v_2.types.organization_provider_id import OrganizationProviderId
from ..v_2.types.organization_provider_sort_options import OrganizationProviderSortOptions
from .types.organization_provider_create_v_2 import OrganizationProviderCreateV2
from .types.organization_provider_page_v_2 import OrganizationProviderPageV2
from .types.organization_provider_update_v_2 import OrganizationProviderUpdateV2
from .types.organization_provider_v_2 import OrganizationProviderV2

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV3Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        organization_provider_id: OrganizationProviderId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[OrganizationProviderV2]:
        """
        Parameters
        ----------
        organization_provider_id : OrganizationProviderId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[OrganizationProviderV2]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/organization-providers/v3/{jsonable_encoder(organization_provider_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                OrganizationProviderV2,
                parse_obj_as(
                    type_=OrganizationProviderV2,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        search_term: typing.Optional[str] = None,
        npi: typing.Optional[str] = None,
        is_rendering: typing.Optional[bool] = None,
        is_billing: typing.Optional[bool] = None,
        page_token: typing.Optional[PageToken] = None,
        sort: typing.Optional[OrganizationProviderSortOptions] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[OrganizationProviderPageV2]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Limit the number of results returned. Defaults to 100.

        search_term : typing.Optional[str]
            Filter to a name or a part of a name.

        npi : typing.Optional[str]
            Filter to a specific NPI.

        is_rendering : typing.Optional[bool]
            Filter to only rendering providers.

        is_billing : typing.Optional[bool]
            Filter to only billing providers.

        page_token : typing.Optional[PageToken]
            The page token to continue paging through a previous request.

        sort : typing.Optional[OrganizationProviderSortOptions]
            Defaults to PROVIDER_NAME_ASC.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[OrganizationProviderPageV2]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/organization-providers/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "search_term": search_term,
                "npi": npi,
                "is_rendering": is_rendering,
                "is_billing": is_billing,
                "page_token": page_token,
                "sort": sort,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                OrganizationProviderPageV2,
                parse_obj_as(
                    type_=OrganizationProviderPageV2,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self, *, request: OrganizationProviderCreateV2, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[OrganizationProviderV2]:
        """
        Parameters
        ----------
        request : OrganizationProviderCreateV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[OrganizationProviderV2]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/organization-providers/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                OrganizationProviderV2,
                parse_obj_as(
                    type_=OrganizationProviderV2,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationError":
                raise HttpRequestValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        RequestValidationError,
                        parse_obj_as(
                            type_=RequestValidationError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UpdatesDisabledDueToExternalSystemIntegrationError":
                raise UpdatesDisabledDueToExternalSystemIntegrationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UpdatesDisabledDueToExternalSystemIntegrationErrorMessage,
                        parse_obj_as(
                            type_=UpdatesDisabledDueToExternalSystemIntegrationErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        organization_provider_id: OrganizationProviderId,
        *,
        request: OrganizationProviderUpdateV2,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[OrganizationProviderV2]:
        """
        Parameters
        ----------
        organization_provider_id : OrganizationProviderId

        request : OrganizationProviderUpdateV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[OrganizationProviderV2]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/organization-providers/v3/{jsonable_encoder(organization_provider_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                OrganizationProviderV2,
                parse_obj_as(
                    type_=OrganizationProviderV2,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationError":
                raise HttpRequestValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        RequestValidationError,
                        parse_obj_as(
                            type_=RequestValidationError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UpdatesDisabledDueToExternalSystemIntegrationError":
                raise UpdatesDisabledDueToExternalSystemIntegrationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UpdatesDisabledDueToExternalSystemIntegrationErrorMessage,
                        parse_obj_as(
                            type_=UpdatesDisabledDueToExternalSystemIntegrationErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV3Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        organization_provider_id: OrganizationProviderId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[OrganizationProviderV2]:
        """
        Parameters
        ----------
        organization_provider_id : OrganizationProviderId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[OrganizationProviderV2]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/organization-providers/v3/{jsonable_encoder(organization_provider_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                OrganizationProviderV2,
                parse_obj_as(
                    type_=OrganizationProviderV2,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        search_term: typing.Optional[str] = None,
        npi: typing.Optional[str] = None,
        is_rendering: typing.Optional[bool] = None,
        is_billing: typing.Optional[bool] = None,
        page_token: typing.Optional[PageToken] = None,
        sort: typing.Optional[OrganizationProviderSortOptions] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[OrganizationProviderPageV2]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Limit the number of results returned. Defaults to 100.

        search_term : typing.Optional[str]
            Filter to a name or a part of a name.

        npi : typing.Optional[str]
            Filter to a specific NPI.

        is_rendering : typing.Optional[bool]
            Filter to only rendering providers.

        is_billing : typing.Optional[bool]
            Filter to only billing providers.

        page_token : typing.Optional[PageToken]
            The page token to continue paging through a previous request.

        sort : typing.Optional[OrganizationProviderSortOptions]
            Defaults to PROVIDER_NAME_ASC.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[OrganizationProviderPageV2]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/organization-providers/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "search_term": search_term,
                "npi": npi,
                "is_rendering": is_rendering,
                "is_billing": is_billing,
                "page_token": page_token,
                "sort": sort,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                OrganizationProviderPageV2,
                parse_obj_as(
                    type_=OrganizationProviderPageV2,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self, *, request: OrganizationProviderCreateV2, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[OrganizationProviderV2]:
        """
        Parameters
        ----------
        request : OrganizationProviderCreateV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[OrganizationProviderV2]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/organization-providers/v3",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                OrganizationProviderV2,
                parse_obj_as(
                    type_=OrganizationProviderV2,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationError":
                raise HttpRequestValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        RequestValidationError,
                        parse_obj_as(
                            type_=RequestValidationError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UpdatesDisabledDueToExternalSystemIntegrationError":
                raise UpdatesDisabledDueToExternalSystemIntegrationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UpdatesDisabledDueToExternalSystemIntegrationErrorMessage,
                        parse_obj_as(
                            type_=UpdatesDisabledDueToExternalSystemIntegrationErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        organization_provider_id: OrganizationProviderId,
        *,
        request: OrganizationProviderUpdateV2,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[OrganizationProviderV2]:
        """
        Parameters
        ----------
        organization_provider_id : OrganizationProviderId

        request : OrganizationProviderUpdateV2

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[OrganizationProviderV2]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/organization-providers/v3/{jsonable_encoder(organization_provider_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                OrganizationProviderV2,
                parse_obj_as(
                    type_=OrganizationProviderV2,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "HttpRequestValidationError":
                raise HttpRequestValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        RequestValidationError,
                        parse_obj_as(
                            type_=RequestValidationError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UpdatesDisabledDueToExternalSystemIntegrationError":
                raise UpdatesDisabledDueToExternalSystemIntegrationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UpdatesDisabledDueToExternalSystemIntegrationErrorMessage,
                        parse_obj_as(
                            type_=UpdatesDisabledDueToExternalSystemIntegrationErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
