# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....identifiers.types.identifier_create import IdentifierCreate
from ...v_2.types.license_type import LicenseType
from ...v_2.types.organization_provider_address import OrganizationProviderAddress
from ...v_2.types.provider_type import ProviderType


class OrganizationProviderCreateV2(UniversalBaseModel):
    npi: str = pydantic.Field()
    """
    The NPI of the provider. This must be all digits [0-9] and exactly 10 characters long.
    """

    is_rendering: bool = pydantic.Field()
    """
    Whether the provider can be used to render services.
    """

    is_billing: bool = pydantic.Field()
    """
    Whether the provider can be used to bill services.
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The first name of the provider, if the provider is an individual.
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The last name of the provider, if the provider is an individual.
    """

    organization_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the provider, if the provider is an organization.
    """

    provider_type: ProviderType = pydantic.Field()
    """
    Whether the provider is an individual (NPPES Type 1) or organization (NPPES Type 2) provider.
    """

    tax_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    If the provider has a contract with insurance, this must be the same tax ID given to the payer on an IRS W-9 form completed during contracting.
    """

    taxonomy_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    A code designating classification and specialization.
    """

    license_type: LicenseType = pydantic.Field()
    """
    The type of license that the provider holds.
    """

    addresses: typing.Optional[typing.List[OrganizationProviderAddress]] = pydantic.Field(default=None)
    """
    The addresses associated with this provider.
    """

    employment_start_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    The employment start date for the provider.
    """

    employment_termination_date: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    The employment termination date for the provider.
    """

    qualifications: typing.List[IdentifierCreate] = pydantic.Field()
    """
    A provider's qualifications such as PTAN, Medicaid Provider Id, etc.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
