# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.page_token import PageToken
from .raw_client import AsyncRawV2Client, RawV2Client
from .types.organization_service_facility import OrganizationServiceFacility
from .types.organization_service_facility_create import OrganizationServiceFacilityCreate
from .types.organization_service_facility_id import OrganizationServiceFacilityId
from .types.organization_service_facility_page import OrganizationServiceFacilityPage
from .types.organization_service_facility_update import OrganizationServiceFacilityUpdate

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V2Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV2Client
        """
        return self._raw_client

    def get(
        self,
        organization_service_facility_id: OrganizationServiceFacilityId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationServiceFacility:
        """
        Parameters
        ----------
        organization_service_facility_id : OrganizationServiceFacilityId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationServiceFacility

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.organization_service_facilities.v_2.get(
            organization_service_facility_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(organization_service_facility_id, request_options=request_options)
        return _response.data

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationServiceFacilityPage:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Limit the number of results returned. Defaults to 100.

        name : typing.Optional[str]
            Filter to a name or a part of a name.

        page_token : typing.Optional[PageToken]
            The page token to continue paging through a previous request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationServiceFacilityPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.organization_service_facilities.v_2.get_multi(
            limit=100,
            name="Test Service Facility",
            page_token="eyJ0b2tlbiI6IjEiLCJwYWdlX3Rva2VuIjoiMiJ9",
        )
        """
        _response = self._raw_client.get_multi(
            limit=limit, name=name, page_token=page_token, request_options=request_options
        )
        return _response.data

    def create(
        self, *, request: OrganizationServiceFacilityCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationServiceFacility:
        """
        Parameters
        ----------
        request : OrganizationServiceFacilityCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationServiceFacility

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.commons import State, StreetAddressLongZip
        from candid.resources.organization_service_facilities.resources.v_2 import (
            OrganizationServiceFacilityCreate,
            ServiceFacilityMode,
            ServiceFacilityOperationalStatus,
            ServiceFacilityPhysicalType,
            ServiceFacilityStatus,
            ServiceFacilityType,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.organization_service_facilities.v_2.create(
            request=OrganizationServiceFacilityCreate(
                name="Test Service Facility",
                aliases=["Test Service Facility Alias"],
                description="Test Service Facility Description",
                status=ServiceFacilityStatus.ACTIVE,
                operational_status=ServiceFacilityOperationalStatus.CLOSED,
                mode=ServiceFacilityMode.INSTANCE,
                type=ServiceFacilityType.DIAGNOSTICS_OR_THERAPEUTICS_UNIT,
                physical_type=ServiceFacilityPhysicalType.SITE,
                telecoms=["555-555-5555"],
                address=StreetAddressLongZip(
                    address_1="123 Main St",
                    address_2="Apt 1",
                    city="New York",
                    state=State.NY,
                    zip_code="10001",
                    zip_plus_four_code="1234",
                ),
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self,
        organization_service_facility_id: OrganizationServiceFacilityId,
        *,
        request: OrganizationServiceFacilityUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationServiceFacility:
        """
        Parameters
        ----------
        organization_service_facility_id : OrganizationServiceFacilityId

        request : OrganizationServiceFacilityUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationServiceFacility

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.commons import State, StreetAddressLongZip
        from candid.resources.organization_service_facilities.resources.v_2 import (
            OrganizationServiceFacilityUpdate,
            ServiceFacilityMode,
            ServiceFacilityOperationalStatus,
            ServiceFacilityPhysicalType,
            ServiceFacilityStatus,
            ServiceFacilityType,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.organization_service_facilities.v_2.update(
            organization_service_facility_id=uuid.UUID(
                "30f55ee6-8c0e-43fc-a7fc-dac00d5bf569",
            ),
            request=OrganizationServiceFacilityUpdate(
                name="Test Service Facility",
                aliases=["Test Service Facility Alias"],
                description="Test Service Facility Description",
                status=ServiceFacilityStatus.ACTIVE,
                operational_status=ServiceFacilityOperationalStatus.CLOSED,
                mode=ServiceFacilityMode.INSTANCE,
                type=ServiceFacilityType.DIAGNOSTICS_OR_THERAPEUTICS_UNIT,
                physical_type=ServiceFacilityPhysicalType.SITE,
                telecoms=["555-555-5555"],
                address=StreetAddressLongZip(
                    address_1="123 Main St",
                    address_2="Apt 1",
                    city="New York",
                    state=State.NY,
                    zip_code="10001",
                    zip_plus_four_code="1234",
                ),
            ),
        )
        """
        _response = self._raw_client.update(
            organization_service_facility_id, request=request, request_options=request_options
        )
        return _response.data

    def delete(
        self,
        organization_service_facility_id: OrganizationServiceFacilityId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        organization_service_facility_id : OrganizationServiceFacilityId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.organization_service_facilities.v_2.delete(
            organization_service_facility_id=uuid.UUID(
                "30f55ee6-8c0e-43fc-a7fc-dac00d5bf569",
            ),
        )
        """
        _response = self._raw_client.delete(organization_service_facility_id, request_options=request_options)
        return _response.data


class AsyncV2Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV2Client
        """
        return self._raw_client

    async def get(
        self,
        organization_service_facility_id: OrganizationServiceFacilityId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationServiceFacility:
        """
        Parameters
        ----------
        organization_service_facility_id : OrganizationServiceFacilityId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationServiceFacility

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.organization_service_facilities.v_2.get(
                organization_service_facility_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(organization_service_facility_id, request_options=request_options)
        return _response.data

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationServiceFacilityPage:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Limit the number of results returned. Defaults to 100.

        name : typing.Optional[str]
            Filter to a name or a part of a name.

        page_token : typing.Optional[PageToken]
            The page token to continue paging through a previous request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationServiceFacilityPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.organization_service_facilities.v_2.get_multi(
                limit=100,
                name="Test Service Facility",
                page_token="eyJ0b2tlbiI6IjEiLCJwYWdlX3Rva2VuIjoiMiJ9",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            limit=limit, name=name, page_token=page_token, request_options=request_options
        )
        return _response.data

    async def create(
        self, *, request: OrganizationServiceFacilityCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationServiceFacility:
        """
        Parameters
        ----------
        request : OrganizationServiceFacilityCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationServiceFacility

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.commons import State, StreetAddressLongZip
        from candid.resources.organization_service_facilities.resources.v_2 import (
            OrganizationServiceFacilityCreate,
            ServiceFacilityMode,
            ServiceFacilityOperationalStatus,
            ServiceFacilityPhysicalType,
            ServiceFacilityStatus,
            ServiceFacilityType,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.organization_service_facilities.v_2.create(
                request=OrganizationServiceFacilityCreate(
                    name="Test Service Facility",
                    aliases=["Test Service Facility Alias"],
                    description="Test Service Facility Description",
                    status=ServiceFacilityStatus.ACTIVE,
                    operational_status=ServiceFacilityOperationalStatus.CLOSED,
                    mode=ServiceFacilityMode.INSTANCE,
                    type=ServiceFacilityType.DIAGNOSTICS_OR_THERAPEUTICS_UNIT,
                    physical_type=ServiceFacilityPhysicalType.SITE,
                    telecoms=["555-555-5555"],
                    address=StreetAddressLongZip(
                        address_1="123 Main St",
                        address_2="Apt 1",
                        city="New York",
                        state=State.NY,
                        zip_code="10001",
                        zip_plus_four_code="1234",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self,
        organization_service_facility_id: OrganizationServiceFacilityId,
        *,
        request: OrganizationServiceFacilityUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OrganizationServiceFacility:
        """
        Parameters
        ----------
        organization_service_facility_id : OrganizationServiceFacilityId

        request : OrganizationServiceFacilityUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationServiceFacility

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.commons import State, StreetAddressLongZip
        from candid.resources.organization_service_facilities.resources.v_2 import (
            OrganizationServiceFacilityUpdate,
            ServiceFacilityMode,
            ServiceFacilityOperationalStatus,
            ServiceFacilityPhysicalType,
            ServiceFacilityStatus,
            ServiceFacilityType,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.organization_service_facilities.v_2.update(
                organization_service_facility_id=uuid.UUID(
                    "30f55ee6-8c0e-43fc-a7fc-dac00d5bf569",
                ),
                request=OrganizationServiceFacilityUpdate(
                    name="Test Service Facility",
                    aliases=["Test Service Facility Alias"],
                    description="Test Service Facility Description",
                    status=ServiceFacilityStatus.ACTIVE,
                    operational_status=ServiceFacilityOperationalStatus.CLOSED,
                    mode=ServiceFacilityMode.INSTANCE,
                    type=ServiceFacilityType.DIAGNOSTICS_OR_THERAPEUTICS_UNIT,
                    physical_type=ServiceFacilityPhysicalType.SITE,
                    telecoms=["555-555-5555"],
                    address=StreetAddressLongZip(
                        address_1="123 Main St",
                        address_2="Apt 1",
                        city="New York",
                        state=State.NY,
                        zip_code="10001",
                        zip_plus_four_code="1234",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            organization_service_facility_id, request=request, request_options=request_options
        )
        return _response.data

    async def delete(
        self,
        organization_service_facility_id: OrganizationServiceFacilityId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        organization_service_facility_id : OrganizationServiceFacilityId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.organization_service_facilities.v_2.delete(
                organization_service_facility_id=uuid.UUID(
                    "30f55ee6-8c0e-43fc-a7fc-dac00d5bf569",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(organization_service_facility_id, request_options=request_options)
        return _response.data
