# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ServiceFacilityOperationalStatus(str, enum.Enum):
    """
    Examples
    --------
    from candid.resources.organization_service_facilities.resources.v_2 import (
        ServiceFacilityOperationalStatus,
    )

    ServiceFacilityOperationalStatus.CLOSED
    """

    CLOSED = "C"
    """
    The location is not operational and is closed.
    """

    HOUSEKEEPING = "H"
    """
    The location is currently undergoing cleaning or maintenance.
    """

    ISOLATED = "I"
    """
    The location is quarantined or isolated for special cases.
    """

    CONTAMINATED = "K"
    """
    The location has been identified as contaminated and is not currently usable.
    """

    OCCUPIED = "O"
    """
    The location is currently in use or occupied.
    """

    UNOCCUPIED = "U"
    """
    The location is operational but currently empty or not in use.
    """

    _UNKNOWN = "__SERVICEFACILITYOPERATIONALSTATUS_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ServiceFacilityOperationalStatus":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        closed: typing.Callable[[], T_Result],
        housekeeping: typing.Callable[[], T_Result],
        isolated: typing.Callable[[], T_Result],
        contaminated: typing.Callable[[], T_Result],
        occupied: typing.Callable[[], T_Result],
        unoccupied: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ServiceFacilityOperationalStatus.CLOSED:
            return closed()
        if self is ServiceFacilityOperationalStatus.HOUSEKEEPING:
            return housekeeping()
        if self is ServiceFacilityOperationalStatus.ISOLATED:
            return isolated()
        if self is ServiceFacilityOperationalStatus.CONTAMINATED:
            return contaminated()
        if self is ServiceFacilityOperationalStatus.OCCUPIED:
            return occupied()
        if self is ServiceFacilityOperationalStatus.UNOCCUPIED:
            return unoccupied()
        return _unknown_member(self._value_)
