# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ServiceFacilityStatus(str, enum.Enum):
    """
    Examples
    --------
    from candid.resources.organization_service_facilities.resources.v_2 import (
        ServiceFacilityStatus,
    )

    ServiceFacilityStatus.ACTIVE
    """

    ACTIVE = "active"
    """
    The location is operational.
    """

    INACTIVE = "inactive"
    """
    The location is no longer used.
    """

    SUSPENDED = "suspended"
    """
    TThe location is temporarily closed.
    """

    _UNKNOWN = "__SERVICEFACILITYSTATUS_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ServiceFacilityStatus":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        active: typing.Callable[[], T_Result],
        inactive: typing.Callable[[], T_Result],
        suspended: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ServiceFacilityStatus.ACTIVE:
            return active()
        if self is ServiceFacilityStatus.INACTIVE:
            return inactive()
        if self is ServiceFacilityStatus.SUSPENDED:
            return suspended()
        return _unknown_member(self._value_)
