# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ServiceFacilityType(str, enum.Enum):
    """
    Examples
    --------
    from candid.resources.organization_service_facilities.resources.v_2 import (
        ServiceFacilityType,
    )

    ServiceFacilityType.DIAGNOSTICS_OR_THERAPEUTICS_UNIT
    """

    DIAGNOSTICS_OR_THERAPEUTICS_UNIT = "DX"
    """
    A practice setting where diagnostic procedures or therapeutic interventions are performed.
    """

    CARDIOVASCULAR_DIAGNOSTICS_OR_THERAPEUTICS_UNIT = "CVDX"
    """
    A practice setting where cardiovascular diagnostic procedures or therapeutic interventions are performed.
    """

    CARDIAC_CATHETERIZATION_LAB = "CATH"
    """
    Cardiac catheterization lab.
    """

    ECHOCARDIOGRAPHY_LAB = "ECHO"
    """
    Echocardiography lab.
    """

    GASTROENTEROLOGY_DIAGNOSTICS_OR_THERAPEUTICS_LAB = "GIDX"
    """
    A practice setting where GI procedures (such as endoscopies) are performed.
    """

    ENDOSCOPY_LAB = "ENDOS"
    """
    (X12N 261QD0000N)
    """

    RADIOLOGY_DIAGNOSTICS_OR_THERAPEUTICS_UNIT = "RADDX"
    """
    A practice setting where radiology services (diagnostic or therapeutic) are provided (X12N 261QR0200N).
    """

    RADIATION_ONCOLOGY_UNIT = "RADO"
    """
    (X12N 261QX0203N)
    """

    NEURORADIOLOGY_UNIT = "RNEU"
    """
    Neuroradiology unit.
    """

    HOSPITAL = "HOSP"
    """
    An acute care institution that provides medical, surgical, or psychiatric care and treatment for the sick or the injured.
    """

    CHRONIC_CARE_FACILITY = "CHR"
    """
    (1) A hospital including a physical plant and personnel that provides multidisciplinary diagnosis and treatment for diseases  that have one or more of the following characteristics: is permanent; leaves residual disability; is caused by nonreversible  pathological alteration; requires special training of the patient for rehabilitation; and/or may be expected to require a long  period of supervision or care. In addition, patients require the safety, security, and shelter of these specialized inpatient  or partial hospitalization settings. (2) A hospital that provides medical and skilled nursing services to patients with  long-term illnesses who are not in an acute phase but who require an intensity of services not available in nursing homes.
    """

    HOSPITALS_GENERAL_ACUTE_CARE_HOSPITAL = "GACH"
    """
    (X12N 282N00000N)
    """

    MILITARY_HOSPITAL = "MHSP"
    """
    A health care facility operated by the Department of Defense or other military operation.
    """

    PSYCHATRIC_CARE_FACILITY = "PSYCHF"
    """
    Healthcare facility that cares for patients with psychiatric illness(s).
    """

    REHABILITATION_HOSPITAL = "RH"
    """
    (X12N 283X00000N)
    """

    ADDICTION_TREATMENT_CENTER = "RHAT"
    """
    A location that plays the role of delivering services which may include life training and/or social support to people with addictions.
    """

    INTELLECTUAL_IMPAIRMENT_CENTER = "RHII"
    """
    A location that plays the role of delivering services which may include adaptation, rehabilitation and social integration services for people with intellectual and/or pervasive development disorders such as autism or severe behaviour disorder.
    """

    PARENTS_WITH_ADJUSTMENT_DIFFICULTIES_CENTER = "RHMAD"
    """
    A location that plays the role of delivering services which may social support services for adolescents who are pregnant or have child and are experiencing adaptation issues/difficulties in their current or eventual parenting role.
    """

    PHYSICAL_IMPAIRMENT_CENTER = "RHPI"
    """
    A location that plays the role of delivering services which may include adaptation, rehabilitation and social integration services for people with physical impairments.
    """

    PHYSICAL_IMPAIRMENT_HEARING_CENTER = "RHPIH"
    """
    A location that plays the role of delivering services for people with hearing impairments.
    """

    PHYSICAL_IMPAIRMENT_MOTOR_SKILLS_CENTER = "RHPIMS"
    """
    A location that plays the role of delivering services for people with motor skill impairments.
    """

    PHYSICAL_IMPAIRMENT_VISUAL_SKILLS_CENTER = "RHPIVS"
    """
    A location that plays the role of delivering services for people with visual skill impairments.
    """

    YOUTHS_WITH_ADJUSTMENT_DIFFICULTIES_CENTER = "RHYAD"
    """
    A location that plays the role of delivering services which may include life training and/or social support services for the adaptation, rehabilitation and social integration of youths with adjustment difficulties.
    """

    HOSPITAL_UNIT = "HU"
    """
    Hospital unit.
    """

    BONE_MARROW_TRANSPLANT_UNIT = "BMTU"
    """
    Bone marrow transplant unit.
    """

    CORONARY_CARE_UNIT = "CCU"
    """
    Coronary care unit.
    """

    CHEST_UNIT = "CHEST"
    """
    A specialty unit in hospital that focuses on chronic respirator patients. and pulmonary failure
    """

    EPILEPSY_UNIT = "EPIL"
    """
    Epilepsy unit.
    """

    EMERGENCY_ROOM = "ER"
    """
    The section of a health care facility for providing rapid treatment to victims of sudden illness or trauma.
    """

    EMERGENCY_TRAUMA_UNIT = "ETU"
    """
    Emergency trauma unit.
    """

    HEMODIALYSIS_UNIT = "HD"
    """
    Hemodialysis unit.
    """

    HOSPITAL_LABORATORY = "HLAB"
    """
    A location that plays the role of delivering services which may include tests done based on clinical specimens to get health information about a patient as pertaining to the diagnosis"
    """

    INPATIENT_LABORATORY = "INLAB"
    """
    A location that plays the role of delivering services which may include tests are done on clinical specimens to get health information about a patient pertaining to the diagnosis.
    """

    OUTPATIENT_LABORATORY = "OUTLAB"
    """
    A location that plays the role of delivering services which may include tests are done on clinical specimens to get health information about a patient pertaining to the diagnosis
    """

    RADIOLOGY_UNIT = "HRAD"
    """
    A location that plays the role of delivering services which may include the branch of medicine that uses ionizing and non-ionizing radiation to diagnose and treat diseases. The radiology unit may be further dividedinto subspecialties such as Imaging, Cardiovascular, Thoracic, and Ultrasound.
    """

    SPECIMEN_COLLECTION_SITE = "HUSCS"
    """
    A location that plays the role of delivering services which may include collecting specimens and/or samples from patients for laboratory testing purposes.
    """

    INTENSIVE_CARE_UNIT = "ICU"
    """
    Intensive care unit.
    """

    PEDIATRIC_INTENSIVE_CARE_UNIT = "PEDICU"
    """
    Pediatric intensive care unit
    """

    PEDIATRIC_NEONATAL_INTENSIVE_CARE_UNIT = "PEDNICU"
    """
    Pediatric neonatal intensive care unit.
    """

    INPATIENT_PHARMACY = "INPHARM"
    """
    A location that plays the role of delivering services which may include providing judicious, safe, efficacious, appropriate and cost effective use of medicines for treatment of patients for visits longer than one day. The distinction between inpatient pharmacies and retail (or outpatient) pharmacies is that they are part of a patient's continuity of care while staying in the hospital.
    """

    MEDICAL_LABORATORY = "MBL"
    """
    A location that plays the role of delivering services which include biochemistry, hematology, microbiology, immunochemistry, and toxicology.
    """

    NEUROLOGY_CRITICAL_CARE_AND_STROKE_UNIT = "NCCS"
    """
    Neurology critical care and stroke unit.
    """

    NEUROSURGERY_UNIT = "NS"
    """
    Neurosurgery unit.
    """

    OUTPATIENT_PHARMACY = "OUTPHARM"
    """
    A location that plays the role of delivering services which may include providing judicious, safe, efficacious, appropriate and cost effective use of medicines for treatment of patients for outpatient visits and may also be used for discharge prescriptions.
    """

    PEDIATRIC_UNIT = "PEDU"
    """
    Pediatric unit.
    """

    PSYCHIATRIC_HOSPITAL_UNIT = "PHU"
    """
    (X12N 273R00000N)
    """

    REHABILITATION_HOSPITAL_UNIT = "RHU"
    """
    Rehabilitation hospital unit.
    """

    SLEEP_DISORDERS_UNIT = "SLEEP"
    """
    (X12N 261QA1200N)
    """

    NURSING_OR_CUSTODIAL_CARE_FACILITY = "NCCF"
    """
    Nursing or custodial care facility.
    """

    SKILLED_NURSING_FACILITY = "SNF"
    """
    (X12N 314000000N)
    """

    OUTPATIENT_FACILITY = "OF"
    """
    Outpatient facility.
    """

    ALLERGY_CLINIC = "ALL"
    """
    Allergy clinic.
    """

    AMPUTEE_CLINIC = "AMPUT"
    """
    Amputee clinic.
    """

    BONE_MARROW_TRANSPLANT_CLINIC = "BMTC"
    """
    Bone marrow transplant clinic.
    """

    BREAST_CLINIC = "BREAST"
    """
    Breast clinic.
    """

    CHILD_AND_ADOLESCENT_NEUROLOGY_CLINIC = "CANC"
    """
    Child and adolescent neurology clinic.
    """

    CHILD_AND_ADOLESCENT_PSYCHIATRY_CLINIC = "CAPC"
    """
    Child and adolescent psychiatry clinic.
    """

    AMBULATORY_HEALTH_CARE_FACILITIES_CLINIC_CENTER_REHABILITATION_CARDIAC_FACILITIES = "CARD"
    """
    Ambulatory Health Care Facilities; Clinic/Center; Rehabilitation: Cardiac Facilities.
    """

    PEDIATRIC_CARDIOLOGY_CLINIC = "PEDCARD"
    """
    Pediatric cardiology clinic.
    """

    COAGULATION_CLINIC = "COAG"
    """
    Coagulation clinic.
    """

    COLON_AND_RECTAL_SURGERY_CLINIC = "CRS"
    """
    Colon and rectal surgery clinic.
    """

    DERMATOLOGY_CLINIC = "DERM"
    """
    Dermatology clinic.
    """

    ENDOCRINOLOGY_CLINIC = "ENDO"
    """
    Endocrinology clinic.
    """

    PEDIATRIC_ENDOCRINOLOGY_CLINIC = "PEDE"
    """
    Pediatric endocrinology clinic.
    """

    OTORHINOLARYNGOLOGY_CLINIC = "ENT"
    """
    Otorhinolaryngology clinic.
    """

    FAMILY_MEDICINE_CLINIC = "FMC"
    """
    Family medicine clinic.
    """

    GASTROENTEROLOGY_CLINIC = "GI"
    """
    Gastroenterology clinic.
    """

    PEDIATRIC_GASTROENTEROLOGY_CLINIC = "PEDGI"
    """
    Pediatric gastroenterology clinic.
    """

    GENERAL_INTERNAL_MEDICINE_CLINIC = "GIM"
    """
    General internal medicine clinic.
    """

    GYNECOLOGY_CLINIC = "GYN"
    """
    Gynecology clinic.
    """

    HEMATOLOGY_CLINIC = "HEM"
    """
    Hematology clinic.
    """

    PEDIATRIC_HEMATOLOGY_CLINIC = "PEDHEM"
    """
    Pediatric hematology clinic.
    """

    HYPERTENSION_CLINIC = "HTN"
    """
    Hypertension clinic.
    """

    IMPAIRMENT_EVALUATION_CENTER = "IEC"
    """
    Focuses on assessing disability.
    """

    INFECTIOUS_DISEASE_CLINIC = "INFD"
    """
    Infectious disease clinic.
    """

    PEDIATRIC_INFECTIOUS_DISEASE_CLINIC = "PEDID"
    """
    Pediatric infectious disease clinic.
    """

    INFERTILITY_CLINIC = "INV"
    """
    Infertility clinic.
    """

    LYMPEDEMA_CLINIC = "LYMPH"
    """
    Lympedema clinic.
    """

    MEDICAL_GENETICS_CLINIC = "MGEN"
    """
    Medical genetics clinic.
    """

    NEPHROLOGY_CLINIC = "NEPH"
    """
    Nephrology clinic.
    """

    PEDIATRIC_NEPHROLOGY_CLINIC = "PEDNEPH"
    """
    Pediatric nephrology clinic.
    """

    NEUROLOGY_CLINIC = "NEUR"
    """
    Neurology clinic.
    """

    OBSTETRICS_CLINIC = "OB"
    """
    Obstetrics clinic.
    """

    ORAL_AND_MAXILLOFACIAL_SURGERY_CLINIC = "OMS"
    """
    Oral and maxillofacial surgery clinic.
    """

    MEDICAL_ONCOLOGY_CLINIC = "ONCL"
    """
    Medical oncology clinic.
    """

    PEDIATRIC_ONCOLOGY_CLINIC = "PEDHO"
    """
    Pediatric oncology clinic.
    """

    OPTHALMOLOGY_CLINIC = "OPH"
    """
    Opthalmology clinic.
    """

    OPTOMETRY_CLINIC = "OPTC"
    """
    A location that plays the role of delivering services which may include examination, diagnosis, treatment, management, and prevention of diseases and disorders of the eye as well as prescribing and fitting appropriate corrective lenses (glasses or contact lenses) as needed. Optometry clinics may also provide tests for visual field screening, measuring intra-ocular pressure and ophthalmoscopy, as and when required.
    """

    ORTHOPEDICS_CLINIC = "ORTHO"
    """
    Orthopedics clinic.
    """

    HAND_CLINIC = "HAND"
    """
    Hand clinic.
    """

    PAIN_CLINIC = "PAINCL"
    """
    (X12N 261QP3300N)
    """

    PRIMARY_CARE_CLINIC = "PC"
    """
    (X12N 261QP2300N)
    """

    PEDIATRICS_CLINIC = "PEDC"
    """
    Pediatrics clinic.
    """

    PEDIATRIC_RHEUMATOLOGY_CLINIC = "PEDRHEUM"
    """
    Pediatric rheumatology clinic.
    """

    PODIATRY_CLINIC = "POD"
    """
    (X12N 261QP1100N)
    """

    PREVENTIVE_MEDICINE_CLINIC = "PREV"
    """
    Preventive medicine clinic.
    """

    PROCTOLOGY_CLINIC = "PROCTO"
    """
    Proctology clinic.
    """

    PROVIDERS_OFFICE = "PROFF"
    """
    Location where healthcare service was delivered.
    """

    PROSTHODONTICS_CLINIC = "PROS"
    """
    Prosthodontics clinic.
    """

    PSYCHOLOGY_CLINIC = "PSI"
    """
    Psychology clinic.
    """

    PSYCHIATRY_CLINIC = "PSY"
    """
    Psychiatry clinic.
    """

    RHEUMATOLOGY_CLINIC = "RHEUM"
    """
    Rheumatology clinic.
    """

    SPORTS_MEDICINE_CLINIC = "SPMED"
    """
    Sports medicine clinic.
    """

    SURGERY_CLINIC = "SU"
    """
    Surgery clinic.
    """

    PLASTIC_SURGERY_CLINIC = "PLS"
    """
    Plastic surgery clinic.
    """

    UROLOGY_CLINIC = "URO"
    """
    Urology clinic.
    """

    TRANSPLANT_CLINIC = "TR"
    """
    Transplant clinic.
    """

    TRAVEL_AND_GEOGRAPHIC_MEDICINE_CLINIC = "TRAVEL"
    """
    Travel and geographic medicine clinic.
    """

    WOUND_CLINIC = "WND"
    """
    Wound clinic.
    """

    RESIDENTIAL_TREATMENT_FACILITY = "RTF"
    """
    Residential treatment facility.
    """

    PAIN_REHABILITATION_CENTER = "PRC"
    """
    Pain rehabilitation center.
    """

    SUBSTANCE_USE_REHABILITATION_FACILITY = "SURF"
    """
    (X12N 324500000N)
    """

    DELIVERY_ADDRESS = "DADDR"
    """
    Location address where medical supplies were transported to for use.
    """

    MOBILE_UNIT = "MOBL"
    """
    Location (mobile) where healthcare service was delivered.
    """

    AMBULANCE = "AMB"
    """
    Location (mobile) where healthcare service was delivered, identified specifically as an ambulance.
    """

    PHARMACY = "PHARM"
    """
    Location where healthcare service was delivered.
    """

    ACCIDENT_SITE = "ACC"
    """
    Location of an accident where healthcare service was delivered.
    """

    COMMUNITY_LOCATION = "COMM"
    """
    Community location where healthcare is delivered.
    """

    COMMUNITY_SERVICE_CENTER = "CSC"
    """
    A location that plays the role of delivering services which may include providing front-line services to the population of a  defined geographic area such as: healthcare services and social services.
    """

    PATIENTS_RESIDENCE = "PTRES"
    """
    location where healthcare was delivered which is the residence of the Patient.
    """

    SCHOOL = "SCHOOL"
    """
    Location where healthcare service was delivered.
    """

    UNDERAGE_PROTECTION_CENTER = "UPC"
    """
    A location that plays the role of delivering services which may include:  social emergency services required for a young person as required under any jurisdictional youth laws.
    """

    WORK_SITE = "WORK"
    """
    Location where healthcare service was delivered.
    """

    _UNKNOWN = "__SERVICEFACILITYTYPE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ServiceFacilityType":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        diagnostics_or_therapeutics_unit: typing.Callable[[], T_Result],
        cardiovascular_diagnostics_or_therapeutics_unit: typing.Callable[[], T_Result],
        cardiac_catheterization_lab: typing.Callable[[], T_Result],
        echocardiography_lab: typing.Callable[[], T_Result],
        gastroenterology_diagnostics_or_therapeutics_lab: typing.Callable[[], T_Result],
        endoscopy_lab: typing.Callable[[], T_Result],
        radiology_diagnostics_or_therapeutics_unit: typing.Callable[[], T_Result],
        radiation_oncology_unit: typing.Callable[[], T_Result],
        neuroradiology_unit: typing.Callable[[], T_Result],
        hospital: typing.Callable[[], T_Result],
        chronic_care_facility: typing.Callable[[], T_Result],
        hospitals_general_acute_care_hospital: typing.Callable[[], T_Result],
        military_hospital: typing.Callable[[], T_Result],
        psychatric_care_facility: typing.Callable[[], T_Result],
        rehabilitation_hospital: typing.Callable[[], T_Result],
        addiction_treatment_center: typing.Callable[[], T_Result],
        intellectual_impairment_center: typing.Callable[[], T_Result],
        parents_with_adjustment_difficulties_center: typing.Callable[[], T_Result],
        physical_impairment_center: typing.Callable[[], T_Result],
        physical_impairment_hearing_center: typing.Callable[[], T_Result],
        physical_impairment_motor_skills_center: typing.Callable[[], T_Result],
        physical_impairment_visual_skills_center: typing.Callable[[], T_Result],
        youths_with_adjustment_difficulties_center: typing.Callable[[], T_Result],
        hospital_unit: typing.Callable[[], T_Result],
        bone_marrow_transplant_unit: typing.Callable[[], T_Result],
        coronary_care_unit: typing.Callable[[], T_Result],
        chest_unit: typing.Callable[[], T_Result],
        epilepsy_unit: typing.Callable[[], T_Result],
        emergency_room: typing.Callable[[], T_Result],
        emergency_trauma_unit: typing.Callable[[], T_Result],
        hemodialysis_unit: typing.Callable[[], T_Result],
        hospital_laboratory: typing.Callable[[], T_Result],
        inpatient_laboratory: typing.Callable[[], T_Result],
        outpatient_laboratory: typing.Callable[[], T_Result],
        radiology_unit: typing.Callable[[], T_Result],
        specimen_collection_site: typing.Callable[[], T_Result],
        intensive_care_unit: typing.Callable[[], T_Result],
        pediatric_intensive_care_unit: typing.Callable[[], T_Result],
        pediatric_neonatal_intensive_care_unit: typing.Callable[[], T_Result],
        inpatient_pharmacy: typing.Callable[[], T_Result],
        medical_laboratory: typing.Callable[[], T_Result],
        neurology_critical_care_and_stroke_unit: typing.Callable[[], T_Result],
        neurosurgery_unit: typing.Callable[[], T_Result],
        outpatient_pharmacy: typing.Callable[[], T_Result],
        pediatric_unit: typing.Callable[[], T_Result],
        psychiatric_hospital_unit: typing.Callable[[], T_Result],
        rehabilitation_hospital_unit: typing.Callable[[], T_Result],
        sleep_disorders_unit: typing.Callable[[], T_Result],
        nursing_or_custodial_care_facility: typing.Callable[[], T_Result],
        skilled_nursing_facility: typing.Callable[[], T_Result],
        outpatient_facility: typing.Callable[[], T_Result],
        allergy_clinic: typing.Callable[[], T_Result],
        amputee_clinic: typing.Callable[[], T_Result],
        bone_marrow_transplant_clinic: typing.Callable[[], T_Result],
        breast_clinic: typing.Callable[[], T_Result],
        child_and_adolescent_neurology_clinic: typing.Callable[[], T_Result],
        child_and_adolescent_psychiatry_clinic: typing.Callable[[], T_Result],
        ambulatory_health_care_facilities_clinic_center_rehabilitation_cardiac_facilities: typing.Callable[
            [], T_Result
        ],
        pediatric_cardiology_clinic: typing.Callable[[], T_Result],
        coagulation_clinic: typing.Callable[[], T_Result],
        colon_and_rectal_surgery_clinic: typing.Callable[[], T_Result],
        dermatology_clinic: typing.Callable[[], T_Result],
        endocrinology_clinic: typing.Callable[[], T_Result],
        pediatric_endocrinology_clinic: typing.Callable[[], T_Result],
        otorhinolaryngology_clinic: typing.Callable[[], T_Result],
        family_medicine_clinic: typing.Callable[[], T_Result],
        gastroenterology_clinic: typing.Callable[[], T_Result],
        pediatric_gastroenterology_clinic: typing.Callable[[], T_Result],
        general_internal_medicine_clinic: typing.Callable[[], T_Result],
        gynecology_clinic: typing.Callable[[], T_Result],
        hematology_clinic: typing.Callable[[], T_Result],
        pediatric_hematology_clinic: typing.Callable[[], T_Result],
        hypertension_clinic: typing.Callable[[], T_Result],
        impairment_evaluation_center: typing.Callable[[], T_Result],
        infectious_disease_clinic: typing.Callable[[], T_Result],
        pediatric_infectious_disease_clinic: typing.Callable[[], T_Result],
        infertility_clinic: typing.Callable[[], T_Result],
        lympedema_clinic: typing.Callable[[], T_Result],
        medical_genetics_clinic: typing.Callable[[], T_Result],
        nephrology_clinic: typing.Callable[[], T_Result],
        pediatric_nephrology_clinic: typing.Callable[[], T_Result],
        neurology_clinic: typing.Callable[[], T_Result],
        obstetrics_clinic: typing.Callable[[], T_Result],
        oral_and_maxillofacial_surgery_clinic: typing.Callable[[], T_Result],
        medical_oncology_clinic: typing.Callable[[], T_Result],
        pediatric_oncology_clinic: typing.Callable[[], T_Result],
        opthalmology_clinic: typing.Callable[[], T_Result],
        optometry_clinic: typing.Callable[[], T_Result],
        orthopedics_clinic: typing.Callable[[], T_Result],
        hand_clinic: typing.Callable[[], T_Result],
        pain_clinic: typing.Callable[[], T_Result],
        primary_care_clinic: typing.Callable[[], T_Result],
        pediatrics_clinic: typing.Callable[[], T_Result],
        pediatric_rheumatology_clinic: typing.Callable[[], T_Result],
        podiatry_clinic: typing.Callable[[], T_Result],
        preventive_medicine_clinic: typing.Callable[[], T_Result],
        proctology_clinic: typing.Callable[[], T_Result],
        providers_office: typing.Callable[[], T_Result],
        prosthodontics_clinic: typing.Callable[[], T_Result],
        psychology_clinic: typing.Callable[[], T_Result],
        psychiatry_clinic: typing.Callable[[], T_Result],
        rheumatology_clinic: typing.Callable[[], T_Result],
        sports_medicine_clinic: typing.Callable[[], T_Result],
        surgery_clinic: typing.Callable[[], T_Result],
        plastic_surgery_clinic: typing.Callable[[], T_Result],
        urology_clinic: typing.Callable[[], T_Result],
        transplant_clinic: typing.Callable[[], T_Result],
        travel_and_geographic_medicine_clinic: typing.Callable[[], T_Result],
        wound_clinic: typing.Callable[[], T_Result],
        residential_treatment_facility: typing.Callable[[], T_Result],
        pain_rehabilitation_center: typing.Callable[[], T_Result],
        substance_use_rehabilitation_facility: typing.Callable[[], T_Result],
        delivery_address: typing.Callable[[], T_Result],
        mobile_unit: typing.Callable[[], T_Result],
        ambulance: typing.Callable[[], T_Result],
        pharmacy: typing.Callable[[], T_Result],
        accident_site: typing.Callable[[], T_Result],
        community_location: typing.Callable[[], T_Result],
        community_service_center: typing.Callable[[], T_Result],
        patients_residence: typing.Callable[[], T_Result],
        school: typing.Callable[[], T_Result],
        underage_protection_center: typing.Callable[[], T_Result],
        work_site: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ServiceFacilityType.DIAGNOSTICS_OR_THERAPEUTICS_UNIT:
            return diagnostics_or_therapeutics_unit()
        if self is ServiceFacilityType.CARDIOVASCULAR_DIAGNOSTICS_OR_THERAPEUTICS_UNIT:
            return cardiovascular_diagnostics_or_therapeutics_unit()
        if self is ServiceFacilityType.CARDIAC_CATHETERIZATION_LAB:
            return cardiac_catheterization_lab()
        if self is ServiceFacilityType.ECHOCARDIOGRAPHY_LAB:
            return echocardiography_lab()
        if self is ServiceFacilityType.GASTROENTEROLOGY_DIAGNOSTICS_OR_THERAPEUTICS_LAB:
            return gastroenterology_diagnostics_or_therapeutics_lab()
        if self is ServiceFacilityType.ENDOSCOPY_LAB:
            return endoscopy_lab()
        if self is ServiceFacilityType.RADIOLOGY_DIAGNOSTICS_OR_THERAPEUTICS_UNIT:
            return radiology_diagnostics_or_therapeutics_unit()
        if self is ServiceFacilityType.RADIATION_ONCOLOGY_UNIT:
            return radiation_oncology_unit()
        if self is ServiceFacilityType.NEURORADIOLOGY_UNIT:
            return neuroradiology_unit()
        if self is ServiceFacilityType.HOSPITAL:
            return hospital()
        if self is ServiceFacilityType.CHRONIC_CARE_FACILITY:
            return chronic_care_facility()
        if self is ServiceFacilityType.HOSPITALS_GENERAL_ACUTE_CARE_HOSPITAL:
            return hospitals_general_acute_care_hospital()
        if self is ServiceFacilityType.MILITARY_HOSPITAL:
            return military_hospital()
        if self is ServiceFacilityType.PSYCHATRIC_CARE_FACILITY:
            return psychatric_care_facility()
        if self is ServiceFacilityType.REHABILITATION_HOSPITAL:
            return rehabilitation_hospital()
        if self is ServiceFacilityType.ADDICTION_TREATMENT_CENTER:
            return addiction_treatment_center()
        if self is ServiceFacilityType.INTELLECTUAL_IMPAIRMENT_CENTER:
            return intellectual_impairment_center()
        if self is ServiceFacilityType.PARENTS_WITH_ADJUSTMENT_DIFFICULTIES_CENTER:
            return parents_with_adjustment_difficulties_center()
        if self is ServiceFacilityType.PHYSICAL_IMPAIRMENT_CENTER:
            return physical_impairment_center()
        if self is ServiceFacilityType.PHYSICAL_IMPAIRMENT_HEARING_CENTER:
            return physical_impairment_hearing_center()
        if self is ServiceFacilityType.PHYSICAL_IMPAIRMENT_MOTOR_SKILLS_CENTER:
            return physical_impairment_motor_skills_center()
        if self is ServiceFacilityType.PHYSICAL_IMPAIRMENT_VISUAL_SKILLS_CENTER:
            return physical_impairment_visual_skills_center()
        if self is ServiceFacilityType.YOUTHS_WITH_ADJUSTMENT_DIFFICULTIES_CENTER:
            return youths_with_adjustment_difficulties_center()
        if self is ServiceFacilityType.HOSPITAL_UNIT:
            return hospital_unit()
        if self is ServiceFacilityType.BONE_MARROW_TRANSPLANT_UNIT:
            return bone_marrow_transplant_unit()
        if self is ServiceFacilityType.CORONARY_CARE_UNIT:
            return coronary_care_unit()
        if self is ServiceFacilityType.CHEST_UNIT:
            return chest_unit()
        if self is ServiceFacilityType.EPILEPSY_UNIT:
            return epilepsy_unit()
        if self is ServiceFacilityType.EMERGENCY_ROOM:
            return emergency_room()
        if self is ServiceFacilityType.EMERGENCY_TRAUMA_UNIT:
            return emergency_trauma_unit()
        if self is ServiceFacilityType.HEMODIALYSIS_UNIT:
            return hemodialysis_unit()
        if self is ServiceFacilityType.HOSPITAL_LABORATORY:
            return hospital_laboratory()
        if self is ServiceFacilityType.INPATIENT_LABORATORY:
            return inpatient_laboratory()
        if self is ServiceFacilityType.OUTPATIENT_LABORATORY:
            return outpatient_laboratory()
        if self is ServiceFacilityType.RADIOLOGY_UNIT:
            return radiology_unit()
        if self is ServiceFacilityType.SPECIMEN_COLLECTION_SITE:
            return specimen_collection_site()
        if self is ServiceFacilityType.INTENSIVE_CARE_UNIT:
            return intensive_care_unit()
        if self is ServiceFacilityType.PEDIATRIC_INTENSIVE_CARE_UNIT:
            return pediatric_intensive_care_unit()
        if self is ServiceFacilityType.PEDIATRIC_NEONATAL_INTENSIVE_CARE_UNIT:
            return pediatric_neonatal_intensive_care_unit()
        if self is ServiceFacilityType.INPATIENT_PHARMACY:
            return inpatient_pharmacy()
        if self is ServiceFacilityType.MEDICAL_LABORATORY:
            return medical_laboratory()
        if self is ServiceFacilityType.NEUROLOGY_CRITICAL_CARE_AND_STROKE_UNIT:
            return neurology_critical_care_and_stroke_unit()
        if self is ServiceFacilityType.NEUROSURGERY_UNIT:
            return neurosurgery_unit()
        if self is ServiceFacilityType.OUTPATIENT_PHARMACY:
            return outpatient_pharmacy()
        if self is ServiceFacilityType.PEDIATRIC_UNIT:
            return pediatric_unit()
        if self is ServiceFacilityType.PSYCHIATRIC_HOSPITAL_UNIT:
            return psychiatric_hospital_unit()
        if self is ServiceFacilityType.REHABILITATION_HOSPITAL_UNIT:
            return rehabilitation_hospital_unit()
        if self is ServiceFacilityType.SLEEP_DISORDERS_UNIT:
            return sleep_disorders_unit()
        if self is ServiceFacilityType.NURSING_OR_CUSTODIAL_CARE_FACILITY:
            return nursing_or_custodial_care_facility()
        if self is ServiceFacilityType.SKILLED_NURSING_FACILITY:
            return skilled_nursing_facility()
        if self is ServiceFacilityType.OUTPATIENT_FACILITY:
            return outpatient_facility()
        if self is ServiceFacilityType.ALLERGY_CLINIC:
            return allergy_clinic()
        if self is ServiceFacilityType.AMPUTEE_CLINIC:
            return amputee_clinic()
        if self is ServiceFacilityType.BONE_MARROW_TRANSPLANT_CLINIC:
            return bone_marrow_transplant_clinic()
        if self is ServiceFacilityType.BREAST_CLINIC:
            return breast_clinic()
        if self is ServiceFacilityType.CHILD_AND_ADOLESCENT_NEUROLOGY_CLINIC:
            return child_and_adolescent_neurology_clinic()
        if self is ServiceFacilityType.CHILD_AND_ADOLESCENT_PSYCHIATRY_CLINIC:
            return child_and_adolescent_psychiatry_clinic()
        if (
            self
            is ServiceFacilityType.AMBULATORY_HEALTH_CARE_FACILITIES_CLINIC_CENTER_REHABILITATION_CARDIAC_FACILITIES
        ):
            return ambulatory_health_care_facilities_clinic_center_rehabilitation_cardiac_facilities()
        if self is ServiceFacilityType.PEDIATRIC_CARDIOLOGY_CLINIC:
            return pediatric_cardiology_clinic()
        if self is ServiceFacilityType.COAGULATION_CLINIC:
            return coagulation_clinic()
        if self is ServiceFacilityType.COLON_AND_RECTAL_SURGERY_CLINIC:
            return colon_and_rectal_surgery_clinic()
        if self is ServiceFacilityType.DERMATOLOGY_CLINIC:
            return dermatology_clinic()
        if self is ServiceFacilityType.ENDOCRINOLOGY_CLINIC:
            return endocrinology_clinic()
        if self is ServiceFacilityType.PEDIATRIC_ENDOCRINOLOGY_CLINIC:
            return pediatric_endocrinology_clinic()
        if self is ServiceFacilityType.OTORHINOLARYNGOLOGY_CLINIC:
            return otorhinolaryngology_clinic()
        if self is ServiceFacilityType.FAMILY_MEDICINE_CLINIC:
            return family_medicine_clinic()
        if self is ServiceFacilityType.GASTROENTEROLOGY_CLINIC:
            return gastroenterology_clinic()
        if self is ServiceFacilityType.PEDIATRIC_GASTROENTEROLOGY_CLINIC:
            return pediatric_gastroenterology_clinic()
        if self is ServiceFacilityType.GENERAL_INTERNAL_MEDICINE_CLINIC:
            return general_internal_medicine_clinic()
        if self is ServiceFacilityType.GYNECOLOGY_CLINIC:
            return gynecology_clinic()
        if self is ServiceFacilityType.HEMATOLOGY_CLINIC:
            return hematology_clinic()
        if self is ServiceFacilityType.PEDIATRIC_HEMATOLOGY_CLINIC:
            return pediatric_hematology_clinic()
        if self is ServiceFacilityType.HYPERTENSION_CLINIC:
            return hypertension_clinic()
        if self is ServiceFacilityType.IMPAIRMENT_EVALUATION_CENTER:
            return impairment_evaluation_center()
        if self is ServiceFacilityType.INFECTIOUS_DISEASE_CLINIC:
            return infectious_disease_clinic()
        if self is ServiceFacilityType.PEDIATRIC_INFECTIOUS_DISEASE_CLINIC:
            return pediatric_infectious_disease_clinic()
        if self is ServiceFacilityType.INFERTILITY_CLINIC:
            return infertility_clinic()
        if self is ServiceFacilityType.LYMPEDEMA_CLINIC:
            return lympedema_clinic()
        if self is ServiceFacilityType.MEDICAL_GENETICS_CLINIC:
            return medical_genetics_clinic()
        if self is ServiceFacilityType.NEPHROLOGY_CLINIC:
            return nephrology_clinic()
        if self is ServiceFacilityType.PEDIATRIC_NEPHROLOGY_CLINIC:
            return pediatric_nephrology_clinic()
        if self is ServiceFacilityType.NEUROLOGY_CLINIC:
            return neurology_clinic()
        if self is ServiceFacilityType.OBSTETRICS_CLINIC:
            return obstetrics_clinic()
        if self is ServiceFacilityType.ORAL_AND_MAXILLOFACIAL_SURGERY_CLINIC:
            return oral_and_maxillofacial_surgery_clinic()
        if self is ServiceFacilityType.MEDICAL_ONCOLOGY_CLINIC:
            return medical_oncology_clinic()
        if self is ServiceFacilityType.PEDIATRIC_ONCOLOGY_CLINIC:
            return pediatric_oncology_clinic()
        if self is ServiceFacilityType.OPTHALMOLOGY_CLINIC:
            return opthalmology_clinic()
        if self is ServiceFacilityType.OPTOMETRY_CLINIC:
            return optometry_clinic()
        if self is ServiceFacilityType.ORTHOPEDICS_CLINIC:
            return orthopedics_clinic()
        if self is ServiceFacilityType.HAND_CLINIC:
            return hand_clinic()
        if self is ServiceFacilityType.PAIN_CLINIC:
            return pain_clinic()
        if self is ServiceFacilityType.PRIMARY_CARE_CLINIC:
            return primary_care_clinic()
        if self is ServiceFacilityType.PEDIATRICS_CLINIC:
            return pediatrics_clinic()
        if self is ServiceFacilityType.PEDIATRIC_RHEUMATOLOGY_CLINIC:
            return pediatric_rheumatology_clinic()
        if self is ServiceFacilityType.PODIATRY_CLINIC:
            return podiatry_clinic()
        if self is ServiceFacilityType.PREVENTIVE_MEDICINE_CLINIC:
            return preventive_medicine_clinic()
        if self is ServiceFacilityType.PROCTOLOGY_CLINIC:
            return proctology_clinic()
        if self is ServiceFacilityType.PROVIDERS_OFFICE:
            return providers_office()
        if self is ServiceFacilityType.PROSTHODONTICS_CLINIC:
            return prosthodontics_clinic()
        if self is ServiceFacilityType.PSYCHOLOGY_CLINIC:
            return psychology_clinic()
        if self is ServiceFacilityType.PSYCHIATRY_CLINIC:
            return psychiatry_clinic()
        if self is ServiceFacilityType.RHEUMATOLOGY_CLINIC:
            return rheumatology_clinic()
        if self is ServiceFacilityType.SPORTS_MEDICINE_CLINIC:
            return sports_medicine_clinic()
        if self is ServiceFacilityType.SURGERY_CLINIC:
            return surgery_clinic()
        if self is ServiceFacilityType.PLASTIC_SURGERY_CLINIC:
            return plastic_surgery_clinic()
        if self is ServiceFacilityType.UROLOGY_CLINIC:
            return urology_clinic()
        if self is ServiceFacilityType.TRANSPLANT_CLINIC:
            return transplant_clinic()
        if self is ServiceFacilityType.TRAVEL_AND_GEOGRAPHIC_MEDICINE_CLINIC:
            return travel_and_geographic_medicine_clinic()
        if self is ServiceFacilityType.WOUND_CLINIC:
            return wound_clinic()
        if self is ServiceFacilityType.RESIDENTIAL_TREATMENT_FACILITY:
            return residential_treatment_facility()
        if self is ServiceFacilityType.PAIN_REHABILITATION_CENTER:
            return pain_rehabilitation_center()
        if self is ServiceFacilityType.SUBSTANCE_USE_REHABILITATION_FACILITY:
            return substance_use_rehabilitation_facility()
        if self is ServiceFacilityType.DELIVERY_ADDRESS:
            return delivery_address()
        if self is ServiceFacilityType.MOBILE_UNIT:
            return mobile_unit()
        if self is ServiceFacilityType.AMBULANCE:
            return ambulance()
        if self is ServiceFacilityType.PHARMACY:
            return pharmacy()
        if self is ServiceFacilityType.ACCIDENT_SITE:
            return accident_site()
        if self is ServiceFacilityType.COMMUNITY_LOCATION:
            return community_location()
        if self is ServiceFacilityType.COMMUNITY_SERVICE_CENTER:
            return community_service_center()
        if self is ServiceFacilityType.PATIENTS_RESIDENCE:
            return patients_residence()
        if self is ServiceFacilityType.SCHOOL:
            return school()
        if self is ServiceFacilityType.UNDERAGE_PROTECTION_CENTER:
            return underage_protection_center()
        if self is ServiceFacilityType.WORK_SITE:
            return work_site()
        return _unknown_member(self._value_)
