# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.claim_id import ClaimId
from ....commons.types.invoice_id import InvoiceId
from ....commons.types.page_token import PageToken
from ....commons.types.patient_external_id import PatientExternalId
from ....commons.types.provider_id import ProviderId
from ....commons.types.service_line_id import ServiceLineId
from ....commons.types.sort_direction import SortDirection
from ....financials.types.allocation_create import AllocationCreate
from ....financials.types.invoice_update import InvoiceUpdate
from ....financials.types.note_update import NoteUpdate
from ....financials.types.patient_transaction_source import PatientTransactionSource
from .raw_client import AsyncRawV4Client, RawV4Client
from .types.patient_payment import PatientPayment
from .types.patient_payment_id import PatientPaymentId
from .types.patient_payment_sort_field import PatientPaymentSortField
from .types.patient_payments_page import PatientPaymentsPage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V4Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV4Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV4Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV4Client
        """
        return self._raw_client

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        patient_external_id: typing.Optional[PatientExternalId] = None,
        claim_id: typing.Optional[ClaimId] = None,
        service_line_id: typing.Optional[ServiceLineId] = None,
        billing_provider_id: typing.Optional[ProviderId] = None,
        unattributed: typing.Optional[bool] = None,
        invoice_id: typing.Optional[InvoiceId] = None,
        sources: typing.Optional[
            typing.Union[PatientTransactionSource, typing.Sequence[PatientTransactionSource]]
        ] = None,
        sort: typing.Optional[PatientPaymentSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientPaymentsPage:
        """
        Returns all patient payments satisfying the search criteria AND whose organization_id matches
        the current organization_id of the authenticated user.

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        patient_external_id : typing.Optional[PatientExternalId]

        claim_id : typing.Optional[ClaimId]

        service_line_id : typing.Optional[ServiceLineId]

        billing_provider_id : typing.Optional[ProviderId]

        unattributed : typing.Optional[bool]
            returns payments with unattributed allocations if set to true

        invoice_id : typing.Optional[InvoiceId]

        sources : typing.Optional[typing.Union[PatientTransactionSource, typing.Sequence[PatientTransactionSource]]]

        sort : typing.Optional[PatientPaymentSortField]
            Defaults to payment_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPaymentsPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.patient_payments.v_4.get_multi()
        """
        _response = self._raw_client.get_multi(
            limit=limit,
            patient_external_id=patient_external_id,
            claim_id=claim_id,
            service_line_id=service_line_id,
            billing_provider_id=billing_provider_id,
            unattributed=unattributed,
            invoice_id=invoice_id,
            sources=sources,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, patient_payment_id: PatientPaymentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PatientPayment:
        """
        Retrieves a previously created patient payment by its `patient_payment_id`.

        Parameters
        ----------
        patient_payment_id : PatientPaymentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPayment

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.patient_payments.v_4.get(
            patient_payment_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(patient_payment_id, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        amount_cents: int,
        patient_external_id: PatientExternalId,
        allocations: typing.Sequence[AllocationCreate],
        payment_timestamp: typing.Optional[dt.datetime] = OMIT,
        payment_note: typing.Optional[str] = OMIT,
        invoice: typing.Optional[InvoiceId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientPayment:
        """
        Creates a new patient payment record and returns the newly created PatientPayment object.
        The allocations can describe whether the payment is being applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        amount_cents : int

        patient_external_id : PatientExternalId

        allocations : typing.Sequence[AllocationCreate]

        payment_timestamp : typing.Optional[dt.datetime]

        payment_note : typing.Optional[str]

        invoice : typing.Optional[InvoiceId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPayment

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.financials import (
            AllocationCreate,
            AllocationTargetCreate_ServiceLineById,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.patient_payments.v_4.create(
            amount_cents=1,
            patient_external_id="patient_external_id",
            allocations=[
                AllocationCreate(
                    amount_cents=1,
                    target=AllocationTargetCreate_ServiceLineById(
                        value=uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        )
                    ),
                ),
                AllocationCreate(
                    amount_cents=1,
                    target=AllocationTargetCreate_ServiceLineById(
                        value=uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        )
                    ),
                ),
            ],
        )
        """
        _response = self._raw_client.create(
            amount_cents=amount_cents,
            patient_external_id=patient_external_id,
            allocations=allocations,
            payment_timestamp=payment_timestamp,
            payment_note=payment_note,
            invoice=invoice,
            request_options=request_options,
        )
        return _response.data

    def update(
        self,
        patient_payment_id: PatientPaymentId,
        *,
        payment_timestamp: typing.Optional[dt.datetime] = OMIT,
        payment_note: typing.Optional[NoteUpdate] = OMIT,
        invoice: typing.Optional[InvoiceUpdate] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientPayment:
        """
        Updates the patient payment record matching the provided patient_payment_id.

        Parameters
        ----------
        patient_payment_id : PatientPaymentId

        payment_timestamp : typing.Optional[dt.datetime]

        payment_note : typing.Optional[NoteUpdate]

        invoice : typing.Optional[InvoiceUpdate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPayment

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.patient_payments.v_4.update(
            patient_payment_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.update(
            patient_payment_id,
            payment_timestamp=payment_timestamp,
            payment_note=payment_note,
            invoice=invoice,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self, patient_payment_id: PatientPaymentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes the patient payment record matching the provided patient_payment_id.

        Parameters
        ----------
        patient_payment_id : PatientPaymentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.patient_payments.v_4.delete(
            patient_payment_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete(patient_payment_id, request_options=request_options)
        return _response.data


class AsyncV4Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV4Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV4Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV4Client
        """
        return self._raw_client

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        patient_external_id: typing.Optional[PatientExternalId] = None,
        claim_id: typing.Optional[ClaimId] = None,
        service_line_id: typing.Optional[ServiceLineId] = None,
        billing_provider_id: typing.Optional[ProviderId] = None,
        unattributed: typing.Optional[bool] = None,
        invoice_id: typing.Optional[InvoiceId] = None,
        sources: typing.Optional[
            typing.Union[PatientTransactionSource, typing.Sequence[PatientTransactionSource]]
        ] = None,
        sort: typing.Optional[PatientPaymentSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientPaymentsPage:
        """
        Returns all patient payments satisfying the search criteria AND whose organization_id matches
        the current organization_id of the authenticated user.

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        patient_external_id : typing.Optional[PatientExternalId]

        claim_id : typing.Optional[ClaimId]

        service_line_id : typing.Optional[ServiceLineId]

        billing_provider_id : typing.Optional[ProviderId]

        unattributed : typing.Optional[bool]
            returns payments with unattributed allocations if set to true

        invoice_id : typing.Optional[InvoiceId]

        sources : typing.Optional[typing.Union[PatientTransactionSource, typing.Sequence[PatientTransactionSource]]]

        sort : typing.Optional[PatientPaymentSortField]
            Defaults to payment_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPaymentsPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.patient_payments.v_4.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            limit=limit,
            patient_external_id=patient_external_id,
            claim_id=claim_id,
            service_line_id=service_line_id,
            billing_provider_id=billing_provider_id,
            unattributed=unattributed,
            invoice_id=invoice_id,
            sources=sources,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, patient_payment_id: PatientPaymentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PatientPayment:
        """
        Retrieves a previously created patient payment by its `patient_payment_id`.

        Parameters
        ----------
        patient_payment_id : PatientPaymentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPayment

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.patient_payments.v_4.get(
                patient_payment_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(patient_payment_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        amount_cents: int,
        patient_external_id: PatientExternalId,
        allocations: typing.Sequence[AllocationCreate],
        payment_timestamp: typing.Optional[dt.datetime] = OMIT,
        payment_note: typing.Optional[str] = OMIT,
        invoice: typing.Optional[InvoiceId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientPayment:
        """
        Creates a new patient payment record and returns the newly created PatientPayment object.
        The allocations can describe whether the payment is being applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        amount_cents : int

        patient_external_id : PatientExternalId

        allocations : typing.Sequence[AllocationCreate]

        payment_timestamp : typing.Optional[dt.datetime]

        payment_note : typing.Optional[str]

        invoice : typing.Optional[InvoiceId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPayment

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.financials import (
            AllocationCreate,
            AllocationTargetCreate_ServiceLineById,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.patient_payments.v_4.create(
                amount_cents=1,
                patient_external_id="patient_external_id",
                allocations=[
                    AllocationCreate(
                        amount_cents=1,
                        target=AllocationTargetCreate_ServiceLineById(
                            value=uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            )
                        ),
                    ),
                    AllocationCreate(
                        amount_cents=1,
                        target=AllocationTargetCreate_ServiceLineById(
                            value=uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            )
                        ),
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            amount_cents=amount_cents,
            patient_external_id=patient_external_id,
            allocations=allocations,
            payment_timestamp=payment_timestamp,
            payment_note=payment_note,
            invoice=invoice,
            request_options=request_options,
        )
        return _response.data

    async def update(
        self,
        patient_payment_id: PatientPaymentId,
        *,
        payment_timestamp: typing.Optional[dt.datetime] = OMIT,
        payment_note: typing.Optional[NoteUpdate] = OMIT,
        invoice: typing.Optional[InvoiceUpdate] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientPayment:
        """
        Updates the patient payment record matching the provided patient_payment_id.

        Parameters
        ----------
        patient_payment_id : PatientPaymentId

        payment_timestamp : typing.Optional[dt.datetime]

        payment_note : typing.Optional[NoteUpdate]

        invoice : typing.Optional[InvoiceUpdate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPayment

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.patient_payments.v_4.update(
                patient_payment_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            patient_payment_id,
            payment_timestamp=payment_timestamp,
            payment_note=payment_note,
            invoice=invoice,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, patient_payment_id: PatientPaymentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes the patient payment record matching the provided patient_payment_id.

        Parameters
        ----------
        patient_payment_id : PatientPaymentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.patient_payments.v_4.delete(
                patient_payment_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(patient_payment_id, request_options=request_options)
        return _response.data
