# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.invoice_id import InvoiceId
from .....commons.types.organization_id import OrganizationId
from .....commons.types.patient_external_id import PatientExternalId
from .....financials.types.allocation import Allocation
from .....financials.types.patient_transaction_source import PatientTransactionSource
from .....financials.types.refund_reason import RefundReason
from .patient_refund_id import PatientRefundId


class PatientRefund(UniversalBaseModel):
    patient_refund_id: PatientRefundId
    organization_id: OrganizationId
    source_internal_id: typing.Optional[str] = None
    refund_source: PatientTransactionSource
    amount_cents: int
    patient_external_id: PatientExternalId
    refund_timestamp: typing.Optional[dt.datetime] = None
    refund_note: typing.Optional[str] = None
    allocations: typing.List[Allocation]
    invoice: typing.Optional[InvoiceId] = None
    refund_reason: typing.Optional[RefundReason] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
