# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.entity_not_found_error import EntityNotFoundError
from ....commons.errors.unauthorized_error import UnauthorizedError
from ....commons.errors.unprocessable_entity_error import UnprocessableEntityError
from ....commons.types.entity_not_found_error_message import EntityNotFoundErrorMessage
from ....commons.types.page_token import PageToken
from ....commons.types.payer_plan_group_id import PayerPlanGroupId
from ....commons.types.sort_direction import SortDirection
from ....commons.types.source_of_payment_code import SourceOfPaymentCode
from ....commons.types.unauthorized_error_message import UnauthorizedErrorMessage
from ....commons.types.unprocessable_entity_error_message import UnprocessableEntityErrorMessage
from ....payers.resources.v_3.types.payer_id import PayerId
from ....payers.resources.v_3.types.payer_uuid import PayerUuid
from .errors.payer_plan_group_already_exists_http_error import PayerPlanGroupAlreadyExistsHttpError
from .types.mutable_payer_plan_group import MutablePayerPlanGroup
from .types.payer_plan_group import PayerPlanGroup
from .types.payer_plan_group_already_exists_error import PayerPlanGroupAlreadyExistsError
from .types.payer_plan_group_page import PayerPlanGroupPage
from .types.payer_plan_group_sort_field import PayerPlanGroupSortField

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_multi(
        self,
        *,
        plan_group_name: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        payer_uuid: typing.Optional[typing.Union[PayerUuid, typing.Sequence[PayerUuid]]] = None,
        payer_id: typing.Optional[typing.Union[PayerId, typing.Sequence[PayerId]]] = None,
        plan_type: typing.Optional[typing.Union[SourceOfPaymentCode, typing.Sequence[SourceOfPaymentCode]]] = None,
        is_active: typing.Optional[bool] = None,
        payer_plan_group_id: typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]] = None,
        limit: typing.Optional[int] = None,
        sort_by_similarity: typing.Optional[str] = None,
        sort: typing.Optional[PayerPlanGroupSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PayerPlanGroupPage]:
        """
        Returns all payer plan groups matching filter criteria.

        Parameters
        ----------
        plan_group_name : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        payer_uuid : typing.Optional[typing.Union[PayerUuid, typing.Sequence[PayerUuid]]]

        payer_id : typing.Optional[typing.Union[PayerId, typing.Sequence[PayerId]]]

        plan_type : typing.Optional[typing.Union[SourceOfPaymentCode, typing.Sequence[SourceOfPaymentCode]]]

        is_active : typing.Optional[bool]

        payer_plan_group_id : typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]]

        limit : typing.Optional[int]
            Defaults to 100. Cannot exc

        sort_by_similarity : typing.Optional[str]
            If this property is passed, the results will be ordered by those that contain a payer_id, payer_name, plan_group_name, or
            payer_address most similar to the value passed. This will take precedence over the sort and sort_direction properties. This
            will always sort in order of most similar to least similar.

        sort : typing.Optional[PayerPlanGroupSortField]
            Defaults to plan_group_name. If sort_by_similarity is passed, that sort will takes precedence over this property.

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to ascending order if not provided.

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PayerPlanGroupPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/payer-plan-groups/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "plan_group_name": plan_group_name,
                "payer_uuid": payer_uuid,
                "payer_id": payer_id,
                "plan_type": plan_type,
                "is_active": is_active,
                "payer_plan_group_id": payer_plan_group_id,
                "limit": limit,
                "sort_by_similarity": sort_by_similarity,
                "sort": sort,
                "sort_direction": sort_direction,
                "page_token": page_token,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroupPage,
                parse_obj_as(
                    type_=PayerPlanGroupPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, payer_plan_group_id: PayerPlanGroupId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PayerPlanGroup]:
        """
        Return a plan group with a given ID.

        Parameters
        ----------
        payer_plan_group_id : PayerPlanGroupId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PayerPlanGroup]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/payer-plan-groups/v1/{jsonable_encoder(payer_plan_group_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroup,
                parse_obj_as(
                    type_=PayerPlanGroup,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self, *, request: MutablePayerPlanGroup, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PayerPlanGroup]:
        """
        Create a payer plan group

        Parameters
        ----------
        request : MutablePayerPlanGroup

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PayerPlanGroup]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/payer-plan-groups/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroup,
                parse_obj_as(
                    type_=PayerPlanGroup,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "PayerPlanGroupAlreadyExistsHttpError":
                raise PayerPlanGroupAlreadyExistsHttpError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        PayerPlanGroupAlreadyExistsError,
                        parse_obj_as(
                            type_=PayerPlanGroupAlreadyExistsError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        payer_plan_group_id: PayerPlanGroupId,
        *,
        request: MutablePayerPlanGroup,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PayerPlanGroup]:
        """
        Update any of the fields on a payer plan group

        Parameters
        ----------
        payer_plan_group_id : PayerPlanGroupId

        request : MutablePayerPlanGroup

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PayerPlanGroup]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/payer-plan-groups/v1/{jsonable_encoder(payer_plan_group_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PUT",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroup,
                parse_obj_as(
                    type_=PayerPlanGroup,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "PayerPlanGroupAlreadyExistsHttpError":
                raise PayerPlanGroupAlreadyExistsHttpError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        PayerPlanGroupAlreadyExistsError,
                        parse_obj_as(
                            type_=PayerPlanGroupAlreadyExistsError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def deactivate(
        self, payer_plan_group_id: PayerPlanGroupId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PayerPlanGroup]:
        """
        Marks the payer plan group as deactivated

        Parameters
        ----------
        payer_plan_group_id : PayerPlanGroupId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PayerPlanGroup]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/payer-plan-groups/v1/{jsonable_encoder(payer_plan_group_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroup,
                parse_obj_as(
                    type_=PayerPlanGroup,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_multi(
        self,
        *,
        plan_group_name: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        payer_uuid: typing.Optional[typing.Union[PayerUuid, typing.Sequence[PayerUuid]]] = None,
        payer_id: typing.Optional[typing.Union[PayerId, typing.Sequence[PayerId]]] = None,
        plan_type: typing.Optional[typing.Union[SourceOfPaymentCode, typing.Sequence[SourceOfPaymentCode]]] = None,
        is_active: typing.Optional[bool] = None,
        payer_plan_group_id: typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]] = None,
        limit: typing.Optional[int] = None,
        sort_by_similarity: typing.Optional[str] = None,
        sort: typing.Optional[PayerPlanGroupSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PayerPlanGroupPage]:
        """
        Returns all payer plan groups matching filter criteria.

        Parameters
        ----------
        plan_group_name : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        payer_uuid : typing.Optional[typing.Union[PayerUuid, typing.Sequence[PayerUuid]]]

        payer_id : typing.Optional[typing.Union[PayerId, typing.Sequence[PayerId]]]

        plan_type : typing.Optional[typing.Union[SourceOfPaymentCode, typing.Sequence[SourceOfPaymentCode]]]

        is_active : typing.Optional[bool]

        payer_plan_group_id : typing.Optional[typing.Union[PayerPlanGroupId, typing.Sequence[PayerPlanGroupId]]]

        limit : typing.Optional[int]
            Defaults to 100. Cannot exc

        sort_by_similarity : typing.Optional[str]
            If this property is passed, the results will be ordered by those that contain a payer_id, payer_name, plan_group_name, or
            payer_address most similar to the value passed. This will take precedence over the sort and sort_direction properties. This
            will always sort in order of most similar to least similar.

        sort : typing.Optional[PayerPlanGroupSortField]
            Defaults to plan_group_name. If sort_by_similarity is passed, that sort will takes precedence over this property.

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to ascending order if not provided.

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PayerPlanGroupPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/payer-plan-groups/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "plan_group_name": plan_group_name,
                "payer_uuid": payer_uuid,
                "payer_id": payer_id,
                "plan_type": plan_type,
                "is_active": is_active,
                "payer_plan_group_id": payer_plan_group_id,
                "limit": limit,
                "sort_by_similarity": sort_by_similarity,
                "sort": sort,
                "sort_direction": sort_direction,
                "page_token": page_token,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroupPage,
                parse_obj_as(
                    type_=PayerPlanGroupPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, payer_plan_group_id: PayerPlanGroupId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PayerPlanGroup]:
        """
        Return a plan group with a given ID.

        Parameters
        ----------
        payer_plan_group_id : PayerPlanGroupId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PayerPlanGroup]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/payer-plan-groups/v1/{jsonable_encoder(payer_plan_group_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroup,
                parse_obj_as(
                    type_=PayerPlanGroup,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self, *, request: MutablePayerPlanGroup, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PayerPlanGroup]:
        """
        Create a payer plan group

        Parameters
        ----------
        request : MutablePayerPlanGroup

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PayerPlanGroup]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/payer-plan-groups/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroup,
                parse_obj_as(
                    type_=PayerPlanGroup,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "PayerPlanGroupAlreadyExistsHttpError":
                raise PayerPlanGroupAlreadyExistsHttpError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        PayerPlanGroupAlreadyExistsError,
                        parse_obj_as(
                            type_=PayerPlanGroupAlreadyExistsError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        payer_plan_group_id: PayerPlanGroupId,
        *,
        request: MutablePayerPlanGroup,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PayerPlanGroup]:
        """
        Update any of the fields on a payer plan group

        Parameters
        ----------
        payer_plan_group_id : PayerPlanGroupId

        request : MutablePayerPlanGroup

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PayerPlanGroup]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/payer-plan-groups/v1/{jsonable_encoder(payer_plan_group_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PUT",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroup,
                parse_obj_as(
                    type_=PayerPlanGroup,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "PayerPlanGroupAlreadyExistsHttpError":
                raise PayerPlanGroupAlreadyExistsHttpError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        PayerPlanGroupAlreadyExistsError,
                        parse_obj_as(
                            type_=PayerPlanGroupAlreadyExistsError,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def deactivate(
        self, payer_plan_group_id: PayerPlanGroupId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PayerPlanGroup]:
        """
        Marks the payer plan group as deactivated

        Parameters
        ----------
        payer_plan_group_id : PayerPlanGroupId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PayerPlanGroup]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/payer-plan-groups/v1/{jsonable_encoder(payer_plan_group_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                PayerPlanGroup,
                parse_obj_as(
                    type_=PayerPlanGroup,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
