# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawPayersClient, RawPayersClient
from .resources.v_3.client import AsyncV3Client, V3Client


class PayersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPayersClient(client_wrapper=client_wrapper)
        self.v_3 = V3Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPayersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPayersClient
        """
        return self._raw_client


class AsyncPayersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPayersClient(client_wrapper=client_wrapper)
        self.v_3 = AsyncV3Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPayersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPayersClient
        """
        return self._raw_client
