# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.street_address_long_zip import StreetAddressLongZip
from .payer_uuid import PayerUuid


class Payer(UniversalBaseModel):
    """
    Examples
    --------
    import uuid

    from candid.resources.payers.resources.v_3 import Payer

    Payer(
        payer_uuid=uuid.UUID(
            "a6431fd2-0712-4714-b1b1-dd094daf9f42",
        ),
        payer_id="12345",
        payer_name="Payer Name",
        availity_payer_name="Availity Payer Name",
        availity_claims_payer_id="54321",
        availity_eligibility_id="54321",
        availity_remittance_payer_id="54321",
    )
    """

    payer_uuid: PayerUuid = pydantic.Field()
    """
    Auto-generated ID set on creation.
    """

    payer_id: str = pydantic.Field()
    """
    The primary national payer ID of the payer.
    """

    payer_name: str = pydantic.Field()
    """
    The primary display name of the payer.
    """

    availity_payer_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the payer as it appears in Availity.
    """

    availity_claims_payer_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the payer as it appears in Availity.
    """

    availity_eligibility_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The eligibility ID of the payer as it appears in Availity.
    """

    availity_remittance_payer_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The remittance ID of the payer as it appears in Availity.
    """

    street_address: typing.Optional[StreetAddressLongZip] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
