# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
from .....commons.types.resource_page import ResourcePage
from .payer import Payer


class PayerPage(ResourcePage):
    """
    Examples
    --------
    import uuid

    from candid.resources.payers.resources.v_3 import Payer, PayerPage

    PayerPage(
        items=[
            Payer(
                payer_uuid=uuid.UUID(
                    "a6431fd2-0712-4714-b1b1-dd094daf9f42",
                ),
                payer_id="12345",
                payer_name="Payer Name",
                availity_payer_name="Availity Payer Name",
                availity_claims_payer_id="54321",
                availity_eligibility_id="54321",
                availity_remittance_payer_id="54321",
            )
        ],
    )
    """

    items: typing.List[Payer]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
