# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawPreEncounterClient, RawPreEncounterClient
from .resources.appointments.client import AppointmentsClient, AsyncAppointmentsClient
from .resources.coverages.client import AsyncCoveragesClient, CoveragesClient
from .resources.eligibility_checks.client import AsyncEligibilityChecksClient, EligibilityChecksClient
from .resources.images.client import AsyncImagesClient, ImagesClient
from .resources.lists.client import AsyncListsClient, ListsClient
from .resources.notes.client import AsyncNotesClient, NotesClient
from .resources.patients.client import AsyncPatientsClient, PatientsClient
from .resources.tags.client import AsyncTagsClient, TagsClient


class PreEncounterClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPreEncounterClient(client_wrapper=client_wrapper)
        self.appointments = AppointmentsClient(client_wrapper=client_wrapper)

        self.coverages = CoveragesClient(client_wrapper=client_wrapper)

        self.eligibility_checks = EligibilityChecksClient(client_wrapper=client_wrapper)

        self.images = ImagesClient(client_wrapper=client_wrapper)

        self.lists = ListsClient(client_wrapper=client_wrapper)

        self.notes = NotesClient(client_wrapper=client_wrapper)

        self.patients = PatientsClient(client_wrapper=client_wrapper)

        self.tags = TagsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPreEncounterClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPreEncounterClient
        """
        return self._raw_client


class AsyncPreEncounterClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPreEncounterClient(client_wrapper=client_wrapper)
        self.appointments = AsyncAppointmentsClient(client_wrapper=client_wrapper)

        self.coverages = AsyncCoveragesClient(client_wrapper=client_wrapper)

        self.eligibility_checks = AsyncEligibilityChecksClient(client_wrapper=client_wrapper)

        self.images = AsyncImagesClient(client_wrapper=client_wrapper)

        self.lists = AsyncListsClient(client_wrapper=client_wrapper)

        self.notes = AsyncNotesClient(client_wrapper=client_wrapper)

        self.patients = AsyncPatientsClient(client_wrapper=client_wrapper)

        self.tags = AsyncTagsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPreEncounterClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPreEncounterClient
        """
        return self._raw_client
