# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ........core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....common.types.external_provider import ExternalProvider
from .....common.types.patient_id import PatientId
from .appointment_status import AppointmentStatus
from .appointment_work_queue import AppointmentWorkQueue
from .service import Service


class MutableAppointment(UniversalBaseModel):
    """
    An object representing a appointment.
    """

    patient_id: PatientId = pydantic.Field()
    """
    The Candid-defined patient identifier.
    """

    start_timestamp: dt.datetime
    status: typing.Optional[AppointmentStatus] = pydantic.Field(default=None)
    """
    Defaults to PENDING. If status is NOT_READY, work_queue must be set. If status is READY or CHECKED_IN, work_queue must be null. If status is CHECKED_IN, checked_in_timestamp must be set. If checked_in_timestamp is set, status must be CHECKED_IN.
    """

    service_duration: int = pydantic.Field()
    """
    The requested length of time allotted for the appointment. The units are in minutes.
    """

    services: typing.List[Service]
    placer_appointment_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID for the appointment/order for the event.
    """

    attending_doctor: typing.Optional[ExternalProvider] = pydantic.Field(default=None)
    """
    Attending physician information. The attending physician will be stored as the Current MD for the patient.
    """

    estimated_copay_cents: typing.Optional[int] = None
    estimated_patient_responsibility_cents: typing.Optional[int] = None
    patient_deposit_cents: typing.Optional[int] = None
    checked_in_timestamp: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the patient checked in for their appointment. If status is CHECKED_IN, checked_in_timestamp must be set. If checked_in_timestamp is set, status must be CHECKED_IN.
    """

    notes: typing.Optional[str] = None
    location_resource_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Contains the coded identification of the location being scheduled. Components: <Identifier (ST)>^<Text (ST)>
    """

    automated_eligibility_check_complete: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the automated eligibility check has been completed. It is not recommended to change this value manually via API. This refers explicitly to the automated eligibility check that occurs a specific number of days before the appointment.
    """

    work_queue: typing.Optional[AppointmentWorkQueue] = pydantic.Field(default=None)
    """
    The work queue that the appointment belongs to. It is not recommended to change this value manually via API. If status is NOT_READY, work_queue must be set. If status is READY, work_queue must be null.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
