# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ........core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....common.types.patient_id import PatientId
from .....patients.resources.v_1.types.mutable_patient_with_mrn import MutablePatientWithMrn
from .appointment_status import AppointmentStatus


class Visit(UniversalBaseModel):
    """
    A visit is a collection of appointments that occur on the same day.
    """

    patient_id: PatientId
    patient: MutablePatientWithMrn
    start_time: dt.datetime
    status: AppointmentStatus

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
