# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .organization_id import OrganizationId
from .user_id import UserId


class BaseModel(UniversalBaseModel):
    organization_id: OrganizationId = pydantic.Field()
    """
    The organization that owns this object.
    """

    deactivated: bool = pydantic.Field()
    """
    True if the object is deactivated.  Deactivated objects are not returned in search results but are returned in all other endpoints including scan.
    """

    version: int = pydantic.Field()
    """
    The version of the object.  Any update to any property of an object object will create a new version.
    """

    updated_at: dt.datetime
    updating_user_id: UserId = pydantic.Field()
    """
    The user ID of the user who last updated the object.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
