# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .......core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .......core.request_options import RequestOptions
from ....common.types.coverage_id import CoverageId
from ....common.types.page_token import PageToken
from ....common.types.payer_plan_group_id import PayerPlanGroupId
from ....eligibility_checks.resources.v_1.types.eligibility_check_metadata import EligibilityCheckMetadata
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.coverage import Coverage
from .types.coverage_eligibility_check_response import CoverageEligibilityCheckResponse
from .types.coverages_page import CoveragesPage
from .types.mutable_coverage import MutableCoverage
from .types.payer_plan_group_fields import PayerPlanGroupFields
from .types.service_type_code import ServiceTypeCode

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def create(self, *, request: MutableCoverage, request_options: typing.Optional[RequestOptions] = None) -> Coverage:
        """
        Creates a new Coverage. A Coverage provides the high-level identifiers and descriptors of a specific insurance plan for a specific individual - typically the information you can find on an insurance card. Additionally a coverage will include detailed benefits information covered by the specific plan for the individual.

        Parameters
        ----------
        request : MutableCoverage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Coverage

        Examples
        --------
        import datetime

        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.coverages.resources.v_1 import (
            CoverageStatus,
            InsurancePlan,
            MutableCoverage,
            Subscriber,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.create(
            request=MutableCoverage(
                status=CoverageStatus.ACTIVE,
                subscriber=Subscriber(
                    name=HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                    date_of_birth=datetime.date.fromisoformat(
                        "2023-01-15",
                    ),
                    biological_sex=Sex.FEMALE,
                ),
                relationship=Relationship.SELF,
                patient="patient",
                insurance_plan=InsurancePlan(
                    member_id="member_id",
                    payer_id="payer_id",
                    payer_name="payer_name",
                ),
                verified=True,
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self,
        id: CoverageId,
        version: str,
        *,
        request: MutableCoverage,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Coverage:
        """
        Updates a Coverage.  The path must contain the most recent version to prevent race conditions.  Updating historic versions is not supported.

        Parameters
        ----------
        id : CoverageId

        version : str

        request : MutableCoverage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Coverage

        Examples
        --------
        import datetime
        import uuid

        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.coverages.resources.v_1 import (
            CoverageStatus,
            InsurancePlan,
            MutableCoverage,
            Subscriber,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.update(
            id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            version="version",
            request=MutableCoverage(
                status=CoverageStatus.ACTIVE,
                subscriber=Subscriber(
                    name=HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                    date_of_birth=datetime.date.fromisoformat(
                        "2023-01-15",
                    ),
                    biological_sex=Sex.FEMALE,
                ),
                relationship=Relationship.SELF,
                patient="patient",
                insurance_plan=InsurancePlan(
                    member_id="member_id",
                    payer_id="payer_id",
                    payer_name="payer_name",
                ),
                verified=True,
            ),
        )
        """
        _response = self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    def get_multi_paginated(
        self,
        *,
        patient_id: typing.Optional[str] = None,
        payer_plan_group_id: typing.Optional[str] = None,
        page_token: typing.Optional[PageToken] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CoveragesPage:
        """
        Returns a page of Coverages based on the search criteria.

        Parameters
        ----------
        patient_id : typing.Optional[str]

        payer_plan_group_id : typing.Optional[str]

        page_token : typing.Optional[PageToken]

        limit : typing.Optional[int]
            Must be between 0 and 1000. Defaults to 100

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CoveragesPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.get_multi_paginated()
        """
        _response = self._raw_client.get_multi_paginated(
            patient_id=patient_id,
            payer_plan_group_id=payer_plan_group_id,
            page_token=page_token,
            limit=limit,
            request_options=request_options,
        )
        return _response.data

    def get(self, id: CoverageId, *, request_options: typing.Optional[RequestOptions] = None) -> Coverage:
        """
        gets a specific Coverage

        Parameters
        ----------
        id : CoverageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Coverage

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.get(
            id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def get_history(
        self, id: CoverageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Coverage]:
        """
        Gets a coverage along with it's full history.  The return list is ordered by version ascending.

        Parameters
        ----------
        id : CoverageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Coverage]

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.get_history(
            id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get_history(id, request_options=request_options)
        return _response.data

    def get_multi(
        self, *, patient_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Coverage]:
        """
        Returns a list of Coverages based on the search criteria.

        Parameters
        ----------
        patient_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Coverage]

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.get_multi()
        """
        _response = self._raw_client.get_multi(patient_id=patient_id, request_options=request_options)
        return _response.data

    def scan(
        self, *, since: dt.datetime, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Coverage]:
        """
        Scans up to 100 coverage updates.  The since query parameter is inclusive, and the result list is ordered by updatedAt ascending.

        Parameters
        ----------
        since : dt.datetime

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Coverage]

        Examples
        --------
        import datetime

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.scan(
            since=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
        )
        """
        _response = self._raw_client.scan(since=since, request_options=request_options)
        return _response.data

    def batch_update_ppg(
        self,
        ppg_id: PayerPlanGroupId,
        *,
        request: PayerPlanGroupFields,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Finds all coverages associated with the given ppg_id and updates the ppg_fields for each coverage.

        Parameters
        ----------
        ppg_id : PayerPlanGroupId

        request : PayerPlanGroupFields

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.coverages.resources.v_1 import (
            NetworkType,
            PayerPlanGroupFields,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.batch_update_ppg(
            ppg_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=PayerPlanGroupFields(
                payer_plan_group_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                payer_id="payer_id",
                payer_name="payer_name",
                plan_type=NetworkType.SELF_PAY,
            ),
        )
        """
        _response = self._raw_client.batch_update_ppg(ppg_id, request=request, request_options=request_options)
        return _response.data

    def check_eligibility(
        self,
        id: CoverageId,
        *,
        service_code: ServiceTypeCode,
        date_of_service: dt.date,
        npi: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EligibilityCheckMetadata:
        """
        Initiates an eligibility check. Returns the metadata of the check if successfully initiated.

        Parameters
        ----------
        id : CoverageId

        service_code : ServiceTypeCode

        date_of_service : dt.date

        npi : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EligibilityCheckMetadata

        Examples
        --------
        import datetime
        import uuid

        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.coverages.resources.v_1 import (
            ServiceTypeCode,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.check_eligibility(
            id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            service_code=ServiceTypeCode.MEDICAL_CARE,
            date_of_service=datetime.date.fromisoformat(
                "2023-01-15",
            ),
            npi="npi",
        )
        """
        _response = self._raw_client.check_eligibility(
            id, service_code=service_code, date_of_service=date_of_service, npi=npi, request_options=request_options
        )
        return _response.data

    def get_eligibility(
        self, id: CoverageId, check_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CoverageEligibilityCheckResponse:
        """
        Gets the eligibility of a patient for a specific coverage if successful.

        Parameters
        ----------
        id : CoverageId

        check_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CoverageEligibilityCheckResponse

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.coverages.v_1.get_eligibility(
            id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            check_id="check_id",
        )
        """
        _response = self._raw_client.get_eligibility(id, check_id, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def create(
        self, *, request: MutableCoverage, request_options: typing.Optional[RequestOptions] = None
    ) -> Coverage:
        """
        Creates a new Coverage. A Coverage provides the high-level identifiers and descriptors of a specific insurance plan for a specific individual - typically the information you can find on an insurance card. Additionally a coverage will include detailed benefits information covered by the specific plan for the individual.

        Parameters
        ----------
        request : MutableCoverage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Coverage

        Examples
        --------
        import asyncio
        import datetime

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.coverages.resources.v_1 import (
            CoverageStatus,
            InsurancePlan,
            MutableCoverage,
            Subscriber,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.create(
                request=MutableCoverage(
                    status=CoverageStatus.ACTIVE,
                    subscriber=Subscriber(
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        date_of_birth=datetime.date.fromisoformat(
                            "2023-01-15",
                        ),
                        biological_sex=Sex.FEMALE,
                    ),
                    relationship=Relationship.SELF,
                    patient="patient",
                    insurance_plan=InsurancePlan(
                        member_id="member_id",
                        payer_id="payer_id",
                        payer_name="payer_name",
                    ),
                    verified=True,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: CoverageId,
        version: str,
        *,
        request: MutableCoverage,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Coverage:
        """
        Updates a Coverage.  The path must contain the most recent version to prevent race conditions.  Updating historic versions is not supported.

        Parameters
        ----------
        id : CoverageId

        version : str

        request : MutableCoverage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Coverage

        Examples
        --------
        import asyncio
        import datetime
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.coverages.resources.v_1 import (
            CoverageStatus,
            InsurancePlan,
            MutableCoverage,
            Subscriber,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.update(
                id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                version="version",
                request=MutableCoverage(
                    status=CoverageStatus.ACTIVE,
                    subscriber=Subscriber(
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        date_of_birth=datetime.date.fromisoformat(
                            "2023-01-15",
                        ),
                        biological_sex=Sex.FEMALE,
                    ),
                    relationship=Relationship.SELF,
                    patient="patient",
                    insurance_plan=InsurancePlan(
                        member_id="member_id",
                        payer_id="payer_id",
                        payer_name="payer_name",
                    ),
                    verified=True,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    async def get_multi_paginated(
        self,
        *,
        patient_id: typing.Optional[str] = None,
        payer_plan_group_id: typing.Optional[str] = None,
        page_token: typing.Optional[PageToken] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CoveragesPage:
        """
        Returns a page of Coverages based on the search criteria.

        Parameters
        ----------
        patient_id : typing.Optional[str]

        payer_plan_group_id : typing.Optional[str]

        page_token : typing.Optional[PageToken]

        limit : typing.Optional[int]
            Must be between 0 and 1000. Defaults to 100

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CoveragesPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.get_multi_paginated()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi_paginated(
            patient_id=patient_id,
            payer_plan_group_id=payer_plan_group_id,
            page_token=page_token,
            limit=limit,
            request_options=request_options,
        )
        return _response.data

    async def get(self, id: CoverageId, *, request_options: typing.Optional[RequestOptions] = None) -> Coverage:
        """
        gets a specific Coverage

        Parameters
        ----------
        id : CoverageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Coverage

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.get(
                id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def get_history(
        self, id: CoverageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Coverage]:
        """
        Gets a coverage along with it's full history.  The return list is ordered by version ascending.

        Parameters
        ----------
        id : CoverageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Coverage]

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.get_history(
                id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_history(id, request_options=request_options)
        return _response.data

    async def get_multi(
        self, *, patient_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Coverage]:
        """
        Returns a list of Coverages based on the search criteria.

        Parameters
        ----------
        patient_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Coverage]

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(patient_id=patient_id, request_options=request_options)
        return _response.data

    async def scan(
        self, *, since: dt.datetime, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Coverage]:
        """
        Scans up to 100 coverage updates.  The since query parameter is inclusive, and the result list is ordered by updatedAt ascending.

        Parameters
        ----------
        since : dt.datetime

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Coverage]

        Examples
        --------
        import asyncio
        import datetime

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.scan(
                since=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.scan(since=since, request_options=request_options)
        return _response.data

    async def batch_update_ppg(
        self,
        ppg_id: PayerPlanGroupId,
        *,
        request: PayerPlanGroupFields,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Finds all coverages associated with the given ppg_id and updates the ppg_fields for each coverage.

        Parameters
        ----------
        ppg_id : PayerPlanGroupId

        request : PayerPlanGroupFields

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.coverages.resources.v_1 import (
            NetworkType,
            PayerPlanGroupFields,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.batch_update_ppg(
                ppg_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=PayerPlanGroupFields(
                    payer_plan_group_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    payer_id="payer_id",
                    payer_name="payer_name",
                    plan_type=NetworkType.SELF_PAY,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.batch_update_ppg(ppg_id, request=request, request_options=request_options)
        return _response.data

    async def check_eligibility(
        self,
        id: CoverageId,
        *,
        service_code: ServiceTypeCode,
        date_of_service: dt.date,
        npi: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EligibilityCheckMetadata:
        """
        Initiates an eligibility check. Returns the metadata of the check if successfully initiated.

        Parameters
        ----------
        id : CoverageId

        service_code : ServiceTypeCode

        date_of_service : dt.date

        npi : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EligibilityCheckMetadata

        Examples
        --------
        import asyncio
        import datetime
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.coverages.resources.v_1 import (
            ServiceTypeCode,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.check_eligibility(
                id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                service_code=ServiceTypeCode.MEDICAL_CARE,
                date_of_service=datetime.date.fromisoformat(
                    "2023-01-15",
                ),
                npi="npi",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.check_eligibility(
            id, service_code=service_code, date_of_service=date_of_service, npi=npi, request_options=request_options
        )
        return _response.data

    async def get_eligibility(
        self, id: CoverageId, check_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CoverageEligibilityCheckResponse:
        """
        Gets the eligibility of a patient for a specific coverage if successful.

        Parameters
        ----------
        id : CoverageId

        check_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CoverageEligibilityCheckResponse

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.coverages.v_1.get_eligibility(
                id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                check_id="check_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_eligibility(id, check_id, request_options=request_options)
        return _response.data
