# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CoverageStatus(str, enum.Enum):
    """
    enum to represent the statuses defined at https://build.fhir.org/valueset-fm-status.html
    """

    ACTIVE = "ACTIVE"
    CANCELLED = "CANCELLED"
    DRAFT = "DRAFT"
    ENTERED_IN_ERROR = "ENTERED_IN_ERROR"
    _UNKNOWN = "__COVERAGESTATUS_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "CoverageStatus":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        active: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        draft: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is CoverageStatus.ACTIVE:
            return active()
        if self is CoverageStatus.CANCELLED:
            return cancelled()
        if self is CoverageStatus.DRAFT:
            return draft()
        if self is CoverageStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        return _unknown_member(self._value_)
