# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ........core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....common.types.patient_id import PatientId
from .....common.types.relationship import Relationship
from .....eligibility_checks.resources.v_1.types.eligibility_check_metadata import EligibilityCheckMetadata
from .coverage_benefits import CoverageBenefits
from .coverage_status import CoverageStatus
from .insurance_plan import InsurancePlan
from .latest_eligibility_check import LatestEligibilityCheck
from .subscriber import Subscriber


class MutableCoverage(UniversalBaseModel):
    status: CoverageStatus = pydantic.Field()
    """
    The status indiciating if the coverage is active or not.
    """

    subscriber: Subscriber = pydantic.Field()
    """
    The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.
    """

    relationship: Relationship = pydantic.Field()
    """
    The relationship of beneficiary (patient) to the subscriber. https://hl7.org/fhir/valueset-relationship.html
    """

    patient: PatientId = pydantic.Field()
    """
    The patient who benefits from the insurance coverage
    """

    insurance_plan: InsurancePlan
    verified: bool = pydantic.Field()
    """
    A boolean indicating if the coverage has been verified by a user.
    """

    eligibility_checks: typing.Optional[typing.List[EligibilityCheckMetadata]] = pydantic.Field(default=None)
    """
    A list of eligibility check metadata that have been initiated on this coverage.
    """

    latest_eligibility_check: typing.Optional[LatestEligibilityCheck] = pydantic.Field(default=None)
    """
    The latest eligibility check metadata that has been initiated on this coverage.
    """

    benefits: typing.Optional[CoverageBenefits] = pydantic.Field(default=None)
    """
    The eligibility of the patient for the coverage, manually verified by users.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
