# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ServiceTypeCode(str, enum.Enum):
    """
    Code identifying the type of service or benefit within a specific insurance policy (X12 008010 Element 1365)
    """

    MEDICAL_CARE = "1"
    """
    Medical Care
    """

    SURGICAL = "2"
    """
    Surgical
    """

    CONSULTATION = "3"
    """
    Consultation
    """

    DIAGNOSTIC_X_RAY = "4"
    """
    Diagnostic X-Ray
    """

    DIAGNOSTIC_LAB = "5"
    """
    Diagnostic Lab
    """

    RADIATION_THERAPY = "6"
    """
    Radiation Therapy
    """

    ANESTHESIA = "7"
    """
    Anesthesia
    """

    SURGICAL_ASSISTANCE = "8"
    """
    Surgical Assistance
    """

    OTHER_MEDICAL = "9"
    """
    Other Medical
    """

    BLOOD_CHARGES = "10"
    """
    Blood Charges
    """

    USED_DURABLE_MEDICAL_EQUIPMENT = "11"
    """
    Used Durable Medical Equipment
    """

    DURABLE_MEDICAL_EQUIPMENT_PURCHASE = "12"
    """
    Durable Medical Equipment Purchase
    """

    AMBULATORY_SURGICAL_CENTER_FACILITY = "13"
    """
    Ambulatory Service Center Facility
    """

    RENAL_SUPPLIES_IN_HOME = "14"
    """
    Renal Supplies in the Home
    """

    ALTERNATE_METHOD_DIALYSIS = "15"
    """
    Alternate Method Dialysis
    """

    CHRONIC_RENAL_DISEASE_EQUIPMENT = "16"
    """
    Chronic Renal Disease (CRD) Equipment
    """

    PRE_ADMISSION_TESTING = "17"
    """
    Pre-Admission Testing
    """

    DURABLE_MEDICAL_EQUIPMENT_RENTAL = "18"
    """
    Durable Medical Equipment Rental
    """

    PNEUMONIA_VACCINE = "19"
    """
    Pneumonia Vaccine
    """

    SECOND_SURGICAL_OPINION = "20"
    """
    Second Surgical Opinion
    """

    THIRD_SURGICAL_OPINION = "21"
    """
    Third Surgical Opinion
    """

    SOCIAL_WORK = "22"
    """
    Social Work
    """

    DIAGNOSTIC_DENTAL = "23"
    """
    Diagnostic Dental
    """

    PERIODONTICS = "24"
    """
    Periodontics
    """

    RESTORATIVE = "25"
    """
    Restorative
    """

    ENDODONTICS = "26"
    """
    Endodontics
    """

    MAXILLOFACIAL_PROSTHETICS = "27"
    """
    Maxillofacial Prosthetics
    """

    ADJUNCTIVE_DENTAL_SERVICES = "28"
    """
    Adjunctive Dental Services
    """

    HEALTH_BENEFIT_PLAN_COVERAGE = "30"
    """
    Health Benefit Plan Coverage
    """

    PLAN_WAITING_PERIOD = "32"
    """
    Plan Waiting Period
    """

    CHIROPRACTIC = "33"
    """
    Chiropractic
    """

    CHIROPRACTIC_OFFICE_VISITS = "34"
    """
    Chiropractic Office Visits
    """

    DENTAL_CARE = "35"
    """
    Dental Care
    """

    DENTAL_CROWNS = "36"
    """
    Dental Crowns
    """

    DENTAL_ACCIDENT = "37"
    """
    Dental Accident
    """

    ORTHODONTICS = "38"
    """
    Orthodontics
    """

    PROSTHODONTICS = "39"
    """
    Prosthodontics
    """

    ORAL_SURGERY = "40"
    """
    Oral Surgery
    """

    ROUTINE_PREVENTIVE_DENTAL = "41"
    """
    Routine (Preventive) Dental
    """

    HOME_HEALTH_CARE = "42"
    """
    Home Health Care
    """

    HOME_HEALTH_PRESCRIPTIONS = "43"
    """
    Home Health Prescriptions
    """

    HOME_HEALTH_VISITS = "44"
    """
    Home Health Visits
    """

    HOSPICE = "45"
    """
    Hospice
    """

    RESPITE_CARE = "46"
    """
    Respite Care
    """

    HOSPITAL = "47"
    """
    Hospital
    """

    HOSPITAL_INPATIENT = "48"
    """
    Hospital - Inpatient
    """

    HOSPITAL_ROOM_AND_BOARD = "49"
    """
    Hospital - Room and Board
    """

    HOSPITAL_OUTPATIENT = "50"
    """
    Hospital - Outpatient
    """

    HOSPITAL_EMERGENCY_ACCIDENT = "51"
    """
    Hospital - Emergency Accident
    """

    HOSPITAL_EMERGENCY_MEDICAL = "52"
    """
    Hospital - Emergency Medical
    """

    HOSPITAL_AMBULATORY_SURGICAL = "53"
    """
    Hospital - Ambulatory Surgical
    """

    LONG_TERM_CARE = "54"
    """
    Long Term Care
    """

    MAJOR_MEDICAL = "55"
    """
    Major Medical
    """

    MEDICALLY_RELATED_TRANSPORTATION = "56"
    """
    Medically Related Transportation
    """

    AIR_TRANSPORTATION = "57"
    """
    Air Transportation
    """

    CABULANCE = "58"
    """
    Cabulance
    """

    LICENSED_AMBULANCE = "59"
    """
    Licensed Ambulance
    """

    GENERAL_BENEFITS = "60"
    """
    General Benefits
    """

    IN_VITRO_FERTILIZATION = "61"
    """
    In-vitro Fertilization
    """

    MRICAT_SCAN = "62"
    """
    MRI/CAT Scan
    """

    DONOR_PROCEDURES = "63"
    """
    Donor Procedures
    """

    ACUPUNCTURE = "64"
    """
    Acupuncture
    """

    NEWBORN_CARE = "65"
    """
    Newborn Care
    """

    PATHOLOGY = "66"
    """
    Pathology
    """

    SMOKING_CESSATION = "67"
    """
    Smoking Cessation
    """

    WELL_BABY_CARE = "68"
    """
    Well Baby Care
    """

    MATERNITY = "69"
    """
    Maternity
    """

    TRANSPLANTS = "70"
    """
    Transplants
    """

    AUDIOLOGY_EXAM = "71"
    """
    Audiology Exam
    """

    INHALATION_THERAPY = "72"
    """
    Inhalation Therapy
    """

    DIAGNOSTIC_MEDICAL = "73"
    """
    Diagnostic Medical
    """

    PRIVATE_DUTY_NURSING = "74"
    """
    Private Duty Nursing
    """

    PROSTHETIC_DEVICE = "75"
    """
    Prosthetic Device
    """

    DIALYSIS = "76"
    """
    Dialysis
    """

    OTOLOGICAL_EXAM = "77"
    """
    Otological Exam
    """

    CHEMOTHERAPY = "78"
    """
    Chemotherapy
    """

    ALLERGY_TESTING = "79"
    """
    Allergy Testing
    """

    IMMUNIZATIONS = "80"
    """
    Immunizations
    """

    ROUTINE_PHYSICAL = "81"
    """
    Routine Physical
    """

    FAMILY_PLANNING = "82"
    """
    Family Planning
    """

    INFERTILITY = "83"
    """
    Infertility
    """

    ABORTION = "84"
    """
    Abortion
    """

    AIDS = "85"
    """
    AIDS
    """

    EMERGENCY_SERVICES = "86"
    """
    Emergency Services
    """

    CANCER = "87"
    """
    Cancer
    """

    PHARMACY = "88"
    """
    Pharmacy
    """

    FREE_STANDING_PRESCRIPTION_DRUG = "89"
    """
    Free Standing Prescription Drug
    """

    MAIL_ORDER_PRESCRIPTION_DRUG = "90"
    """
    Mail Order Prescription Drug
    """

    BRAND_NAME_PRESCRIPTION_DRUG = "91"
    """
    Brand Name Prescription Drug
    """

    GENERIC_PRESCRIPTION_DRUG = "92"
    """
    Generic Prescription Drug
    """

    PODIATRY = "93"
    """
    Podiatry
    """

    PODIATRY_OFFICE_VISITS = "94"
    """
    Podiatry - Office Visits
    """

    PODIATRY_NURSING_HOME_VISITS = "95"
    """
    Podiatry - Nursing Home Visits
    """

    PROFESSIONAL_PHYSICIAN = "96"
    """
    Professional (Physician)
    """

    ANESTHESIOLOGIST = "97"
    """
    Anesthesiologist
    """

    PROFESSIONAL_PHYSICIAN_VISIT_OFFICE = "98"
    """
    Professional (Physician) Visit - Office
    """

    PROFESSIONAL_PHYSICIAN_VISIT_INPATIENT = "99"
    """
    Professional (Physician) Visit - Inpatient
    """

    PROFESSIONAL_PHYSICIAN_VISIT_OUTPATIENT = "A0"
    """
    Professional (Physician) Visit - Outpatient
    """

    PROFESSIONAL_PHYSICIAN_VISIT_NURSING_HOME = "A1"
    """
    Professional (Physician) Visit - Nursing Home
    """

    PROFESSIONAL_PHYSICIAN_VISIT_SKILLED_NURSING_FACILITY = "A2"
    """
    Professional (Physician) Visit - Skilled Nursing Facility
    """

    PROFESSIONAL_PHYSICIAN_VISIT_HOME = "A3"
    """
    Professional (Physician) Visit - Home
    """

    PSYCHIATRIC = "A4"
    """
    Psychiatric
    """

    PSYCHIATRIC_ROOM_AND_BOARD = "A5"
    """
    Psychiatric - Room and Board
    """

    PSYCHOTHERAPY = "A6"
    """
    Psychotherapy
    """

    PSYCHIATRIC_INPATIENT = "A7"
    """
    Psychiatric - Inpatient
    """

    PSYCHIATRIC_OUTPATIENT = "A8"
    """
    Psychiatric - Outpatient
    """

    REHABILITATION = "A9"
    """
    Rehabilitation
    """

    REHABILITATION_ROOM_AND_BOARD = "AA"
    """
    Rehabilitation - Room and Board
    """

    REHABILITATION_INPATIENT = "AB"
    """
    Rehabilitation - Inpatient
    """

    REHABILITATION_OUTPATIENT = "AC"
    """
    Rehabilitation - Outpatient
    """

    OCCUPATIONAL_THERAPY = "AD"
    """
    Occupational Therapy
    """

    PHYSICAL_MEDICINE = "AE"
    """
    Physical Medicine
    """

    SPEECH_THERAPY = "AF"
    """
    Speech Therapy
    """

    SKILLED_NURSING_CARE = "AG"
    """
    Skilled Nursing Care
    """

    SKILLED_NURSING_CARE_ROOM_AND_BOARD = "AH"
    """
    Skilled Nursing Care - Room and Board
    """

    SUBSTANCE_ABUSE = "AI"
    """
    Substance Abuse
    """

    ALCOHOLISM = "AJ"
    """
    Alcoholism
    """

    DRUG_ADDICTION = "AK"
    """
    Drug Addiction
    """

    VISION_OPTOMETRY = "AL"
    """
    Vision (Optometry)
    """

    FRAMES = "AM"
    """
    Frames
    """

    ROUTINE_EXAM = "AN"
    """
    Routine Exam
    """

    LENSES = "AO"
    """
    Lenses
    """

    NONMEDICALLY_NECESSARY_PHYSICAL = "AQ"
    """
    Nonmedically Necessary Physical
    """

    EXPERIMENTAL_DRUG_THERAPY = "AR"
    """
    Experimental Drug Therapy
    """

    BURN_CARE = "B1"
    """
    Burn Care
    """

    BRAND_NAME_PRESCRIPTION_DRUG_FORMULARY = "B2"
    """
    Brand Name Prescription Drug - Formulary
    """

    BRAND_NAME_PRESCRIPTION_DRUG_NON_FORMULARY = "B3"
    """
    Brand Name Prescription Drug - Non-Formulary
    """

    INDEPENDENT_MEDICAL_EVALUATION = "BA"
    """
    Independent Medical Evaluation
    """

    PARTIAL_HOSPITALIZATION_PSYCHIATRIC = "BB"
    """
    Partial Hospitalization (Psychiatric)
    """

    DAY_CARE_PSYCHIATRIC = "BC"
    """
    Day Care (Psychiatric)
    """

    COGNITIVE_THERAPY = "BD"
    """
    Cognitive Therapy
    """

    MASSAGE_THERAPY = "BE"
    """
    Massage Therapy
    """

    PULMONARY_REHABILITATION = "BF"
    """
    Pulmonary Rehabilitation
    """

    CARDIAC_REHABILITATION = "BG"
    """
    Cardiac Rehabilitation
    """

    PEDIATRIC = "BH"
    """
    Pediatric
    """

    NURSERY = "BI"
    """
    Nursery
    """

    SKIN = "BJ"
    """
    Skin
    """

    ORTHOPEDIC = "BK"
    """
    Orthopedic
    """

    CARDIAC = "BL"
    """
    Cardiac
    """

    LYMPHATIC = "BM"
    """
    Lymphatic
    """

    GASTROINTESTINAL = "BN"
    """
    Gastrointestinal
    """

    ENDOCRINE = "BP"
    """
    Endocrine
    """

    NEUROLOGY = "BQ"
    """
    Neurology
    """

    EYE = "BR"
    """
    Eye
    """

    INVASIVE_PROCEDURES = "BS"
    """
    Invasive Procedures
    """

    GYNECOLOGICAL = "BT"
    """
    Gynecological
    """

    OBSTETRICAL = "BU"
    """
    Obstetrical
    """

    OBSTETRICAL_GYNECOLOGICAL = "BV"
    """
    Obstetrical/Gynecological
    """

    MAIL_ORDER_PRESCRIPTION_DRUG_BRAND_NAME = "BW"
    """
    Mail Order Prescription Drug - Brand Name
    """

    MAIL_ORDER_PRESCRIPTION_DRUG_GENERIC = "BX"
    """
    Mail Order Prescription Drug - Generic
    """

    PHYSICIAN_VISIT_OFFICE_SICK = "BY"
    """
    Physician Visit - Office - Sick
    """

    PHYSICIAN_VISIT_OFFICE_WELL = "BZ"
    """
    Physician Visit - Office - Well
    """

    CORONARY_CARE = "C1"
    """
    Coronary Care
    """

    PRIVATE_DUTY_NURSING_INPATIENT = "CA"
    """
    Private Duty Nursing - Inpatient
    """

    PRIVATE_DUTY_NURSING_HOME = "CB"
    """
    Private Duty Nursing - Home
    """

    SURGICAL_BENEFITS_PROFESSIONAL_PHYSICIAN = "CC"
    """
    Surgical Benefits - Professional (Physician)
    """

    SURGICAL_BENEFITS_FACILITY = "CD"
    """
    Surgical Benefits - Facility
    """

    MENTAL_HEALTH_PROVIDER_INPATIENT = "CE"
    """
    Mental Health Provider - Inpatient
    """

    MENTAL_HEALTH_PROVIDER_OUTPATIENT = "CF"
    """
    Mental Health Provider - Outpatient
    """

    MENTAL_HEALTH_FACILITY_INPATIENT = "CG"
    """
    Mental Health Facility - Inpatient
    """

    MENTAL_HEALTH_FACILITY_OUTPATIENT = "CH"
    """
    Mental Health Facility - Outpatient
    """

    SUBSTANCE_ABUSE_FACILITY_INPATIENT = "CI"
    """
    Substance Abuse Facility - Inpatient
    """

    SUBSTANCE_ABUSE_FACILITY_OUTPATIENT = "CJ"
    """
    Substance Abuse Facility - Outpatient
    """

    SCREENING_X_RAY = "CK"
    """
    Screening X-ray
    """

    SCREENING_LABORATORY = "CL"
    """
    Screening laboratory
    """

    MAMMOGRAM_HIGH_RISK_PATIENT = "CM"
    """
    Mammogram, High Risk Patient
    """

    MAMMOGRAM_LOW_RISK_PATIENT = "CN"
    """
    Mammogram, Low Risk Patient
    """

    FLU_VACCINATION = "CO"
    """
    Flu Vaccination
    """

    EYEWEAR_AND_EYEWEAR_ACCESSORIES = "CP"
    """
    Eyewear and Eyewear Accessories
    """

    CASE_MANAGEMENT = "CQ"
    """
    Case Management
    """

    DERMATOLOGY = "DG"
    """
    Dermatology
    """

    DURABLE_MEDICAL_EQUIPMENT = "DM"
    """
    Durable Medical Equipment
    """

    DIABETIC_SUPPLIES = "DS"
    """
    Diabetic Supplies
    """

    GENERIC_PRESCRIPTION_DRUG_FORMULARY = "GF"
    """
    Generic Prescription Drug - Formulary
    """

    GENERIC_PRESCRIPTION_DRUG_NON_FORMULARY = "GN"
    """
    Generic Prescription Drug - Non-Formulary
    """

    ALLERGY = "GY"
    """
    Allergy
    """

    INTENSIVE_CARE = "IC"
    """
    Intensive Care
    """

    MENTAL_HEALTH = "MH"
    """
    Mental Health
    """

    NEONATAL_INTENSIVE_CARE = "NI"
    """
    Neonatal Intensive Care
    """

    ONCOLOGY = "ON"
    """
    Oncology
    """

    PHYSICAL_THERAPY = "PT"
    """
    Physical Therapy
    """

    PULMONARY = "PU"
    """
    Pulmonary
    """

    RENAL = "RN"
    """
    Renal
    """

    RESIDENTIAL_PSYCHIATRIC_TREATMENT = "RT"
    """
    Residential Psychiatric Treatment
    """

    TRANSITIONAL_CARE = "TC"
    """
    Transitional Care
    """

    TRANSITIONAL_NURSERY_CARE = "TN"
    """
    Transitional Nursery Care
    """

    URGENT_CARE = "UC"
    """
    Urgent Care
    """

    _UNKNOWN = "__SERVICETYPECODE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ServiceTypeCode":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        medical_care: typing.Callable[[], T_Result],
        surgical: typing.Callable[[], T_Result],
        consultation: typing.Callable[[], T_Result],
        diagnostic_x_ray: typing.Callable[[], T_Result],
        diagnostic_lab: typing.Callable[[], T_Result],
        radiation_therapy: typing.Callable[[], T_Result],
        anesthesia: typing.Callable[[], T_Result],
        surgical_assistance: typing.Callable[[], T_Result],
        other_medical: typing.Callable[[], T_Result],
        blood_charges: typing.Callable[[], T_Result],
        used_durable_medical_equipment: typing.Callable[[], T_Result],
        durable_medical_equipment_purchase: typing.Callable[[], T_Result],
        ambulatory_surgical_center_facility: typing.Callable[[], T_Result],
        renal_supplies_in_home: typing.Callable[[], T_Result],
        alternate_method_dialysis: typing.Callable[[], T_Result],
        chronic_renal_disease_equipment: typing.Callable[[], T_Result],
        pre_admission_testing: typing.Callable[[], T_Result],
        durable_medical_equipment_rental: typing.Callable[[], T_Result],
        pneumonia_vaccine: typing.Callable[[], T_Result],
        second_surgical_opinion: typing.Callable[[], T_Result],
        third_surgical_opinion: typing.Callable[[], T_Result],
        social_work: typing.Callable[[], T_Result],
        diagnostic_dental: typing.Callable[[], T_Result],
        periodontics: typing.Callable[[], T_Result],
        restorative: typing.Callable[[], T_Result],
        endodontics: typing.Callable[[], T_Result],
        maxillofacial_prosthetics: typing.Callable[[], T_Result],
        adjunctive_dental_services: typing.Callable[[], T_Result],
        health_benefit_plan_coverage: typing.Callable[[], T_Result],
        plan_waiting_period: typing.Callable[[], T_Result],
        chiropractic: typing.Callable[[], T_Result],
        chiropractic_office_visits: typing.Callable[[], T_Result],
        dental_care: typing.Callable[[], T_Result],
        dental_crowns: typing.Callable[[], T_Result],
        dental_accident: typing.Callable[[], T_Result],
        orthodontics: typing.Callable[[], T_Result],
        prosthodontics: typing.Callable[[], T_Result],
        oral_surgery: typing.Callable[[], T_Result],
        routine_preventive_dental: typing.Callable[[], T_Result],
        home_health_care: typing.Callable[[], T_Result],
        home_health_prescriptions: typing.Callable[[], T_Result],
        home_health_visits: typing.Callable[[], T_Result],
        hospice: typing.Callable[[], T_Result],
        respite_care: typing.Callable[[], T_Result],
        hospital: typing.Callable[[], T_Result],
        hospital_inpatient: typing.Callable[[], T_Result],
        hospital_room_and_board: typing.Callable[[], T_Result],
        hospital_outpatient: typing.Callable[[], T_Result],
        hospital_emergency_accident: typing.Callable[[], T_Result],
        hospital_emergency_medical: typing.Callable[[], T_Result],
        hospital_ambulatory_surgical: typing.Callable[[], T_Result],
        long_term_care: typing.Callable[[], T_Result],
        major_medical: typing.Callable[[], T_Result],
        medically_related_transportation: typing.Callable[[], T_Result],
        air_transportation: typing.Callable[[], T_Result],
        cabulance: typing.Callable[[], T_Result],
        licensed_ambulance: typing.Callable[[], T_Result],
        general_benefits: typing.Callable[[], T_Result],
        in_vitro_fertilization: typing.Callable[[], T_Result],
        mricat_scan: typing.Callable[[], T_Result],
        donor_procedures: typing.Callable[[], T_Result],
        acupuncture: typing.Callable[[], T_Result],
        newborn_care: typing.Callable[[], T_Result],
        pathology: typing.Callable[[], T_Result],
        smoking_cessation: typing.Callable[[], T_Result],
        well_baby_care: typing.Callable[[], T_Result],
        maternity: typing.Callable[[], T_Result],
        transplants: typing.Callable[[], T_Result],
        audiology_exam: typing.Callable[[], T_Result],
        inhalation_therapy: typing.Callable[[], T_Result],
        diagnostic_medical: typing.Callable[[], T_Result],
        private_duty_nursing: typing.Callable[[], T_Result],
        prosthetic_device: typing.Callable[[], T_Result],
        dialysis: typing.Callable[[], T_Result],
        otological_exam: typing.Callable[[], T_Result],
        chemotherapy: typing.Callable[[], T_Result],
        allergy_testing: typing.Callable[[], T_Result],
        immunizations: typing.Callable[[], T_Result],
        routine_physical: typing.Callable[[], T_Result],
        family_planning: typing.Callable[[], T_Result],
        infertility: typing.Callable[[], T_Result],
        abortion: typing.Callable[[], T_Result],
        aids: typing.Callable[[], T_Result],
        emergency_services: typing.Callable[[], T_Result],
        cancer: typing.Callable[[], T_Result],
        pharmacy: typing.Callable[[], T_Result],
        free_standing_prescription_drug: typing.Callable[[], T_Result],
        mail_order_prescription_drug: typing.Callable[[], T_Result],
        brand_name_prescription_drug: typing.Callable[[], T_Result],
        generic_prescription_drug: typing.Callable[[], T_Result],
        podiatry: typing.Callable[[], T_Result],
        podiatry_office_visits: typing.Callable[[], T_Result],
        podiatry_nursing_home_visits: typing.Callable[[], T_Result],
        professional_physician: typing.Callable[[], T_Result],
        anesthesiologist: typing.Callable[[], T_Result],
        professional_physician_visit_office: typing.Callable[[], T_Result],
        professional_physician_visit_inpatient: typing.Callable[[], T_Result],
        professional_physician_visit_outpatient: typing.Callable[[], T_Result],
        professional_physician_visit_nursing_home: typing.Callable[[], T_Result],
        professional_physician_visit_skilled_nursing_facility: typing.Callable[[], T_Result],
        professional_physician_visit_home: typing.Callable[[], T_Result],
        psychiatric: typing.Callable[[], T_Result],
        psychiatric_room_and_board: typing.Callable[[], T_Result],
        psychotherapy: typing.Callable[[], T_Result],
        psychiatric_inpatient: typing.Callable[[], T_Result],
        psychiatric_outpatient: typing.Callable[[], T_Result],
        rehabilitation: typing.Callable[[], T_Result],
        rehabilitation_room_and_board: typing.Callable[[], T_Result],
        rehabilitation_inpatient: typing.Callable[[], T_Result],
        rehabilitation_outpatient: typing.Callable[[], T_Result],
        occupational_therapy: typing.Callable[[], T_Result],
        physical_medicine: typing.Callable[[], T_Result],
        speech_therapy: typing.Callable[[], T_Result],
        skilled_nursing_care: typing.Callable[[], T_Result],
        skilled_nursing_care_room_and_board: typing.Callable[[], T_Result],
        substance_abuse: typing.Callable[[], T_Result],
        alcoholism: typing.Callable[[], T_Result],
        drug_addiction: typing.Callable[[], T_Result],
        vision_optometry: typing.Callable[[], T_Result],
        frames: typing.Callable[[], T_Result],
        routine_exam: typing.Callable[[], T_Result],
        lenses: typing.Callable[[], T_Result],
        nonmedically_necessary_physical: typing.Callable[[], T_Result],
        experimental_drug_therapy: typing.Callable[[], T_Result],
        burn_care: typing.Callable[[], T_Result],
        brand_name_prescription_drug_formulary: typing.Callable[[], T_Result],
        brand_name_prescription_drug_non_formulary: typing.Callable[[], T_Result],
        independent_medical_evaluation: typing.Callable[[], T_Result],
        partial_hospitalization_psychiatric: typing.Callable[[], T_Result],
        day_care_psychiatric: typing.Callable[[], T_Result],
        cognitive_therapy: typing.Callable[[], T_Result],
        massage_therapy: typing.Callable[[], T_Result],
        pulmonary_rehabilitation: typing.Callable[[], T_Result],
        cardiac_rehabilitation: typing.Callable[[], T_Result],
        pediatric: typing.Callable[[], T_Result],
        nursery: typing.Callable[[], T_Result],
        skin: typing.Callable[[], T_Result],
        orthopedic: typing.Callable[[], T_Result],
        cardiac: typing.Callable[[], T_Result],
        lymphatic: typing.Callable[[], T_Result],
        gastrointestinal: typing.Callable[[], T_Result],
        endocrine: typing.Callable[[], T_Result],
        neurology: typing.Callable[[], T_Result],
        eye: typing.Callable[[], T_Result],
        invasive_procedures: typing.Callable[[], T_Result],
        gynecological: typing.Callable[[], T_Result],
        obstetrical: typing.Callable[[], T_Result],
        obstetrical_gynecological: typing.Callable[[], T_Result],
        mail_order_prescription_drug_brand_name: typing.Callable[[], T_Result],
        mail_order_prescription_drug_generic: typing.Callable[[], T_Result],
        physician_visit_office_sick: typing.Callable[[], T_Result],
        physician_visit_office_well: typing.Callable[[], T_Result],
        coronary_care: typing.Callable[[], T_Result],
        private_duty_nursing_inpatient: typing.Callable[[], T_Result],
        private_duty_nursing_home: typing.Callable[[], T_Result],
        surgical_benefits_professional_physician: typing.Callable[[], T_Result],
        surgical_benefits_facility: typing.Callable[[], T_Result],
        mental_health_provider_inpatient: typing.Callable[[], T_Result],
        mental_health_provider_outpatient: typing.Callable[[], T_Result],
        mental_health_facility_inpatient: typing.Callable[[], T_Result],
        mental_health_facility_outpatient: typing.Callable[[], T_Result],
        substance_abuse_facility_inpatient: typing.Callable[[], T_Result],
        substance_abuse_facility_outpatient: typing.Callable[[], T_Result],
        screening_x_ray: typing.Callable[[], T_Result],
        screening_laboratory: typing.Callable[[], T_Result],
        mammogram_high_risk_patient: typing.Callable[[], T_Result],
        mammogram_low_risk_patient: typing.Callable[[], T_Result],
        flu_vaccination: typing.Callable[[], T_Result],
        eyewear_and_eyewear_accessories: typing.Callable[[], T_Result],
        case_management: typing.Callable[[], T_Result],
        dermatology: typing.Callable[[], T_Result],
        durable_medical_equipment: typing.Callable[[], T_Result],
        diabetic_supplies: typing.Callable[[], T_Result],
        generic_prescription_drug_formulary: typing.Callable[[], T_Result],
        generic_prescription_drug_non_formulary: typing.Callable[[], T_Result],
        allergy: typing.Callable[[], T_Result],
        intensive_care: typing.Callable[[], T_Result],
        mental_health: typing.Callable[[], T_Result],
        neonatal_intensive_care: typing.Callable[[], T_Result],
        oncology: typing.Callable[[], T_Result],
        physical_therapy: typing.Callable[[], T_Result],
        pulmonary: typing.Callable[[], T_Result],
        renal: typing.Callable[[], T_Result],
        residential_psychiatric_treatment: typing.Callable[[], T_Result],
        transitional_care: typing.Callable[[], T_Result],
        transitional_nursery_care: typing.Callable[[], T_Result],
        urgent_care: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ServiceTypeCode.MEDICAL_CARE:
            return medical_care()
        if self is ServiceTypeCode.SURGICAL:
            return surgical()
        if self is ServiceTypeCode.CONSULTATION:
            return consultation()
        if self is ServiceTypeCode.DIAGNOSTIC_X_RAY:
            return diagnostic_x_ray()
        if self is ServiceTypeCode.DIAGNOSTIC_LAB:
            return diagnostic_lab()
        if self is ServiceTypeCode.RADIATION_THERAPY:
            return radiation_therapy()
        if self is ServiceTypeCode.ANESTHESIA:
            return anesthesia()
        if self is ServiceTypeCode.SURGICAL_ASSISTANCE:
            return surgical_assistance()
        if self is ServiceTypeCode.OTHER_MEDICAL:
            return other_medical()
        if self is ServiceTypeCode.BLOOD_CHARGES:
            return blood_charges()
        if self is ServiceTypeCode.USED_DURABLE_MEDICAL_EQUIPMENT:
            return used_durable_medical_equipment()
        if self is ServiceTypeCode.DURABLE_MEDICAL_EQUIPMENT_PURCHASE:
            return durable_medical_equipment_purchase()
        if self is ServiceTypeCode.AMBULATORY_SURGICAL_CENTER_FACILITY:
            return ambulatory_surgical_center_facility()
        if self is ServiceTypeCode.RENAL_SUPPLIES_IN_HOME:
            return renal_supplies_in_home()
        if self is ServiceTypeCode.ALTERNATE_METHOD_DIALYSIS:
            return alternate_method_dialysis()
        if self is ServiceTypeCode.CHRONIC_RENAL_DISEASE_EQUIPMENT:
            return chronic_renal_disease_equipment()
        if self is ServiceTypeCode.PRE_ADMISSION_TESTING:
            return pre_admission_testing()
        if self is ServiceTypeCode.DURABLE_MEDICAL_EQUIPMENT_RENTAL:
            return durable_medical_equipment_rental()
        if self is ServiceTypeCode.PNEUMONIA_VACCINE:
            return pneumonia_vaccine()
        if self is ServiceTypeCode.SECOND_SURGICAL_OPINION:
            return second_surgical_opinion()
        if self is ServiceTypeCode.THIRD_SURGICAL_OPINION:
            return third_surgical_opinion()
        if self is ServiceTypeCode.SOCIAL_WORK:
            return social_work()
        if self is ServiceTypeCode.DIAGNOSTIC_DENTAL:
            return diagnostic_dental()
        if self is ServiceTypeCode.PERIODONTICS:
            return periodontics()
        if self is ServiceTypeCode.RESTORATIVE:
            return restorative()
        if self is ServiceTypeCode.ENDODONTICS:
            return endodontics()
        if self is ServiceTypeCode.MAXILLOFACIAL_PROSTHETICS:
            return maxillofacial_prosthetics()
        if self is ServiceTypeCode.ADJUNCTIVE_DENTAL_SERVICES:
            return adjunctive_dental_services()
        if self is ServiceTypeCode.HEALTH_BENEFIT_PLAN_COVERAGE:
            return health_benefit_plan_coverage()
        if self is ServiceTypeCode.PLAN_WAITING_PERIOD:
            return plan_waiting_period()
        if self is ServiceTypeCode.CHIROPRACTIC:
            return chiropractic()
        if self is ServiceTypeCode.CHIROPRACTIC_OFFICE_VISITS:
            return chiropractic_office_visits()
        if self is ServiceTypeCode.DENTAL_CARE:
            return dental_care()
        if self is ServiceTypeCode.DENTAL_CROWNS:
            return dental_crowns()
        if self is ServiceTypeCode.DENTAL_ACCIDENT:
            return dental_accident()
        if self is ServiceTypeCode.ORTHODONTICS:
            return orthodontics()
        if self is ServiceTypeCode.PROSTHODONTICS:
            return prosthodontics()
        if self is ServiceTypeCode.ORAL_SURGERY:
            return oral_surgery()
        if self is ServiceTypeCode.ROUTINE_PREVENTIVE_DENTAL:
            return routine_preventive_dental()
        if self is ServiceTypeCode.HOME_HEALTH_CARE:
            return home_health_care()
        if self is ServiceTypeCode.HOME_HEALTH_PRESCRIPTIONS:
            return home_health_prescriptions()
        if self is ServiceTypeCode.HOME_HEALTH_VISITS:
            return home_health_visits()
        if self is ServiceTypeCode.HOSPICE:
            return hospice()
        if self is ServiceTypeCode.RESPITE_CARE:
            return respite_care()
        if self is ServiceTypeCode.HOSPITAL:
            return hospital()
        if self is ServiceTypeCode.HOSPITAL_INPATIENT:
            return hospital_inpatient()
        if self is ServiceTypeCode.HOSPITAL_ROOM_AND_BOARD:
            return hospital_room_and_board()
        if self is ServiceTypeCode.HOSPITAL_OUTPATIENT:
            return hospital_outpatient()
        if self is ServiceTypeCode.HOSPITAL_EMERGENCY_ACCIDENT:
            return hospital_emergency_accident()
        if self is ServiceTypeCode.HOSPITAL_EMERGENCY_MEDICAL:
            return hospital_emergency_medical()
        if self is ServiceTypeCode.HOSPITAL_AMBULATORY_SURGICAL:
            return hospital_ambulatory_surgical()
        if self is ServiceTypeCode.LONG_TERM_CARE:
            return long_term_care()
        if self is ServiceTypeCode.MAJOR_MEDICAL:
            return major_medical()
        if self is ServiceTypeCode.MEDICALLY_RELATED_TRANSPORTATION:
            return medically_related_transportation()
        if self is ServiceTypeCode.AIR_TRANSPORTATION:
            return air_transportation()
        if self is ServiceTypeCode.CABULANCE:
            return cabulance()
        if self is ServiceTypeCode.LICENSED_AMBULANCE:
            return licensed_ambulance()
        if self is ServiceTypeCode.GENERAL_BENEFITS:
            return general_benefits()
        if self is ServiceTypeCode.IN_VITRO_FERTILIZATION:
            return in_vitro_fertilization()
        if self is ServiceTypeCode.MRICAT_SCAN:
            return mricat_scan()
        if self is ServiceTypeCode.DONOR_PROCEDURES:
            return donor_procedures()
        if self is ServiceTypeCode.ACUPUNCTURE:
            return acupuncture()
        if self is ServiceTypeCode.NEWBORN_CARE:
            return newborn_care()
        if self is ServiceTypeCode.PATHOLOGY:
            return pathology()
        if self is ServiceTypeCode.SMOKING_CESSATION:
            return smoking_cessation()
        if self is ServiceTypeCode.WELL_BABY_CARE:
            return well_baby_care()
        if self is ServiceTypeCode.MATERNITY:
            return maternity()
        if self is ServiceTypeCode.TRANSPLANTS:
            return transplants()
        if self is ServiceTypeCode.AUDIOLOGY_EXAM:
            return audiology_exam()
        if self is ServiceTypeCode.INHALATION_THERAPY:
            return inhalation_therapy()
        if self is ServiceTypeCode.DIAGNOSTIC_MEDICAL:
            return diagnostic_medical()
        if self is ServiceTypeCode.PRIVATE_DUTY_NURSING:
            return private_duty_nursing()
        if self is ServiceTypeCode.PROSTHETIC_DEVICE:
            return prosthetic_device()
        if self is ServiceTypeCode.DIALYSIS:
            return dialysis()
        if self is ServiceTypeCode.OTOLOGICAL_EXAM:
            return otological_exam()
        if self is ServiceTypeCode.CHEMOTHERAPY:
            return chemotherapy()
        if self is ServiceTypeCode.ALLERGY_TESTING:
            return allergy_testing()
        if self is ServiceTypeCode.IMMUNIZATIONS:
            return immunizations()
        if self is ServiceTypeCode.ROUTINE_PHYSICAL:
            return routine_physical()
        if self is ServiceTypeCode.FAMILY_PLANNING:
            return family_planning()
        if self is ServiceTypeCode.INFERTILITY:
            return infertility()
        if self is ServiceTypeCode.ABORTION:
            return abortion()
        if self is ServiceTypeCode.AIDS:
            return aids()
        if self is ServiceTypeCode.EMERGENCY_SERVICES:
            return emergency_services()
        if self is ServiceTypeCode.CANCER:
            return cancer()
        if self is ServiceTypeCode.PHARMACY:
            return pharmacy()
        if self is ServiceTypeCode.FREE_STANDING_PRESCRIPTION_DRUG:
            return free_standing_prescription_drug()
        if self is ServiceTypeCode.MAIL_ORDER_PRESCRIPTION_DRUG:
            return mail_order_prescription_drug()
        if self is ServiceTypeCode.BRAND_NAME_PRESCRIPTION_DRUG:
            return brand_name_prescription_drug()
        if self is ServiceTypeCode.GENERIC_PRESCRIPTION_DRUG:
            return generic_prescription_drug()
        if self is ServiceTypeCode.PODIATRY:
            return podiatry()
        if self is ServiceTypeCode.PODIATRY_OFFICE_VISITS:
            return podiatry_office_visits()
        if self is ServiceTypeCode.PODIATRY_NURSING_HOME_VISITS:
            return podiatry_nursing_home_visits()
        if self is ServiceTypeCode.PROFESSIONAL_PHYSICIAN:
            return professional_physician()
        if self is ServiceTypeCode.ANESTHESIOLOGIST:
            return anesthesiologist()
        if self is ServiceTypeCode.PROFESSIONAL_PHYSICIAN_VISIT_OFFICE:
            return professional_physician_visit_office()
        if self is ServiceTypeCode.PROFESSIONAL_PHYSICIAN_VISIT_INPATIENT:
            return professional_physician_visit_inpatient()
        if self is ServiceTypeCode.PROFESSIONAL_PHYSICIAN_VISIT_OUTPATIENT:
            return professional_physician_visit_outpatient()
        if self is ServiceTypeCode.PROFESSIONAL_PHYSICIAN_VISIT_NURSING_HOME:
            return professional_physician_visit_nursing_home()
        if self is ServiceTypeCode.PROFESSIONAL_PHYSICIAN_VISIT_SKILLED_NURSING_FACILITY:
            return professional_physician_visit_skilled_nursing_facility()
        if self is ServiceTypeCode.PROFESSIONAL_PHYSICIAN_VISIT_HOME:
            return professional_physician_visit_home()
        if self is ServiceTypeCode.PSYCHIATRIC:
            return psychiatric()
        if self is ServiceTypeCode.PSYCHIATRIC_ROOM_AND_BOARD:
            return psychiatric_room_and_board()
        if self is ServiceTypeCode.PSYCHOTHERAPY:
            return psychotherapy()
        if self is ServiceTypeCode.PSYCHIATRIC_INPATIENT:
            return psychiatric_inpatient()
        if self is ServiceTypeCode.PSYCHIATRIC_OUTPATIENT:
            return psychiatric_outpatient()
        if self is ServiceTypeCode.REHABILITATION:
            return rehabilitation()
        if self is ServiceTypeCode.REHABILITATION_ROOM_AND_BOARD:
            return rehabilitation_room_and_board()
        if self is ServiceTypeCode.REHABILITATION_INPATIENT:
            return rehabilitation_inpatient()
        if self is ServiceTypeCode.REHABILITATION_OUTPATIENT:
            return rehabilitation_outpatient()
        if self is ServiceTypeCode.OCCUPATIONAL_THERAPY:
            return occupational_therapy()
        if self is ServiceTypeCode.PHYSICAL_MEDICINE:
            return physical_medicine()
        if self is ServiceTypeCode.SPEECH_THERAPY:
            return speech_therapy()
        if self is ServiceTypeCode.SKILLED_NURSING_CARE:
            return skilled_nursing_care()
        if self is ServiceTypeCode.SKILLED_NURSING_CARE_ROOM_AND_BOARD:
            return skilled_nursing_care_room_and_board()
        if self is ServiceTypeCode.SUBSTANCE_ABUSE:
            return substance_abuse()
        if self is ServiceTypeCode.ALCOHOLISM:
            return alcoholism()
        if self is ServiceTypeCode.DRUG_ADDICTION:
            return drug_addiction()
        if self is ServiceTypeCode.VISION_OPTOMETRY:
            return vision_optometry()
        if self is ServiceTypeCode.FRAMES:
            return frames()
        if self is ServiceTypeCode.ROUTINE_EXAM:
            return routine_exam()
        if self is ServiceTypeCode.LENSES:
            return lenses()
        if self is ServiceTypeCode.NONMEDICALLY_NECESSARY_PHYSICAL:
            return nonmedically_necessary_physical()
        if self is ServiceTypeCode.EXPERIMENTAL_DRUG_THERAPY:
            return experimental_drug_therapy()
        if self is ServiceTypeCode.BURN_CARE:
            return burn_care()
        if self is ServiceTypeCode.BRAND_NAME_PRESCRIPTION_DRUG_FORMULARY:
            return brand_name_prescription_drug_formulary()
        if self is ServiceTypeCode.BRAND_NAME_PRESCRIPTION_DRUG_NON_FORMULARY:
            return brand_name_prescription_drug_non_formulary()
        if self is ServiceTypeCode.INDEPENDENT_MEDICAL_EVALUATION:
            return independent_medical_evaluation()
        if self is ServiceTypeCode.PARTIAL_HOSPITALIZATION_PSYCHIATRIC:
            return partial_hospitalization_psychiatric()
        if self is ServiceTypeCode.DAY_CARE_PSYCHIATRIC:
            return day_care_psychiatric()
        if self is ServiceTypeCode.COGNITIVE_THERAPY:
            return cognitive_therapy()
        if self is ServiceTypeCode.MASSAGE_THERAPY:
            return massage_therapy()
        if self is ServiceTypeCode.PULMONARY_REHABILITATION:
            return pulmonary_rehabilitation()
        if self is ServiceTypeCode.CARDIAC_REHABILITATION:
            return cardiac_rehabilitation()
        if self is ServiceTypeCode.PEDIATRIC:
            return pediatric()
        if self is ServiceTypeCode.NURSERY:
            return nursery()
        if self is ServiceTypeCode.SKIN:
            return skin()
        if self is ServiceTypeCode.ORTHOPEDIC:
            return orthopedic()
        if self is ServiceTypeCode.CARDIAC:
            return cardiac()
        if self is ServiceTypeCode.LYMPHATIC:
            return lymphatic()
        if self is ServiceTypeCode.GASTROINTESTINAL:
            return gastrointestinal()
        if self is ServiceTypeCode.ENDOCRINE:
            return endocrine()
        if self is ServiceTypeCode.NEUROLOGY:
            return neurology()
        if self is ServiceTypeCode.EYE:
            return eye()
        if self is ServiceTypeCode.INVASIVE_PROCEDURES:
            return invasive_procedures()
        if self is ServiceTypeCode.GYNECOLOGICAL:
            return gynecological()
        if self is ServiceTypeCode.OBSTETRICAL:
            return obstetrical()
        if self is ServiceTypeCode.OBSTETRICAL_GYNECOLOGICAL:
            return obstetrical_gynecological()
        if self is ServiceTypeCode.MAIL_ORDER_PRESCRIPTION_DRUG_BRAND_NAME:
            return mail_order_prescription_drug_brand_name()
        if self is ServiceTypeCode.MAIL_ORDER_PRESCRIPTION_DRUG_GENERIC:
            return mail_order_prescription_drug_generic()
        if self is ServiceTypeCode.PHYSICIAN_VISIT_OFFICE_SICK:
            return physician_visit_office_sick()
        if self is ServiceTypeCode.PHYSICIAN_VISIT_OFFICE_WELL:
            return physician_visit_office_well()
        if self is ServiceTypeCode.CORONARY_CARE:
            return coronary_care()
        if self is ServiceTypeCode.PRIVATE_DUTY_NURSING_INPATIENT:
            return private_duty_nursing_inpatient()
        if self is ServiceTypeCode.PRIVATE_DUTY_NURSING_HOME:
            return private_duty_nursing_home()
        if self is ServiceTypeCode.SURGICAL_BENEFITS_PROFESSIONAL_PHYSICIAN:
            return surgical_benefits_professional_physician()
        if self is ServiceTypeCode.SURGICAL_BENEFITS_FACILITY:
            return surgical_benefits_facility()
        if self is ServiceTypeCode.MENTAL_HEALTH_PROVIDER_INPATIENT:
            return mental_health_provider_inpatient()
        if self is ServiceTypeCode.MENTAL_HEALTH_PROVIDER_OUTPATIENT:
            return mental_health_provider_outpatient()
        if self is ServiceTypeCode.MENTAL_HEALTH_FACILITY_INPATIENT:
            return mental_health_facility_inpatient()
        if self is ServiceTypeCode.MENTAL_HEALTH_FACILITY_OUTPATIENT:
            return mental_health_facility_outpatient()
        if self is ServiceTypeCode.SUBSTANCE_ABUSE_FACILITY_INPATIENT:
            return substance_abuse_facility_inpatient()
        if self is ServiceTypeCode.SUBSTANCE_ABUSE_FACILITY_OUTPATIENT:
            return substance_abuse_facility_outpatient()
        if self is ServiceTypeCode.SCREENING_X_RAY:
            return screening_x_ray()
        if self is ServiceTypeCode.SCREENING_LABORATORY:
            return screening_laboratory()
        if self is ServiceTypeCode.MAMMOGRAM_HIGH_RISK_PATIENT:
            return mammogram_high_risk_patient()
        if self is ServiceTypeCode.MAMMOGRAM_LOW_RISK_PATIENT:
            return mammogram_low_risk_patient()
        if self is ServiceTypeCode.FLU_VACCINATION:
            return flu_vaccination()
        if self is ServiceTypeCode.EYEWEAR_AND_EYEWEAR_ACCESSORIES:
            return eyewear_and_eyewear_accessories()
        if self is ServiceTypeCode.CASE_MANAGEMENT:
            return case_management()
        if self is ServiceTypeCode.DERMATOLOGY:
            return dermatology()
        if self is ServiceTypeCode.DURABLE_MEDICAL_EQUIPMENT:
            return durable_medical_equipment()
        if self is ServiceTypeCode.DIABETIC_SUPPLIES:
            return diabetic_supplies()
        if self is ServiceTypeCode.GENERIC_PRESCRIPTION_DRUG_FORMULARY:
            return generic_prescription_drug_formulary()
        if self is ServiceTypeCode.GENERIC_PRESCRIPTION_DRUG_NON_FORMULARY:
            return generic_prescription_drug_non_formulary()
        if self is ServiceTypeCode.ALLERGY:
            return allergy()
        if self is ServiceTypeCode.INTENSIVE_CARE:
            return intensive_care()
        if self is ServiceTypeCode.MENTAL_HEALTH:
            return mental_health()
        if self is ServiceTypeCode.NEONATAL_INTENSIVE_CARE:
            return neonatal_intensive_care()
        if self is ServiceTypeCode.ONCOLOGY:
            return oncology()
        if self is ServiceTypeCode.PHYSICAL_THERAPY:
            return physical_therapy()
        if self is ServiceTypeCode.PULMONARY:
            return pulmonary()
        if self is ServiceTypeCode.RENAL:
            return renal()
        if self is ServiceTypeCode.RESIDENTIAL_PSYCHIATRIC_TREATMENT:
            return residential_psychiatric_treatment()
        if self is ServiceTypeCode.TRANSITIONAL_CARE:
            return transitional_care()
        if self is ServiceTypeCode.TRANSITIONAL_NURSERY_CARE:
            return transitional_nursery_care()
        if self is ServiceTypeCode.URGENT_CARE:
            return urgent_care()
        return _unknown_member(self._value_)
