# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .......core.api_error import ApiError
from .......core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .......core.http_response import AsyncHttpResponse, HttpResponse
from .......core.jsonable_encoder import jsonable_encoder
from .......core.pydantic_utilities import parse_obj_as
from .......core.request_options import RequestOptions
from .types.batch_eligibility_response import BatchEligibilityResponse
from .types.eligibility_check_page import EligibilityCheckPage
from .types.eligibility_request import EligibilityRequest
from .types.eligibility_response import EligibilityResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def post(
        self, *, request: EligibilityRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[EligibilityResponse]:
        """
        Sends real-time eligibility checks to payers through Stedi.
        <Warning>Please only send one concurrent request to this endpoint. Batch requests must be made in succession, otherwise, it will cause this service to fail. A batch endpoint is in development - please reach out to the Candid team for more information.</Warning>

        Parameters
        ----------
        request : EligibilityRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EligibilityResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "eligibility-checks/v1",
            base_url=self._client_wrapper.get_environment().pre_encounter,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EligibilityResponse,
                parse_obj_as(
                    type_=EligibilityResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def batch(
        self, *, request: typing.Sequence[EligibilityRequest], request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[BatchEligibilityResponse]:
        """
        Sends a batch of eligibility checks to payers through Stedi.

        Parameters
        ----------
        request : typing.Sequence[EligibilityRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BatchEligibilityResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "eligibility-checks/v1/batch",
            base_url=self._client_wrapper.get_environment().pre_encounter,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                BatchEligibilityResponse,
                parse_obj_as(
                    type_=BatchEligibilityResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def poll_batch(
        self, batch_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[EligibilityCheckPage]:
        """
        Polls the status of a batch eligibility check.
        <Note>Batch eligibility checks are not yet available. Please reach out to the Candid team for more information.</Note>
        path-parameters:

        Parameters
        ----------
        batch_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EligibilityCheckPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"eligibility-checks/v1/batch/{jsonable_encoder(batch_id)}",
            base_url=self._client_wrapper.get_environment().pre_encounter,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EligibilityCheckPage,
                parse_obj_as(
                    type_=EligibilityCheckPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def post(
        self, *, request: EligibilityRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[EligibilityResponse]:
        """
        Sends real-time eligibility checks to payers through Stedi.
        <Warning>Please only send one concurrent request to this endpoint. Batch requests must be made in succession, otherwise, it will cause this service to fail. A batch endpoint is in development - please reach out to the Candid team for more information.</Warning>

        Parameters
        ----------
        request : EligibilityRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EligibilityResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "eligibility-checks/v1",
            base_url=self._client_wrapper.get_environment().pre_encounter,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EligibilityResponse,
                parse_obj_as(
                    type_=EligibilityResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def batch(
        self, *, request: typing.Sequence[EligibilityRequest], request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[BatchEligibilityResponse]:
        """
        Sends a batch of eligibility checks to payers through Stedi.

        Parameters
        ----------
        request : typing.Sequence[EligibilityRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BatchEligibilityResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "eligibility-checks/v1/batch",
            base_url=self._client_wrapper.get_environment().pre_encounter,
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                BatchEligibilityResponse,
                parse_obj_as(
                    type_=BatchEligibilityResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def poll_batch(
        self, batch_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[EligibilityCheckPage]:
        """
        Polls the status of a batch eligibility check.
        <Note>Batch eligibility checks are not yet available. Please reach out to the Candid team for more information.</Note>
        path-parameters:

        Parameters
        ----------
        batch_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EligibilityCheckPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"eligibility-checks/v1/batch/{jsonable_encoder(batch_id)}",
            base_url=self._client_wrapper.get_environment().pre_encounter,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EligibilityCheckPage,
                parse_obj_as(
                    type_=EligibilityCheckPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
