# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ........core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....coverages.resources.v_1.types.member_info import MemberInfo
from .encounter import Encounter
from .provider import Provider


class EligibilityRequest(UniversalBaseModel):
    """
    An object representing the data for an eligibility request.
    """

    submitter_transaction_identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for the eligibility check within the batch. Candid returns this identifier in the response for the 
    /batch/{batch_id} polling endpoint so you can correlate benefit responses with the original eligibility check.
    """

    payer_id: str = pydantic.Field()
    """
    Supported payer ID values can be found [here](https://www.stedi.com/healthcare/network).
    """

    provider: Provider
    subscriber: MemberInfo = pydantic.Field()
    """
    The primary policyholder for the insurance plan or a dependent with a unique member ID. <Note>If a dependent has a unique member ID, include their information here and leave dependent undefined.</Note>
    """

    dependent: typing.Optional[MemberInfo] = pydantic.Field(default=None)
    """
    <Note>If a dependent has a unique member ID, include their information as subscriber and leave this field undefined.</Note>
    """

    encounter: typing.Optional[Encounter] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
