# This file was auto-generated by Fern from our API Definition.

import typing

from .......core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .......core.request_options import RequestOptions
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.image import Image
from .types.image_id import ImageId
from .types.mutable_image import MutableImage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def create(self, *, request: MutableImage, request_options: typing.Optional[RequestOptions] = None) -> Image:
        """
        Adds an image.  VersionConflictError is returned if a front or back of this coverage already exists.

        Parameters
        ----------
        request : MutableImage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Image

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.images.resources.v_1 import (
            ImageStatus,
            MutableImage,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.images.v_1.create(
            request=MutableImage(
                file_name="file_name",
                display_name="display_name",
                file_type="file_type",
                status=ImageStatus.PENDING,
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def get(self, id: ImageId, *, request_options: typing.Optional[RequestOptions] = None) -> Image:
        """
        Gets an image by imageId.

        Parameters
        ----------
        id : ImageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Image

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.images.v_1.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: ImageId,
        version: str,
        *,
        request: MutableImage,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Image:
        """
        Updates an Image.  The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : ImageId

        version : str

        request : MutableImage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Image

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.images.resources.v_1 import (
            ImageStatus,
            MutableImage,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.images.v_1.update(
            id="id",
            version="version",
            request=MutableImage(
                file_name="file_name",
                display_name="display_name",
                file_type="file_type",
                status=ImageStatus.PENDING,
            ),
        )
        """
        _response = self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    def deactivate(self, id: ImageId, version: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Sets an Image as deactivated.  The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : ImageId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.images.v_1.deactivate(
            id="id",
            version="version",
        )
        """
        _response = self._raw_client.deactivate(id, version, request_options=request_options)
        return _response.data

    def get_multi(
        self,
        *,
        patient_id: typing.Optional[str] = None,
        coverage_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Image]:
        """
        Searches for images that match the query parameters.

        Parameters
        ----------
        patient_id : typing.Optional[str]

        coverage_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Image]

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.images.v_1.get_multi()
        """
        _response = self._raw_client.get_multi(
            patient_id=patient_id, coverage_id=coverage_id, request_options=request_options
        )
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def create(self, *, request: MutableImage, request_options: typing.Optional[RequestOptions] = None) -> Image:
        """
        Adds an image.  VersionConflictError is returned if a front or back of this coverage already exists.

        Parameters
        ----------
        request : MutableImage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Image

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.images.resources.v_1 import (
            ImageStatus,
            MutableImage,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.images.v_1.create(
                request=MutableImage(
                    file_name="file_name",
                    display_name="display_name",
                    file_type="file_type",
                    status=ImageStatus.PENDING,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def get(self, id: ImageId, *, request_options: typing.Optional[RequestOptions] = None) -> Image:
        """
        Gets an image by imageId.

        Parameters
        ----------
        id : ImageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Image

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.images.v_1.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: ImageId,
        version: str,
        *,
        request: MutableImage,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Image:
        """
        Updates an Image.  The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : ImageId

        version : str

        request : MutableImage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Image

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.images.resources.v_1 import (
            ImageStatus,
            MutableImage,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.images.v_1.update(
                id="id",
                version="version",
                request=MutableImage(
                    file_name="file_name",
                    display_name="display_name",
                    file_type="file_type",
                    status=ImageStatus.PENDING,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    async def deactivate(
        self, id: ImageId, version: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Sets an Image as deactivated.  The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : ImageId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.images.v_1.deactivate(
                id="id",
                version="version",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deactivate(id, version, request_options=request_options)
        return _response.data

    async def get_multi(
        self,
        *,
        patient_id: typing.Optional[str] = None,
        coverage_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Image]:
        """
        Searches for images that match the query parameters.

        Parameters
        ----------
        patient_id : typing.Optional[str]

        coverage_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Image]

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.images.v_1.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            patient_id=patient_id, coverage_id=coverage_id, request_options=request_options
        )
        return _response.data
