# This file was auto-generated by Fern from our API Definition.

import typing

from .......core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .......core.request_options import RequestOptions
from ....common.types.note_id import NoteId
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.mutable_note import MutableNote
from .types.note import Note

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def get(self, id: NoteId, *, request_options: typing.Optional[RequestOptions] = None) -> Note:
        """
        Gets a note by NoteId.

        Parameters
        ----------
        id : NoteId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.notes.v_1.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def create(self, *, request: MutableNote, request_options: typing.Optional[RequestOptions] = None) -> Note:
        """
        Adds a new note.

        Parameters
        ----------
        request : MutableNote

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.notes.resources.v_1 import (
            MutableNote,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.notes.v_1.create(
            request=MutableNote(
                value="value",
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self, id: NoteId, version: str, *, request: MutableNote, request_options: typing.Optional[RequestOptions] = None
    ) -> Note:
        """
        Updates a note. The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : NoteId

        version : str

        request : MutableNote

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.notes.resources.v_1 import (
            MutableNote,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.notes.v_1.update(
            id="id",
            version="version",
            request=MutableNote(
                value="value",
            ),
        )
        """
        _response = self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    def deactivate(self, id: NoteId, version: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Sets a note as deactivated.  The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : NoteId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.notes.v_1.deactivate(
            id="id",
            version="version",
        )
        """
        _response = self._raw_client.deactivate(id, version, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def get(self, id: NoteId, *, request_options: typing.Optional[RequestOptions] = None) -> Note:
        """
        Gets a note by NoteId.

        Parameters
        ----------
        id : NoteId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.notes.v_1.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def create(self, *, request: MutableNote, request_options: typing.Optional[RequestOptions] = None) -> Note:
        """
        Adds a new note.

        Parameters
        ----------
        request : MutableNote

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.notes.resources.v_1 import (
            MutableNote,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.notes.v_1.create(
                request=MutableNote(
                    value="value",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self, id: NoteId, version: str, *, request: MutableNote, request_options: typing.Optional[RequestOptions] = None
    ) -> Note:
        """
        Updates a note. The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : NoteId

        version : str

        request : MutableNote

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.notes.resources.v_1 import (
            MutableNote,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.notes.v_1.update(
                id="id",
                version="version",
                request=MutableNote(
                    value="value",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    async def deactivate(
        self, id: NoteId, version: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Sets a note as deactivated.  The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : NoteId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.notes.v_1.deactivate(
                id="id",
                version="version",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deactivate(id, version, request_options=request_options)
        return _response.data
