# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .......core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .......core.request_options import RequestOptions
from ....common.types.external_provider import ExternalProvider
from ....common.types.page_token import PageToken
from ....common.types.patient_id import PatientId
from ....common.types.sort_direction import SortDirection
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.mutable_patient import MutablePatient
from .types.mutable_patient_with_mrn import MutablePatientWithMrn
from .types.patient import Patient
from .types.patient_page import PatientPage
from .types.patient_sort_field import PatientSortField

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def create(
        self,
        *,
        request: MutablePatient,
        skip_duplicate_check: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Adds a patient.  VersionConflictError is returned when the patient's external ID is already in use.

        Parameters
        ----------
        request : MutablePatient

        skip_duplicate_check : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import datetime
        import uuid

        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            Address,
            AddressUse,
            ContactPoint,
            ContactPointUse,
            ExternalProvider,
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.patients.resources.v_1 import (
            Contact,
            FilingOrder,
            MutablePatient,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.create(
            request=MutablePatient(
                name=HumanName(
                    family="family",
                    given=["given", "given"],
                    use=NameUse.USUAL,
                ),
                other_names=[
                    HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                    HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                ],
                birth_date=datetime.date.fromisoformat(
                    "2023-01-15",
                ),
                biological_sex=Sex.FEMALE,
                primary_address=Address(
                    use=AddressUse.HOME,
                    line=["line", "line"],
                    city="city",
                    state="state",
                    postal_code="postal_code",
                    country="country",
                ),
                other_addresses=[
                    Address(
                        use=AddressUse.HOME,
                        line=["line", "line"],
                        city="city",
                        state="state",
                        postal_code="postal_code",
                        country="country",
                    ),
                    Address(
                        use=AddressUse.HOME,
                        line=["line", "line"],
                        city="city",
                        state="state",
                        postal_code="postal_code",
                        country="country",
                    ),
                ],
                primary_telecom=ContactPoint(
                    value="value",
                    use=ContactPointUse.HOME,
                ),
                other_telecoms=[
                    ContactPoint(
                        value="value",
                        use=ContactPointUse.HOME,
                    ),
                    ContactPoint(
                        value="value",
                        use=ContactPointUse.HOME,
                    ),
                ],
                contacts=[
                    Contact(
                        relationship=[Relationship.SELF, Relationship.SELF],
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                        addresses=[
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                        ],
                    ),
                    Contact(
                        relationship=[Relationship.SELF, Relationship.SELF],
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                        addresses=[
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                        ],
                    ),
                ],
                general_practitioners=[
                    ExternalProvider(
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                    ),
                    ExternalProvider(
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                    ),
                ],
                filing_order=FilingOrder(
                    coverages=[
                        uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                        uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                    ],
                ),
            ),
        )
        """
        _response = self._raw_client.create(
            request=request, skip_duplicate_check=skip_duplicate_check, request_options=request_options
        )
        return _response.data

    def create_with_mrn(
        self,
        *,
        request: MutablePatientWithMrn,
        skip_duplicate_check: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Adds a patient and hydrates their MRN with a pre-existing MRN.  Once this patient is created their MRN will not be editable. BadRequestError is returned when the MRN is greater than 20 characters. VersionConflictError is returned when the patient's external ID is already in use.

        Parameters
        ----------
        request : MutablePatientWithMrn

        skip_duplicate_check : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import datetime
        import uuid

        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            Address,
            AddressUse,
            ContactPoint,
            ContactPointUse,
            ExternalProvider,
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.patients.resources.v_1 import (
            Contact,
            FilingOrder,
            MutablePatientWithMrn,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.create_with_mrn(
            request=MutablePatientWithMrn(
                name=HumanName(
                    family="family",
                    given=["given", "given"],
                    use=NameUse.USUAL,
                ),
                other_names=[
                    HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                    HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                ],
                birth_date=datetime.date.fromisoformat(
                    "2023-01-15",
                ),
                biological_sex=Sex.FEMALE,
                primary_address=Address(
                    use=AddressUse.HOME,
                    line=["line", "line"],
                    city="city",
                    state="state",
                    postal_code="postal_code",
                    country="country",
                ),
                other_addresses=[
                    Address(
                        use=AddressUse.HOME,
                        line=["line", "line"],
                        city="city",
                        state="state",
                        postal_code="postal_code",
                        country="country",
                    ),
                    Address(
                        use=AddressUse.HOME,
                        line=["line", "line"],
                        city="city",
                        state="state",
                        postal_code="postal_code",
                        country="country",
                    ),
                ],
                primary_telecom=ContactPoint(
                    value="value",
                    use=ContactPointUse.HOME,
                ),
                other_telecoms=[
                    ContactPoint(
                        value="value",
                        use=ContactPointUse.HOME,
                    ),
                    ContactPoint(
                        value="value",
                        use=ContactPointUse.HOME,
                    ),
                ],
                contacts=[
                    Contact(
                        relationship=[Relationship.SELF, Relationship.SELF],
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                        addresses=[
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                        ],
                    ),
                    Contact(
                        relationship=[Relationship.SELF, Relationship.SELF],
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                        addresses=[
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                        ],
                    ),
                ],
                general_practitioners=[
                    ExternalProvider(
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                    ),
                    ExternalProvider(
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                    ),
                ],
                filing_order=FilingOrder(
                    coverages=[
                        uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                        uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                    ],
                ),
                mrn="mrn",
            ),
        )
        """
        _response = self._raw_client.create_with_mrn(
            request=request, skip_duplicate_check=skip_duplicate_check, request_options=request_options
        )
        return _response.data

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        mrn: typing.Optional[str] = None,
        page_token: typing.Optional[PageToken] = None,
        sort_field: typing.Optional[PatientSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientPage:
        """
        Searches for patients that match the query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]

        mrn : typing.Optional[str]

        page_token : typing.Optional[PageToken]

        sort_field : typing.Optional[PatientSortField]

        sort_direction : typing.Optional[SortDirection]
            Defaults to ascending.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.get_multi()
        """
        _response = self._raw_client.get_multi(
            limit=limit,
            mrn=mrn,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            request_options=request_options,
        )
        return _response.data

    def search_providers(
        self, *, search_criteria: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ExternalProvider]:
        """
        Searches for referring providers that match the query parameters.  The search is case-insensitive, supports fuzzy matching, and matches against provider name and NPI. The search criteria must be an alphanumeric string, and the search is limited to the first 20 results.

        Parameters
        ----------
        search_criteria : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ExternalProvider]

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.search_providers(
            search_criteria="search_criteria",
        )
        """
        _response = self._raw_client.search_providers(search_criteria=search_criteria, request_options=request_options)
        return _response.data

    def get(self, id: PatientId, *, request_options: typing.Optional[RequestOptions] = None) -> Patient:
        """
        Gets a patient.

        Parameters
        ----------
        id : PatientId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def get_history(
        self, id: PatientId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Patient]:
        """
        Gets a patient along with it's full history.  The return list is ordered by version ascending.

        Parameters
        ----------
        id : PatientId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Patient]

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.get_history(
            id="id",
        )
        """
        _response = self._raw_client.get_history(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: PatientId,
        version: str,
        *,
        request: MutablePatient,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Updates a patient.  The path must contain the most recent version to prevent race conditions.  Updating historic versions is not supported.

        Parameters
        ----------
        id : PatientId

        version : str

        request : MutablePatient

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import datetime
        import uuid

        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            Address,
            AddressUse,
            ContactPoint,
            ContactPointUse,
            ExternalProvider,
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.patients.resources.v_1 import (
            Contact,
            FilingOrder,
            MutablePatient,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.update(
            id="id",
            version="version",
            request=MutablePatient(
                name=HumanName(
                    family="family",
                    given=["given", "given"],
                    use=NameUse.USUAL,
                ),
                other_names=[
                    HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                    HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                ],
                birth_date=datetime.date.fromisoformat(
                    "2023-01-15",
                ),
                biological_sex=Sex.FEMALE,
                primary_address=Address(
                    use=AddressUse.HOME,
                    line=["line", "line"],
                    city="city",
                    state="state",
                    postal_code="postal_code",
                    country="country",
                ),
                other_addresses=[
                    Address(
                        use=AddressUse.HOME,
                        line=["line", "line"],
                        city="city",
                        state="state",
                        postal_code="postal_code",
                        country="country",
                    ),
                    Address(
                        use=AddressUse.HOME,
                        line=["line", "line"],
                        city="city",
                        state="state",
                        postal_code="postal_code",
                        country="country",
                    ),
                ],
                primary_telecom=ContactPoint(
                    value="value",
                    use=ContactPointUse.HOME,
                ),
                other_telecoms=[
                    ContactPoint(
                        value="value",
                        use=ContactPointUse.HOME,
                    ),
                    ContactPoint(
                        value="value",
                        use=ContactPointUse.HOME,
                    ),
                ],
                contacts=[
                    Contact(
                        relationship=[Relationship.SELF, Relationship.SELF],
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                        addresses=[
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                        ],
                    ),
                    Contact(
                        relationship=[Relationship.SELF, Relationship.SELF],
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                        addresses=[
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                            Address(
                                use=AddressUse.HOME,
                                line=["line", "line"],
                                city="city",
                                state="state",
                                postal_code="postal_code",
                                country="country",
                            ),
                        ],
                    ),
                ],
                general_practitioners=[
                    ExternalProvider(
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                    ),
                    ExternalProvider(
                        name=HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        telecoms=[
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                            ContactPoint(
                                value="value",
                                use=ContactPointUse.HOME,
                            ),
                        ],
                    ),
                ],
                filing_order=FilingOrder(
                    coverages=[
                        uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                        uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                    ],
                ),
            ),
        )
        """
        _response = self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    def deactivate(
        self, id: PatientId, version: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Sets a patient as deactivated.  The path must contain the most recent version plus 1 to prevent race conditions.  Deactivating historic versions is not supported.

        Parameters
        ----------
        id : PatientId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.deactivate(
            id="id",
            version="version",
        )
        """
        _response = self._raw_client.deactivate(id, version, request_options=request_options)
        return _response.data

    def reactivate(
        self, id: PatientId, version: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Removes the deactivated flag for a patient.  The path must contain the most recent version plus 1 to prevent race conditions.  Reactivating historic versions is not supported.

        Parameters
        ----------
        id : PatientId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.reactivate(
            id="id",
            version="version",
        )
        """
        _response = self._raw_client.reactivate(id, version, request_options=request_options)
        return _response.data

    def search(
        self,
        *,
        mrn: typing.Optional[str] = None,
        similar_name_ordering: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Patient]:
        """
        Returns a list of Patients based on the search criteria.

        Parameters
        ----------
        mrn : typing.Optional[str]

        similar_name_ordering : typing.Optional[str]
            A string that is used to order similar names in search results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Patient]

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.search()
        """
        _response = self._raw_client.search(
            mrn=mrn, similar_name_ordering=similar_name_ordering, request_options=request_options
        )
        return _response.data

    def scan(
        self, *, since: dt.datetime, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Patient]:
        """
        Scans up to 100 patient updates.  The since query parameter is inclusive, and the result list is ordered by updatedAt ascending.

        Parameters
        ----------
        since : dt.datetime

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Patient]

        Examples
        --------
        import datetime

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.patients.v_1.scan(
            since=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
        )
        """
        _response = self._raw_client.scan(since=since, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def create(
        self,
        *,
        request: MutablePatient,
        skip_duplicate_check: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Adds a patient.  VersionConflictError is returned when the patient's external ID is already in use.

        Parameters
        ----------
        request : MutablePatient

        skip_duplicate_check : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import asyncio
        import datetime
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            Address,
            AddressUse,
            ContactPoint,
            ContactPointUse,
            ExternalProvider,
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.patients.resources.v_1 import (
            Contact,
            FilingOrder,
            MutablePatient,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.create(
                request=MutablePatient(
                    name=HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                    other_names=[
                        HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                    ],
                    birth_date=datetime.date.fromisoformat(
                        "2023-01-15",
                    ),
                    biological_sex=Sex.FEMALE,
                    primary_address=Address(
                        use=AddressUse.HOME,
                        line=["line", "line"],
                        city="city",
                        state="state",
                        postal_code="postal_code",
                        country="country",
                    ),
                    other_addresses=[
                        Address(
                            use=AddressUse.HOME,
                            line=["line", "line"],
                            city="city",
                            state="state",
                            postal_code="postal_code",
                            country="country",
                        ),
                        Address(
                            use=AddressUse.HOME,
                            line=["line", "line"],
                            city="city",
                            state="state",
                            postal_code="postal_code",
                            country="country",
                        ),
                    ],
                    primary_telecom=ContactPoint(
                        value="value",
                        use=ContactPointUse.HOME,
                    ),
                    other_telecoms=[
                        ContactPoint(
                            value="value",
                            use=ContactPointUse.HOME,
                        ),
                        ContactPoint(
                            value="value",
                            use=ContactPointUse.HOME,
                        ),
                    ],
                    contacts=[
                        Contact(
                            relationship=[Relationship.SELF, Relationship.SELF],
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                            addresses=[
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                            ],
                        ),
                        Contact(
                            relationship=[Relationship.SELF, Relationship.SELF],
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                            addresses=[
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                            ],
                        ),
                    ],
                    general_practitioners=[
                        ExternalProvider(
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                        ),
                        ExternalProvider(
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                        ),
                    ],
                    filing_order=FilingOrder(
                        coverages=[
                            uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            ),
                            uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            ),
                        ],
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            request=request, skip_duplicate_check=skip_duplicate_check, request_options=request_options
        )
        return _response.data

    async def create_with_mrn(
        self,
        *,
        request: MutablePatientWithMrn,
        skip_duplicate_check: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Adds a patient and hydrates their MRN with a pre-existing MRN.  Once this patient is created their MRN will not be editable. BadRequestError is returned when the MRN is greater than 20 characters. VersionConflictError is returned when the patient's external ID is already in use.

        Parameters
        ----------
        request : MutablePatientWithMrn

        skip_duplicate_check : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import asyncio
        import datetime
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            Address,
            AddressUse,
            ContactPoint,
            ContactPointUse,
            ExternalProvider,
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.patients.resources.v_1 import (
            Contact,
            FilingOrder,
            MutablePatientWithMrn,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.create_with_mrn(
                request=MutablePatientWithMrn(
                    name=HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                    other_names=[
                        HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                    ],
                    birth_date=datetime.date.fromisoformat(
                        "2023-01-15",
                    ),
                    biological_sex=Sex.FEMALE,
                    primary_address=Address(
                        use=AddressUse.HOME,
                        line=["line", "line"],
                        city="city",
                        state="state",
                        postal_code="postal_code",
                        country="country",
                    ),
                    other_addresses=[
                        Address(
                            use=AddressUse.HOME,
                            line=["line", "line"],
                            city="city",
                            state="state",
                            postal_code="postal_code",
                            country="country",
                        ),
                        Address(
                            use=AddressUse.HOME,
                            line=["line", "line"],
                            city="city",
                            state="state",
                            postal_code="postal_code",
                            country="country",
                        ),
                    ],
                    primary_telecom=ContactPoint(
                        value="value",
                        use=ContactPointUse.HOME,
                    ),
                    other_telecoms=[
                        ContactPoint(
                            value="value",
                            use=ContactPointUse.HOME,
                        ),
                        ContactPoint(
                            value="value",
                            use=ContactPointUse.HOME,
                        ),
                    ],
                    contacts=[
                        Contact(
                            relationship=[Relationship.SELF, Relationship.SELF],
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                            addresses=[
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                            ],
                        ),
                        Contact(
                            relationship=[Relationship.SELF, Relationship.SELF],
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                            addresses=[
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                            ],
                        ),
                    ],
                    general_practitioners=[
                        ExternalProvider(
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                        ),
                        ExternalProvider(
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                        ),
                    ],
                    filing_order=FilingOrder(
                        coverages=[
                            uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            ),
                            uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            ),
                        ],
                    ),
                    mrn="mrn",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_with_mrn(
            request=request, skip_duplicate_check=skip_duplicate_check, request_options=request_options
        )
        return _response.data

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        mrn: typing.Optional[str] = None,
        page_token: typing.Optional[PageToken] = None,
        sort_field: typing.Optional[PatientSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatientPage:
        """
        Searches for patients that match the query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]

        mrn : typing.Optional[str]

        page_token : typing.Optional[PageToken]

        sort_field : typing.Optional[PatientSortField]

        sort_direction : typing.Optional[SortDirection]
            Defaults to ascending.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatientPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            limit=limit,
            mrn=mrn,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            request_options=request_options,
        )
        return _response.data

    async def search_providers(
        self, *, search_criteria: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ExternalProvider]:
        """
        Searches for referring providers that match the query parameters.  The search is case-insensitive, supports fuzzy matching, and matches against provider name and NPI. The search criteria must be an alphanumeric string, and the search is limited to the first 20 results.

        Parameters
        ----------
        search_criteria : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ExternalProvider]

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.search_providers(
                search_criteria="search_criteria",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_providers(
            search_criteria=search_criteria, request_options=request_options
        )
        return _response.data

    async def get(self, id: PatientId, *, request_options: typing.Optional[RequestOptions] = None) -> Patient:
        """
        Gets a patient.

        Parameters
        ----------
        id : PatientId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def get_history(
        self, id: PatientId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Patient]:
        """
        Gets a patient along with it's full history.  The return list is ordered by version ascending.

        Parameters
        ----------
        id : PatientId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Patient]

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.get_history(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_history(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: PatientId,
        version: str,
        *,
        request: MutablePatient,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Patient:
        """
        Updates a patient.  The path must contain the most recent version to prevent race conditions.  Updating historic versions is not supported.

        Parameters
        ----------
        id : PatientId

        version : str

        request : MutablePatient

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Patient

        Examples
        --------
        import asyncio
        import datetime
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.common import (
            Address,
            AddressUse,
            ContactPoint,
            ContactPointUse,
            ExternalProvider,
            HumanName,
            NameUse,
            Relationship,
            Sex,
        )
        from candid.resources.pre_encounter.resources.patients.resources.v_1 import (
            Contact,
            FilingOrder,
            MutablePatient,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.update(
                id="id",
                version="version",
                request=MutablePatient(
                    name=HumanName(
                        family="family",
                        given=["given", "given"],
                        use=NameUse.USUAL,
                    ),
                    other_names=[
                        HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                        HumanName(
                            family="family",
                            given=["given", "given"],
                            use=NameUse.USUAL,
                        ),
                    ],
                    birth_date=datetime.date.fromisoformat(
                        "2023-01-15",
                    ),
                    biological_sex=Sex.FEMALE,
                    primary_address=Address(
                        use=AddressUse.HOME,
                        line=["line", "line"],
                        city="city",
                        state="state",
                        postal_code="postal_code",
                        country="country",
                    ),
                    other_addresses=[
                        Address(
                            use=AddressUse.HOME,
                            line=["line", "line"],
                            city="city",
                            state="state",
                            postal_code="postal_code",
                            country="country",
                        ),
                        Address(
                            use=AddressUse.HOME,
                            line=["line", "line"],
                            city="city",
                            state="state",
                            postal_code="postal_code",
                            country="country",
                        ),
                    ],
                    primary_telecom=ContactPoint(
                        value="value",
                        use=ContactPointUse.HOME,
                    ),
                    other_telecoms=[
                        ContactPoint(
                            value="value",
                            use=ContactPointUse.HOME,
                        ),
                        ContactPoint(
                            value="value",
                            use=ContactPointUse.HOME,
                        ),
                    ],
                    contacts=[
                        Contact(
                            relationship=[Relationship.SELF, Relationship.SELF],
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                            addresses=[
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                            ],
                        ),
                        Contact(
                            relationship=[Relationship.SELF, Relationship.SELF],
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                            addresses=[
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                                Address(
                                    use=AddressUse.HOME,
                                    line=["line", "line"],
                                    city="city",
                                    state="state",
                                    postal_code="postal_code",
                                    country="country",
                                ),
                            ],
                        ),
                    ],
                    general_practitioners=[
                        ExternalProvider(
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                        ),
                        ExternalProvider(
                            name=HumanName(
                                family="family",
                                given=["given", "given"],
                                use=NameUse.USUAL,
                            ),
                            telecoms=[
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                                ContactPoint(
                                    value="value",
                                    use=ContactPointUse.HOME,
                                ),
                            ],
                        ),
                    ],
                    filing_order=FilingOrder(
                        coverages=[
                            uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            ),
                            uuid.UUID(
                                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                            ),
                        ],
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    async def deactivate(
        self, id: PatientId, version: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Sets a patient as deactivated.  The path must contain the most recent version plus 1 to prevent race conditions.  Deactivating historic versions is not supported.

        Parameters
        ----------
        id : PatientId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.deactivate(
                id="id",
                version="version",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deactivate(id, version, request_options=request_options)
        return _response.data

    async def reactivate(
        self, id: PatientId, version: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Removes the deactivated flag for a patient.  The path must contain the most recent version plus 1 to prevent race conditions.  Reactivating historic versions is not supported.

        Parameters
        ----------
        id : PatientId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.reactivate(
                id="id",
                version="version",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.reactivate(id, version, request_options=request_options)
        return _response.data

    async def search(
        self,
        *,
        mrn: typing.Optional[str] = None,
        similar_name_ordering: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Patient]:
        """
        Returns a list of Patients based on the search criteria.

        Parameters
        ----------
        mrn : typing.Optional[str]

        similar_name_ordering : typing.Optional[str]
            A string that is used to order similar names in search results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Patient]

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.search()


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            mrn=mrn, similar_name_ordering=similar_name_ordering, request_options=request_options
        )
        return _response.data

    async def scan(
        self, *, since: dt.datetime, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Patient]:
        """
        Scans up to 100 patient updates.  The since query parameter is inclusive, and the result list is ordered by updatedAt ascending.

        Parameters
        ----------
        since : dt.datetime

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Patient]

        Examples
        --------
        import asyncio
        import datetime

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.patients.v_1.scan(
                since=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.scan(since=since, request_options=request_options)
        return _response.data
