# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ........core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....common.types.additional_payer_information import AdditionalPayerInformation
from .....common.types.payer_id import PayerId
from .....common.types.period import Period
from .authorization_unit import AuthorizationUnit


class Authorization(UniversalBaseModel):
    payer_id: PayerId
    payer_name: str
    additional_payer_information: typing.Optional[AdditionalPayerInformation] = None
    authorization_number: str
    cpt_code: str
    apply_for_all_cpt_codes: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If true, then the authorization will apply for all claims for the payer that fall in range the `period`.
    """

    no_prior_authorization_required: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If true, indicates that prior authorization is not required and prior authorization number will not be set on the claim for this authorization.
    """

    units: AuthorizationUnit
    quantity: typing.Optional[int] = None
    period: typing.Optional[Period] = None
    notes: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
