# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ........core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....common.types.address import Address
from .....common.types.canonical_non_insurance_payer_association import CanonicalNonInsurancePayerAssociation
from .....common.types.canonical_non_insurance_payer_id import CanonicalNonInsurancePayerId
from .....common.types.contact_point import ContactPoint
from .....common.types.disability_status import DisabilityStatus
from .....common.types.ethnicity import Ethnicity
from .....common.types.external_identifier import ExternalIdentifier
from .....common.types.external_provider import ExternalProvider
from .....common.types.gender import Gender
from .....common.types.human_name import HumanName
from .....common.types.note_id import NoteId
from .....common.types.race import Race
from .....common.types.sex import Sex
from .....common.types.sexual_orientation import SexualOrientation
from .....common.types.tag_id import TagId
from .authorization import Authorization
from .contact import Contact
from .do_not_invoice_reason import DoNotInvoiceReason
from .external_provenance import ExternalProvenance
from .filing_order import FilingOrder
from .guarantor import Guarantor
from .marital_status import MaritalStatus
from .referral import Referral


class MutablePatient(UniversalBaseModel):
    """
    An object representing patient demographics information.
    """

    name: HumanName
    other_names: typing.List[HumanName] = pydantic.Field()
    """
    Other names for the patient.
    """

    other_identifiers: typing.Optional[typing.List[ExternalIdentifier]] = pydantic.Field(default=None)
    """
    Other identifiers for the patient.
    """

    gender: typing.Optional[Gender] = None
    birth_date: dt.date
    social_security_number: typing.Optional[str] = None
    biological_sex: Sex = pydantic.Field()
    """
    The biological sex of the patient. This corresponds to the HL7 AdministrativeGender https://www.hl7.org/fhir/valueset-administrative-gender.html
    """

    sexual_orientation: typing.Optional[SexualOrientation] = pydantic.Field(default=None)
    """
    The sexual orientation of the patient.
    """

    pronouns: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The pronouns of the patient.
    """

    race: typing.Optional[Race] = None
    ethnicity: typing.Optional[Ethnicity] = None
    disability_status: typing.Optional[DisabilityStatus] = None
    marital_status: typing.Optional[MaritalStatus] = None
    deceased: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time of death for the patient.  Leave unset if the patient is not deceased.
    """

    multiple_birth: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of siblings the patient was born with.  Leave unset if the patient was not part of a multiple birth.
    """

    primary_address: Address = pydantic.Field()
    """
    The primary address for the patient.
    """

    other_addresses: typing.List[Address] = pydantic.Field()
    """
    Other addresses for the patient.
    """

    primary_telecom: ContactPoint = pydantic.Field()
    """
    The primary phone number for the patient.
    """

    other_telecoms: typing.List[ContactPoint] = pydantic.Field()
    """
    Other phone numbers for the patient.
    """

    email: typing.Optional[str] = None
    electronic_communication_opt_in: typing.Optional[bool] = None
    photo: typing.Optional[str] = None
    language: typing.Optional[str] = None
    external_provenance: typing.Optional[ExternalProvenance] = pydantic.Field(default=None)
    """
    Information about the upstream system that owns this patient data.  Leave unset if Candid owns patient data.
    """

    contacts: typing.List[Contact] = pydantic.Field()
    """
    Contacts for the patient.
    """

    general_practitioners: typing.List[ExternalProvider]
    filing_order: FilingOrder
    non_insurance_payers: typing.Optional[typing.List[CanonicalNonInsurancePayerId]] = None
    non_insurance_payer_associations: typing.Optional[typing.List[CanonicalNonInsurancePayerAssociation]] = None
    guarantor: typing.Optional[Guarantor] = None
    self_pay: typing.Optional[bool] = None
    authorizations: typing.Optional[typing.List[Authorization]] = None
    referrals: typing.Optional[typing.List[Referral]] = None
    primary_service_facility_id: typing.Optional[str] = None
    do_not_invoice_reason: typing.Optional[DoNotInvoiceReason] = pydantic.Field(default=None)
    """
    If this value is defined, the customer will not be invoiced.
    """

    note_ids: typing.Optional[typing.List[NoteId]] = None
    tag_ids: typing.Optional[typing.List[TagId]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
