# This file was auto-generated by Fern from our API Definition.

import typing

from .......core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .......core.request_options import RequestOptions
from ....common.types.page_token import PageToken
from ....common.types.tag_id import TagId
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.mutable_tag import MutableTag
from .types.tag import Tag
from .types.tag_page import TagPage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def get(self, id: TagId, *, request_options: typing.Optional[RequestOptions] = None) -> Tag:
        """
        Gets a tag by TagId.

        Parameters
        ----------
        id : TagId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.tags.v_1.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TagPage:
        """
        Gets all tags. Defaults to page size of 1000.

        Parameters
        ----------
        limit : typing.Optional[int]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.tags.v_1.get_all()
        """
        _response = self._raw_client.get_all(limit=limit, page_token=page_token, request_options=request_options)
        return _response.data

    def create(self, *, request: MutableTag, request_options: typing.Optional[RequestOptions] = None) -> Tag:
        """
        Adds a new tag if it does not already exist, otherwise, returns the existing tag.

        Parameters
        ----------
        request : MutableTag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.tags.resources.v_1 import (
            MutableTag,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.tags.v_1.create(
            request=MutableTag(
                value="value",
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self, id: TagId, version: str, *, request: MutableTag, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        Updates a tag. The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : TagId

        version : str

        request : MutableTag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag

        Examples
        --------
        from candid import CandidApiClient
        from candid.resources.pre_encounter.resources.tags.resources.v_1 import (
            MutableTag,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.tags.v_1.update(
            id="id",
            version="version",
            request=MutableTag(
                value="value",
            ),
        )
        """
        _response = self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    def deactivate(self, id: TagId, version: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Sets a tag as deactivated.  The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : TagId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.pre_encounter.tags.v_1.deactivate(
            id="id",
            version="version",
        )
        """
        _response = self._raw_client.deactivate(id, version, request_options=request_options)
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def get(self, id: TagId, *, request_options: typing.Optional[RequestOptions] = None) -> Tag:
        """
        Gets a tag by TagId.

        Parameters
        ----------
        id : TagId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.tags.v_1.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TagPage:
        """
        Gets all tags. Defaults to page size of 1000.

        Parameters
        ----------
        limit : typing.Optional[int]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.tags.v_1.get_all()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_all(limit=limit, page_token=page_token, request_options=request_options)
        return _response.data

    async def create(self, *, request: MutableTag, request_options: typing.Optional[RequestOptions] = None) -> Tag:
        """
        Adds a new tag if it does not already exist, otherwise, returns the existing tag.

        Parameters
        ----------
        request : MutableTag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.tags.resources.v_1 import (
            MutableTag,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.tags.v_1.create(
                request=MutableTag(
                    value="value",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self, id: TagId, version: str, *, request: MutableTag, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        Updates a tag. The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : TagId

        version : str

        request : MutableTag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient
        from candid.resources.pre_encounter.resources.tags.resources.v_1 import (
            MutableTag,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.tags.v_1.update(
                id="id",
                version="version",
                request=MutableTag(
                    value="value",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, version, request=request, request_options=request_options)
        return _response.data

    async def deactivate(
        self, id: TagId, version: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Sets a tag as deactivated.  The path must contain the most recent version to prevent races.

        Parameters
        ----------
        id : TagId

        version : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.pre_encounter.tags.v_1.deactivate(
                id="id",
                version="version",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deactivate(id, version, request_options=request_options)
        return _response.data
