# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawServiceFacilityClient, RawServiceFacilityClient
from .types.encounter_service_facility import EncounterServiceFacility
from .types.encounter_service_facility_update import EncounterServiceFacilityUpdate
from .types.service_facility_id import ServiceFacilityId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ServiceFacilityClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawServiceFacilityClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawServiceFacilityClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawServiceFacilityClient
        """
        return self._raw_client

    def update(
        self,
        service_facility_id: ServiceFacilityId,
        *,
        request: EncounterServiceFacilityUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterServiceFacility:
        """
        Parameters
        ----------
        service_facility_id : ServiceFacilityId

        request : EncounterServiceFacilityUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterServiceFacility

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.service_facility import EncounterServiceFacilityUpdate

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.service_facility.update(
            service_facility_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=EncounterServiceFacilityUpdate(),
        )
        """
        _response = self._raw_client.update(service_facility_id, request=request, request_options=request_options)
        return _response.data


class AsyncServiceFacilityClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawServiceFacilityClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawServiceFacilityClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawServiceFacilityClient
        """
        return self._raw_client

    async def update(
        self,
        service_facility_id: ServiceFacilityId,
        *,
        request: EncounterServiceFacilityUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EncounterServiceFacility:
        """
        Parameters
        ----------
        service_facility_id : ServiceFacilityId

        request : EncounterServiceFacilityUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EncounterServiceFacility

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.service_facility import EncounterServiceFacilityUpdate

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.service_facility.update(
                service_facility_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=EncounterServiceFacilityUpdate(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(service_facility_id, request=request, request_options=request_options)
        return _response.data
