# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from .types.encounter_service_facility import EncounterServiceFacility
from .types.encounter_service_facility_update import EncounterServiceFacilityUpdate
from .types.service_facility_id import ServiceFacilityId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawServiceFacilityClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def update(
        self,
        service_facility_id: ServiceFacilityId,
        *,
        request: EncounterServiceFacilityUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EncounterServiceFacility]:
        """
        Parameters
        ----------
        service_facility_id : ServiceFacilityId

        request : EncounterServiceFacilityUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EncounterServiceFacility]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/service_facility/v2/{jsonable_encoder(service_facility_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterServiceFacility,
                parse_obj_as(
                    type_=EncounterServiceFacility,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawServiceFacilityClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def update(
        self,
        service_facility_id: ServiceFacilityId,
        *,
        request: EncounterServiceFacilityUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EncounterServiceFacility]:
        """
        Parameters
        ----------
        service_facility_id : ServiceFacilityId

        request : EncounterServiceFacilityUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EncounterServiceFacility]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/service_facility/v2/{jsonable_encoder(service_facility_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                EncounterServiceFacility,
                parse_obj_as(
                    type_=EncounterServiceFacility,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
