# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.service_line_id import ServiceLineId
from .raw_client import AsyncRawV2Client, RawV2Client
from .types.service_line import ServiceLine
from .types.service_line_create_standalone import ServiceLineCreateStandalone
from .types.service_line_update import ServiceLineUpdate

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V2Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV2Client
        """
        return self._raw_client

    def create(
        self, *, request: ServiceLineCreateStandalone, request_options: typing.Optional[RequestOptions] = None
    ) -> ServiceLine:
        """
        Parameters
        ----------
        request : ServiceLineCreateStandalone

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ServiceLine

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.commons import ServiceLineUnits
        from candid.resources.service_lines.resources.v_2 import (
            ServiceLineCreateStandalone,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.service_lines.v_2.create(
            request=ServiceLineCreateStandalone(
                procedure_code="procedure_code",
                quantity="quantity",
                units=ServiceLineUnits.MJ,
                claim_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self,
        service_line_id: ServiceLineId,
        *,
        request: ServiceLineUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ServiceLine:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : ServiceLineUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ServiceLine

        Examples
        --------
        import uuid

        from candid import CandidApiClient
        from candid.resources.service_lines.resources.v_2 import ServiceLineUpdate

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.service_lines.v_2.update(
            service_line_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            request=ServiceLineUpdate(),
        )
        """
        _response = self._raw_client.update(service_line_id, request=request, request_options=request_options)
        return _response.data

    def delete(
        self, service_line_id: ServiceLineId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.service_lines.v_2.delete(
            service_line_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete(service_line_id, request_options=request_options)
        return _response.data


class AsyncV2Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV2Client
        """
        return self._raw_client

    async def create(
        self, *, request: ServiceLineCreateStandalone, request_options: typing.Optional[RequestOptions] = None
    ) -> ServiceLine:
        """
        Parameters
        ----------
        request : ServiceLineCreateStandalone

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ServiceLine

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.commons import ServiceLineUnits
        from candid.resources.service_lines.resources.v_2 import (
            ServiceLineCreateStandalone,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.service_lines.v_2.create(
                request=ServiceLineCreateStandalone(
                    procedure_code="procedure_code",
                    quantity="quantity",
                    units=ServiceLineUnits.MJ,
                    claim_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self,
        service_line_id: ServiceLineId,
        *,
        request: ServiceLineUpdate,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ServiceLine:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request : ServiceLineUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ServiceLine

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.service_lines.resources.v_2 import ServiceLineUpdate

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.service_lines.v_2.update(
                service_line_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                request=ServiceLineUpdate(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(service_line_id, request=request, request_options=request_options)
        return _response.data

    async def delete(
        self, service_line_id: ServiceLineId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        service_line_id : ServiceLineId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.service_lines.v_2.delete(
                service_line_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(service_line_id, request_options=request_options)
        return _response.data
