# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class DenialReasonContent(str, enum.Enum):
    AUTHORIZATION_REQUIRED = "Authorization Required"
    REFERRAL_REQUIRED = "Referral Required"
    MEDICAL_RECORDS_REQUESTED = "Medical Records Requested"
    TIMELY_FILING = "Timely Filing"
    DUPLICATE_CLAIM = "Duplicate Claim"
    FULL_CONTRACTUAL_ADJUSTMENT = "Full Contractual Adjustment"
    INCORRECT_PLACE_OF_SERVICE = "Incorrect Place of Service"
    INCORRECT_PATIENT_GENDER = "Incorrect Patient Gender"
    INCORRECT_PATIENT_INFO = "Incorrect Patient Info"
    BUNDLED = "Bundled"
    EXCEEDED_BILLABLE_TIME = "Exceeded Billable Time"
    INVALID_PROVIDER_INFORMATION = "Invalid Provider Information"
    INVALID_DIAGNOSIS_CODE = "Invalid Diagnosis Code"
    INCORRECT_PROCEDURE_CODE = "Incorrect Procedure Code"
    INVALID_MODIFIER = "Invalid Modifier"
    MISSING_NDC_CODE = "Missing NDC Code"
    INVALID_INSURANCE_DATA = "Invalid Insurance Data"
    NO_ACTIVE_COVERAGE = "No Active Coverage"
    COORDINATION_OF_BENEFITS = "Coordination of Benefits"
    INCORRECT_PAYER = "Incorrect Payer"
    CREDENTIALING = "Credentialing"
    NO_EFFECTIVE_CONTRACT = "No Effective Contract"
    MISSING_W_9 = "Missing W-9"
    MISSING_CONTRACT_LINKAGE = "Missing Contract Linkage"
    NON_COVERED_BENEFIT = "Non-Covered Benefit"
    EXPERIMENTAL_PROCEDURE = "Experimental Procedure"
    NOT_MEDICALLY_NECESSARY = "Not Medically Necessary"
    INFO_REQUESTED_FROM_PROVIDER = "Info Requested from Provider"
    INFO_REQUESTED_FROM_PATIENT = "Info Requested from Patient"
    BILLING_ERROR = "Billing Error"
    UNKNOWN = "Unknown"
    MAX_BENEFIT_REACHED = "Max Benefit Reached"
    _UNKNOWN = "__DENIALREASONCONTENT_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "DenialReasonContent":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        authorization_required: typing.Callable[[], T_Result],
        referral_required: typing.Callable[[], T_Result],
        medical_records_requested: typing.Callable[[], T_Result],
        timely_filing: typing.Callable[[], T_Result],
        duplicate_claim: typing.Callable[[], T_Result],
        full_contractual_adjustment: typing.Callable[[], T_Result],
        incorrect_place_of_service: typing.Callable[[], T_Result],
        incorrect_patient_gender: typing.Callable[[], T_Result],
        incorrect_patient_info: typing.Callable[[], T_Result],
        bundled: typing.Callable[[], T_Result],
        exceeded_billable_time: typing.Callable[[], T_Result],
        invalid_provider_information: typing.Callable[[], T_Result],
        invalid_diagnosis_code: typing.Callable[[], T_Result],
        incorrect_procedure_code: typing.Callable[[], T_Result],
        invalid_modifier: typing.Callable[[], T_Result],
        missing_ndc_code: typing.Callable[[], T_Result],
        invalid_insurance_data: typing.Callable[[], T_Result],
        no_active_coverage: typing.Callable[[], T_Result],
        coordination_of_benefits: typing.Callable[[], T_Result],
        incorrect_payer: typing.Callable[[], T_Result],
        credentialing: typing.Callable[[], T_Result],
        no_effective_contract: typing.Callable[[], T_Result],
        missing_w_9: typing.Callable[[], T_Result],
        missing_contract_linkage: typing.Callable[[], T_Result],
        non_covered_benefit: typing.Callable[[], T_Result],
        experimental_procedure: typing.Callable[[], T_Result],
        not_medically_necessary: typing.Callable[[], T_Result],
        info_requested_from_provider: typing.Callable[[], T_Result],
        info_requested_from_patient: typing.Callable[[], T_Result],
        billing_error: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
        max_benefit_reached: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is DenialReasonContent.AUTHORIZATION_REQUIRED:
            return authorization_required()
        if self is DenialReasonContent.REFERRAL_REQUIRED:
            return referral_required()
        if self is DenialReasonContent.MEDICAL_RECORDS_REQUESTED:
            return medical_records_requested()
        if self is DenialReasonContent.TIMELY_FILING:
            return timely_filing()
        if self is DenialReasonContent.DUPLICATE_CLAIM:
            return duplicate_claim()
        if self is DenialReasonContent.FULL_CONTRACTUAL_ADJUSTMENT:
            return full_contractual_adjustment()
        if self is DenialReasonContent.INCORRECT_PLACE_OF_SERVICE:
            return incorrect_place_of_service()
        if self is DenialReasonContent.INCORRECT_PATIENT_GENDER:
            return incorrect_patient_gender()
        if self is DenialReasonContent.INCORRECT_PATIENT_INFO:
            return incorrect_patient_info()
        if self is DenialReasonContent.BUNDLED:
            return bundled()
        if self is DenialReasonContent.EXCEEDED_BILLABLE_TIME:
            return exceeded_billable_time()
        if self is DenialReasonContent.INVALID_PROVIDER_INFORMATION:
            return invalid_provider_information()
        if self is DenialReasonContent.INVALID_DIAGNOSIS_CODE:
            return invalid_diagnosis_code()
        if self is DenialReasonContent.INCORRECT_PROCEDURE_CODE:
            return incorrect_procedure_code()
        if self is DenialReasonContent.INVALID_MODIFIER:
            return invalid_modifier()
        if self is DenialReasonContent.MISSING_NDC_CODE:
            return missing_ndc_code()
        if self is DenialReasonContent.INVALID_INSURANCE_DATA:
            return invalid_insurance_data()
        if self is DenialReasonContent.NO_ACTIVE_COVERAGE:
            return no_active_coverage()
        if self is DenialReasonContent.COORDINATION_OF_BENEFITS:
            return coordination_of_benefits()
        if self is DenialReasonContent.INCORRECT_PAYER:
            return incorrect_payer()
        if self is DenialReasonContent.CREDENTIALING:
            return credentialing()
        if self is DenialReasonContent.NO_EFFECTIVE_CONTRACT:
            return no_effective_contract()
        if self is DenialReasonContent.MISSING_W_9:
            return missing_w_9()
        if self is DenialReasonContent.MISSING_CONTRACT_LINKAGE:
            return missing_contract_linkage()
        if self is DenialReasonContent.NON_COVERED_BENEFIT:
            return non_covered_benefit()
        if self is DenialReasonContent.EXPERIMENTAL_PROCEDURE:
            return experimental_procedure()
        if self is DenialReasonContent.NOT_MEDICALLY_NECESSARY:
            return not_medically_necessary()
        if self is DenialReasonContent.INFO_REQUESTED_FROM_PROVIDER:
            return info_requested_from_provider()
        if self is DenialReasonContent.INFO_REQUESTED_FROM_PATIENT:
            return info_requested_from_patient()
        if self is DenialReasonContent.BILLING_ERROR:
            return billing_error()
        if self is DenialReasonContent.UNKNOWN:
            return unknown()
        if self is DenialReasonContent.MAX_BENEFIT_REACHED:
            return max_benefit_reached()
        return _unknown_member(self._value_)
