# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ServiceIdQualifier(str, enum.Enum):
    EAN_UCC_13 = "EN"
    """
    EAN/UCC - 13
    """

    EAN_UCC_8 = "EO"
    """
    EAN/UCC - 8
    """

    HIBC = "HI"
    """
    HIBC (Health Care Industry Bar Code) Supplier Labeling Standard Primary Data Message
    """

    NDC_5_4_2_FORMAT = "N4"
    """
    National Drug Code in 5-4-2 Format
    """

    CUSTOMER_ORDER_NUMBER = "ON"
    """
    Customer Order Number
    """

    GTIN = "UK"
    """
    GTIN 14-digit Data Structure
    """

    UCC_12 = "UP"
    """
    UCC - 12
    """

    _UNKNOWN = "__SERVICEIDQUALIFIER_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ServiceIdQualifier":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        ean_ucc_13: typing.Callable[[], T_Result],
        ean_ucc_8: typing.Callable[[], T_Result],
        hibc: typing.Callable[[], T_Result],
        ndc_5_4_2_format: typing.Callable[[], T_Result],
        customer_order_number: typing.Callable[[], T_Result],
        gtin: typing.Callable[[], T_Result],
        ucc_12: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ServiceIdQualifier.EAN_UCC_13:
            return ean_ucc_13()
        if self is ServiceIdQualifier.EAN_UCC_8:
            return ean_ucc_8()
        if self is ServiceIdQualifier.HIBC:
            return hibc()
        if self is ServiceIdQualifier.NDC_5_4_2_FORMAT:
            return ndc_5_4_2_format()
        if self is ServiceIdQualifier.CUSTOMER_ORDER_NUMBER:
            return customer_order_number()
        if self is ServiceIdQualifier.GTIN:
            return gtin()
        if self is ServiceIdQualifier.UCC_12:
            return ucc_12()
        return _unknown_member(self._value_)
