# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.decimal import Decimal
from .....commons.types.facility_type_code import FacilityTypeCode
from .....commons.types.procedure_modifier import ProcedureModifier
from .....commons.types.service_line_units import ServiceLineUnits
from .....encounter_providers.resources.v_2.types.ordering_provider_optional import OrderingProviderOptional
from .drug_identification_optional import DrugIdentificationOptional
from .test_result_optional import TestResultOptional


class ServiceLineCreateOptional(UniversalBaseModel):
    modifiers: typing.Optional[typing.List[ProcedureModifier]] = None
    has_epsdt_indicator: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Maps to SV1-11 on the 837-P and Box 24H on the CMS-1500.
    If the value is true, the box will be populated with "Y". Otherwise, the box will not be populated.
    """

    has_family_planning_indicator: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Maps to SV1-12 on the 837-P and Box 24I on the CMS-1500.
    If the value is true, the box will be populated with "Y". Otherwise, the box will not be populated.
    """

    procedure_code: typing.Optional[str] = None
    quantity: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    String representation of a Decimal that can be parsed by most libraries.
    A ServiceLine quantity cannot contain more than one digit of precision.
    Example: 1.1 is valid, 1.11 is not.
    """

    units: typing.Optional[ServiceLineUnits] = None
    charge_amount_cents: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total amount charged for this service line taking quantity into account. For example, if a single unit
    costs 100 cents and 2 units were rendered, the `charge_amount_cents` should be 200. Should be greater than or
    equal to 0.
    """

    diagnosis_pointers: typing.Optional[typing.List[int]] = pydantic.Field(default=None)
    """
    Indices (zero-indexed) of all the diagnoses this service line references
    """

    drug_identification: typing.Optional[DrugIdentificationOptional] = None
    place_of_service_code: typing.Optional[FacilityTypeCode] = pydantic.Field(default=None)
    """
    837p Loop2300, SV105. If your organization does not intend to submit claims with a different place of service at the service line level, this field should not be populated. 02 for telemedicine, 11 for in-person. Full list [here](https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set).
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A free-form description to clarify the related data elements and their content. Maps to SV1-01, C003-07 on the 837-P.
    """

    date_of_service: typing.Optional[dt.date] = None
    end_date_of_service: typing.Optional[dt.date] = None
    ordering_provider: typing.Optional[OrderingProviderOptional] = pydantic.Field(default=None)
    """
    Required when the service or supply was ordered by a provider who is different than the rendering provider for this service line.
    If not required by this implementation guide, do not send.
    """

    test_results: typing.Optional[typing.List[TestResultOptional]] = pydantic.Field(default=None)
    """
    Contains a list of test results. Test result types may map to MEA-02 on the 837-P (ex: Hemoglobin, Hematocrit).
    No more than 5 MEA-02 test results may be submitted per service line.
    """

    note: typing.Optional[str] = pydantic.Field(default=None)
    """
    Maps to NTE02 loop 2400 on the EDI 837.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
