# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawSuperbillsClient, RawSuperbillsClient
from .resources.v_1.client import AsyncV1Client, V1Client


class SuperbillsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSuperbillsClient(client_wrapper=client_wrapper)
        self.v_1 = V1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSuperbillsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSuperbillsClient
        """
        return self._raw_client


class AsyncSuperbillsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSuperbillsClient(client_wrapper=client_wrapper)
        self.v_1 = AsyncV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSuperbillsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSuperbillsClient
        """
        return self._raw_client
